<?php
/**
 * (PEAR) Package configuration file to define authors, version, description, 
 * license and dependencies of Jaws (NOT of all gadgets!)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PackageConfig
 * @package    Jaws
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2007-2008 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
$currDir = dirname(__FILE__);
//Get Jaws version constant
$versionPath = $currDir . DIRECTORY_SEPARATOR . 'html' 
. DIRECTORY_SEPARATOR . 'include' 
. DIRECTORY_SEPARATOR . 'Jaws' 
. DIRECTORY_SEPARATOR . 'Version.php';

require_once $versionPath;
//Build long description
$desc = <<<EOT
Jaws is a Framework and Content Management System for building dynamic web sites. 

It aims to be User Friendly giving ease of use and lots of ways to customize web sites, but at the same time is Developer Frendly, it offers a simple and powerful framework to hack your own modules. Jaws is Free Software under the LGPL for core parts and GPL for the rest.
EOT;

//developer, contributor
$info = array('name'    => 'Jaws',
              'desc'    => $desc,
              'version' => JAWS_VERSION,
              'license' => 'LGPL',
              'authors' => array(array('lead', 'ion', 'Jonathan Hernandez', 'ion@suavizado.com'),
                                 array('lead', 'pfischer', 'Pablo Fischer', 'pablo@pablo.com.mx'),
                                 array('lead', 'afz', 'Ali Fazelzadeh', 'afz@php.net'),
                                 array('developer', 'dufuz', 'Helgi Thormar', 'dufuz@php.net'),
                                 array('developer', 'imcks8', 'Ivan Chavero', 'imcks8@gluch.org.mx'),
                                 array('developer', 'meebey', 'Mirco Bauer', 'meebey@meebey.net'),
                                 array('developer', 'kad', 'Jorge Gallegos', 'kad@blegh.net'),
                                 array('developer', 'amir', 'Amir Mohammad Saied', 'amir@php.net'),
                                 array('contributor', 'davidc', 'David Coallier', 'davidc@php.net'),
                                 array('contributor', 'toxickore', 'Emerson Posadas', 'toxickore@linuxmail.org'),
                                 ),
              'deps'    => array(),
              );
?>