<?php
/**
 * Admin page for jaws
 *
 * @category   Application
 * @package    Core
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Helgi ormar <dufuz@php.net>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
define('JAWS_SCRIPT', 'admin');
define('BASE_SCRIPT', basename(__FILE__));
define('PATH_SCRIPT', dirname(__FILE__));
define('APP_TYPE',    'web');

// Redirect to the installer if JawsConfig can't be found.
if (!file_exists(PATH_SCRIPT . '/config/JawsConfig.php')) {
    header('Location: install/index.php');
    exit;
} else {
    require PATH_SCRIPT . '/config/JawsConfig.php';
}

require_once JAWS_PATH . 'include/Jaws/InitApplication.php';
if (DEBUG_ACTIVATED) {
    // Log start time (microseconds)
    $mtime = microtime();
    $mtime = explode(' ', $mtime);
    $mtime = (double) $mtime[0] + $mtime[1];
    $tstart = $mtime;
}

$GLOBALS['app']->Session->OnlyAdmins();
$GLOBALS['app']->loadClass('ACL', 'Jaws_ACL'); //Only in admin area

$request =& Jaws_Request::getInstance();
$gadget  = $request->get('gadget', 'post');
if (is_null($gadget)) {
    $gadget = $request->get('gadget', 'get');
    $gadget = !is_null($gadget) ? $gadget : '';
}

$action = $request->get('action', 'post');
if (is_null($action)) {
    $action = $request->get('action', 'get');
    $action = !is_null($action) ? $action : '';
}

if ($gadget == 'ControlPanel' && $action == 'ResetLogin') {
    $GLOBALS['app']->Session->Logout();
    header('Location: ' . BASE_SCRIPT);
    exit;
}

$httpAuthEnabled = $GLOBALS['app']->Registry->Get('/config/http_auth') == 'true';
if ($httpAuthEnabled) {
    require_once JAWS_PATH . 'include/Jaws/HTTPAuth.php';
    $httpAuth = new Jaws_HTTPAuth();
}

// Check for login action is requested
if (!$GLOBALS['app']->Session->Logged() &&
    (($gadget == 'ControlPanel' && $action == 'Login') ||
    ($httpAuthEnabled && isset($_SERVER['PHP_AUTH_USER']))))
{
    if ($httpAuthEnabled) {
        $httpAuth->AssignData();
        $user   = $httpAuth->getUsername();
        $passwd = $httpAuth->getPassword();
    } else {
        $user    = $request->get('username', 'post');
        $passwd  = $request->get('password', 'post');
        $crypted = $request->get('usecrypt', 'post');

        if ($GLOBALS['app']->Registry->Get('/crypt/enabled') == 'true' && isset($crypted)) {
            require_once JAWS_PATH . 'include/Jaws/Crypt.php';
            $JCrypt = new Jaws_Crypt();
            $JCrypt->Init();
            $passwd = $JCrypt->rsa->decryptBinary($JCrypt->math->int2bin($passwd), $JCrypt->pvt_key);
            if (Jaws_Error::isError($passwd)) {
                $passwd = '';
            }
        }
    }
    $remember = $request->get('remember', 'post');
    $remember = isset($remember)? true : false;
    $login = $GLOBALS['app']->Session->Login($user, $passwd, $remember);
    if (!Jaws_Error::isError($login)) {
        // Can enter to Control Panel?
        if ($GLOBALS['app']->Session->GetPermission('ControlPanel', 'default')) {
            $redirectTo = $request->get('redirect_to', 'post');
            $redirectTo = isset($redirectTo)? $redirectTo : '';
            if (substr($redirectTo, 0, 1) == '?') {
                $redirectTo = str_replace('&amp;', '&', $redirectTo);
            } else {
                $redirectTo = BASE_SCRIPT;
            }
            header('Location: '.$redirectTo);
            exit;
        } else {
            $GLOBALS['app']->Session->Logout();
            header('Location: ?msg=NOTCP');
            exit;
        }
    } else {
        $loginMsg = $login->GetMessage();
    }
}

// Init layout...
$GLOBALS['app']->InstanceLayout();

// Check if we're not logged...
if (!$GLOBALS['app']->Session->Logged()) {
    //Redirect to the login screen
    if (!isset($loginMsg)) {
        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $msg = $xss->parse($request->get('msg', 'get'));
        $loginMsg = empty($msg)? '' : _t('GLOBAL_ERROR_LOGIN_' . $msg);
    }

    if ($httpAuthEnabled) {
        $httpAuth->showLoginBox();
    } else {
        $cpl = $GLOBALS['app']->LoadGadget('ControlPanel', 'AdminHTML');
        echo $cpl->ShowLoginForm($loginMsg);
    }

    if (DEBUG_ACTIVATED) {
        $GLOBALS['log']->LogStackToScreen();
    }
    exit;
}

// Check for requested gadget
if (isset($gadget) && !empty($gadget)) {
    $ReqGadget = ucfirst($gadget);
    // Convert first letter to ucase to backwards compability
    if (Jaws_Gadget::IsValid($ReqGadget)) {
        $ReqAction = !empty($action) ? $action : 'Admin';
    } else {
        Jaws_Error::Fatal('Invalid requested gadget', __FILE__, __LINE__);
    }
} else {
    $ReqGadget = 'ControlPanel';
    $ReqAction = 'DefaultAction';
}

// Check for permission tu action to execute
//FIXME: I'm unsure about treat an action as a task, it could be useful
//   but I prefer not to do it. -ion
//$GLOBALS['app']->Session->CheckPermission($ReqGadget, $ReqAction);
$isAdminHtml = false;
// Temp hack

$file = JAWS_PATH . 'gadgets/' . $ReqGadget . '/AdminHTML.php';
if (file_exists($file)) {
    $goGadget = $GLOBALS['app']->LoadGadget($ReqGadget, 'AdminHTML');
    $isAdminHtml = true;
} else {
    $goGadget = $GLOBALS['app']->LoadGadget($ReqGadget, 'HTML');
}

if (Jaws_Error::IsError($goGadget)) {
    Jaws_Error::Fatal("Error loading gadget: $ReqGadget", __FILE__, __LINE__);
}

$goGadget->SetAction($ReqAction);
$action = $goGadget->GetAction();
$standAloneAdminMode = $goGadget->isStandAloneAdmin($action);

// If requested action is `stand alone' just print it
if ($standAloneAdminMode) {
    echo $goGadget->Execute();
} else {
    //$GLOBALS['app']->InstanceLayout();
    // If requested action
    if ($goGadget->IsAdmin($action)) {
        $GLOBALS['app']->Layout->LoadControlPanelHead();
        $GLOBALS['app']->Layout->Populate($goGadget, true);
        //$GLOBALS['app']->Layout->PutGadget($goGadget->GetName(), $action, 'main');
    } else {
        Jaws_Error::Fatal("Invalid operation: You can't execute requested action", __FILE__, __LINE__);
    }

    $GLOBALS['app']->Layout->LoadControlPanel($ReqGadget);
    $GLOBALS['app']->Layout->Show();
}

// Sync session
$GLOBALS['app']->Session->Synchronize();

if (DEBUG_ACTIVATED) {
    $client = $request->get('client', 'get');
    if ($action != 'Ajax' && $client === null) {
        // Log generation time
        $mtime = microtime();
        $mtime = explode(' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $totaltime = ($mtime - $tstart);
        $GLOBALS['log']->Log(JAWS_LOG_INFO, "Page was generated in {$totaltime} seconds");
        $GLOBALS['log']->Log(JAWS_LOG_INFO, '[Jaws End] ' . date("M/d/Y H:i:s") . ' : ' . __FILE__ . ' : ' .  __LINE__);
        if (function_exists('memory_get_usage')) {
            $GLOBALS['log']->Log(JAWS_LOG_INFO, 'Memory Usage: ' . round(memory_get_usage() / 1024) . ' KB');
        }
        $GLOBALS['log']->LogStackToScreen();
    }
}
