<?php
/**
 * Banner AJAX API
 *
 * @category   Ajax
 * @package    Banner
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class BannerAdminAjax extends Jaws_Ajax
{
    /**
     * Constructor
     *
     * @access  public
     */
    function BannerAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }

    /**
     * Get a banner info
     *
     * @access  public
     * @param   integer $bid
     * @return  array   Banner Info
     */
    function GetBanner($bid)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $banner = $this->_Model->GetBanner($bid);
        if (Jaws_Error::IsError($banner)) {
            return false; //we need to handle errors on ajax
        }

        return $banner;
    }

    /**
     * Get a list of banners
     *
     * @access  public
     * @param   integer $bid
     * @param   integer  $gid
     * @return  array   Banners list
     */
    function GetBanners($bid = -1, $gid = -1)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $res = $this->_Model->GetBanners($bid, $gid);
        if (Jaws_Error::IsError($res)) {
            return false; //we need to handle errors on ajax
        }

        return $res;
    }

    /**
     * Get a group's info
     *
     * @access  public
     * @return  array    Group's info
     */
    function GetGroup($gid)
    {
        $this->CheckSession('Banner', 'ManageGroups');
        $group = $this->_Model->GetGroup($gid);
        if (Jaws_Error::IsError($group)) {
            return false; //we need to handle errors on ajax
        }

        return $group;
    }

    /**
     * Get a list of groups
     *
     * @access  public
     * @return  array    Groups list
     */
    function GetGroups($gid = -1, $bid = -1, $limit = null, $columns = null)
    {
        $this->CheckSession('Banner', 'ManageGroups');
        $groups = $this->_Model->GetGroups($gid, $bid, $limit, $columns);
        if (Jaws_Error::IsError($groups)) {
            return false; //we need to handle errors on ajax
        }

        return $groups;
    }

    /**
     * Insert banners
     *
     * @access  public
     *
     * @return  array   Banners list
     */
    function InsertBanner($title, $url, $gid, $direction, $banner, $template, $views_limit,
                          $clicks_limit, $start_time, $stop_time, $random, $visible)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $this->_Model->InsertBanner($title, $url, $gid, $direction, $banner, $template, $views_limit,
                                    $clicks_limit, $start_time, $stop_time, $random, $visible);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update banners
     *
     * @access  public
     * @param   integer $bid
     * @return  array   Banners list
     */
    function UpdateBanner($bid, $title, $url, $gid, $direction, $banner, $template, $views_limit,
                          $clicks_limit, $start_time, $stop_time, $random, $visible)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $this->_Model->UpdateBanner($bid, $title, $url, $gid, $direction, $banner, $template, $views_limit,
                                    $clicks_limit, $start_time, $stop_time, $random, $visible);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Insert groups
     *
     * @access  public
     *
     * @return  array   Banners list
     */
    function InsertGroup($title, $limit_count, $visible)
    {
        $this->CheckSession('Banner', 'ManageGroups');
        $this->_Model->InsertGroup($title, $limit_count, $visible);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update groups
     *
     * @access  public
     * @param   integer  $gid
     * @return  array   Banners list
     */
    function UpdateGroup($gid, $title, $limit_count, $visible)
    {
        $this->CheckSession('Banner', 'ManageGroups');
        $this->_Model->UpdateGroup($gid, $title, $limit_count, $visible);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Add a group of banner (by they ids) to a certain group
     *
     * @access  public
     * @param   int     $gid  Group's ID
     * @param   array   $banners Array with banner id
     * @return  array   Response (notice or error)
     */
    function AddBannersToGroup($gid, $banners)
    {
        $this->CheckSession('Banner', 'BannersGrouping');
        $res = $this->_Model->AddBannersToGroup($gid, $banners);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete an banner
     *
     * @access  public
     * @param   int     $bid   banner ID
     * @return  array   Response (notice or error)
     */
    function DeleteBanner($bid)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $this->_Model->DeleteBanner($bid);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Reset banner's views counter
     *
     * @access  public
     * @param   int     $bid   banner ID
     * @return  array   Response (notice or error)
     */
    function ResetViews($bid)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $this->_Model->ResetViews($bid);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Reset banner's clicks counter
     *
     * @access  public
     * @param   int     $bid   banner ID
     * @return  array   Response (notice or error)
     */
    function ResetClicks($bid)
    {
        $this->CheckSession('Banner', 'ManageBanners');
        $this->_Model->ResetClicks($bid);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete an group
     *
     * @access  public
     * @param   int     $gid   group ID
     * @return  array   Response (notice or error)
     */
    function DeleteGroup($gid)
    {
        $this->CheckSession('Banner', 'ManageGroups');
        $this->_Model->DeleteGroup($gid);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Returns the group form
     *
     * @access  public
     * @return  string  XHTML of bannerForm
     */
    function GetGroupUI()
    {
        $this->CheckSession('Banner', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Banner', 'AdminHTML');
        return $gadget->EditGroupUI();
    }

    /**
     * Get the banners-group form
     *
     * @access  public
     * @return  string
     */
    function GetGroupBannersUI()
    {
        $this->CheckSession('Banner', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Banner', 'AdminHTML');
        return $gadget->GetGroupBannersUI();
    }

    /**
     * Creates and returns some data
     *
     * @access  public
     * @param   int     $offset
     * @return  array
     */
    function GetData($offset, $grid)
    {
        $this->CheckSession('Banner', 'ViewReports');
        $gadget = $GLOBALS['app']->LoadGadget('Banner', 'AdminHTML');
        if (!is_numeric($offset)) {
            $offset = null;
        }
        return ($grid == 'banners_datagrid')?
                $gadget->GetBanners($offset) :
                $gadget->GetReportBanners($offset);
    }
}