<?php
/**
 * Banner Gadget
 *
 * @category   Gadget
 * @package    Banner
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class BannerHTML extends Jaws_GadgetHTML
{
    /**
     * Constructor
     *
     * @access public
     */
    function BannerHTML()
    {
        $this->Init('Banner');
    }

    /**
     * Calls default action(display)
     *
     * @access       public
     * @return       template content
     */
    function DefaultAction()
    {
        $layoutGadget = $GLOBALS['app']->LoadGadget('Banner', 'LayoutHTML');
        return $layoutGadget->Display();
    }

    /**
     * Redirects request to banner's target
     *
     * @access       public
     */
    function Click()
    {
        require_once JAWS_PATH . 'include/Jaws/Header.php';
        $model = $GLOBALS['app']->LoadGadget('Banner', 'Model');
        $request =& Jaws_Request::getInstance();
        $id = (int)$request->get('id', 'get');
        $banner = $model->GetBanners($id);
        if (!Jaws_Error::IsError($banner)) {
            $click = $model->ClickBanner($banner[0]['id']);
            if (!Jaws_Error::IsError($click)) {
                $link = $banner[0]['url'];
                if (preg_match('/^(http|https|ftp):\/\/[a-z0-9-\.]*/i', $link)) {
                    Jaws_Header::Location($link);
                } else {
                    Jaws_Header::Location($GLOBALS['app']->getSiteURL() . '/' . $link);
                }
            }
        }
    }

    /**
     * Displays banners in a group via standalone action
     *
     * @access       public
     */
    function BannerGroup()
    {
        $request =& Jaws_Request::getInstance();
        $gid = (int)$request->get('id', 'get');
        $layoutGadget = $GLOBALS['app']->LoadGadget('Banner', 'LayoutHTML');
        $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        header($xss->filter($_SERVER['SERVER_PROTOCOL'])." 200 OK");
        return $layoutGadget->Display($gid, 'site_url');
    }
}