<?php
/**
 * Banner Gadget Info
 *
 * @category   GadgetInfo
 * @package    Banner
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class BannerInfo extends Jaws_GadgetInfo
{
    /**
     * Sets info about Banner gadget
     *
     * @access  public
     */
    function BannerInfo()
    {
        parent::Init('Banner');
        $this->GadgetName(_t('BANNER_NAME'));
        $this->GadgetDescription(_t('BANNER_DESCRIPTION'));
        $this->GadgetVersion('0.8.0');
        $this->Doc('gadget/Banner');

        $acls = array(
            'default',
            'ManageBanners',
            'ManageGroups',
            'BannersGrouping',
            'ViewReports'
        );
        $this->PopulateACLs($acls);
        $this->Requires('ControlPanel');
    }
}