<?php
/**
 * Banner Layout HTML file (for layout purposes)
 *
 * @category   GadgetLayout
 * @package    Banner
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class BannerLayoutHTML
{
    /**
     * Loads layout actions
     *
     * @access private
     */
    function LoadLayoutActions()
    {
        $model = $GLOBALS['app']->LoadGadget('Banner', 'Model');
        $groups = $model->GetGroups();

        $actions = array();
        if (!Jaws_Error::isError($groups)) {
            foreach ($groups as $group) {
                $actions['Display(' . $group['id'] . ')'] = array(
                    'mode' => 'LayoutAction',
                    'name' => $group['title'],
                    'desc' => _t('BANNER_ACTION_DISPLAY_DESCRIPTION')
                );
            }
        }

        return $actions;
    }

    /**
     * Displays banners(all-time visibles and random ones)
     *
     * @access public
     * @return template content
     */
    function Display($gid = 0, $URIPrefix = false)
    {
        $model = $GLOBALS['app']->LoadGadget('Banner', 'Model');
        $group = $model->GetGroup($gid);
        if (Jaws_Error::IsError($group) || empty($group) || $group['visible'] == 0) return;

        $tpl = new Jaws_Template('gadgets/Banner/templates/');
        $tpl->Load('Banners.html');
        $tpl->SetBlock('banners');
        $tpl->SetVariable('gid', $gid);
        $tpl->SetVariable('title', _t('BANNER_ACTION_TITLE'));

        $banners = $model->GetVisibleBanners($gid, $group['limit_count']);
        if (!Jaws_Error::IsError($banners)) {
            foreach ($banners as $banner) {
                $tpl->SetBlock('banners/banner');
                $tpl_template = new Jaws_Template();
                $tpl_template->LoadFromString('<!-- BEGIN x -->'.$banner['template'].'<!-- END x -->');
                $tpl_template->SetBlock('x');
                $tpl_template->SetVariable('title', $banner['title']);
                $tpl_template->SetVariable('banner', $banner['banner']);
                if (empty($banner['url'])) {
                    $tpl_template->SetVariable('link', 'javascript:void(0);');
                    $tpl_template->SetVariable('target', '_self');
                } else {
                    $tpl_template->SetVariable('link',
                                               $GLOBALS['app']->Map->GetURLFor('Banner', 'Click',
                                                                                array('id' => $banner['id']),
                                                                                true,
                                                                               ($URIPrefix? 'site_url': false)));
                    $tpl_template->SetVariable('target', '_blank');
                }
                $tpl_template->ParseBlock('x');
                $tpl->SetVariable('template', $tpl_template->Get());
                unset($tpl_template);
                $tpl->ParseBlock('banners/banner');
                $model->ViewBanner($banner['id']);
            }
        }

        $tpl->ParseBlock('banners');
        return $tpl->Get();
    }
}
?>
