<?php
/**
 * Banner Gadget
 *
 * @category   GadgetModel
 * @package    Banner
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @author     Amir Mohammad Saied <amir@php.net>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class BannerModel extends Jaws_Model
{
    var $_Name = 'Banner';

    /**
     * Retrieve banner
     *
     * @access  public
     * @return  array   An array of banner's data and Jaws_Error on error
     */
    function GetBanner($bid)
    {
        $sql = '
            SELECT  [id], [title], [url], [gid], [banner], [template], [direction], [views], [views_limitation],
                    [clicks], [clicks_limitation], [start_time], [stop_time], [rank], [random], [visible],
                    [createtime], [updatetime]
            FROM [[banners]]
            WHERE [id] = {bid}';

        $params            = array();
        $params['bid']     = $bid;

        $res = $GLOBALS['db']->queryRow($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return $res;
    }

    /**
     * Retrieve banners
     *
     * @access  public
     * @return  array   An array of available banners and Jaws_Error on error
     */
    function GetBanners($bid = -1, $gid = -1, $limit = 0, $offset = null, $columns = null)
    {
        if (empty($columns)) {
            $columns = '[id], [title], [url], [gid], [banner], [template], [direction], [views], [views_limitation],
                        [clicks], [clicks_limitation], [start_time], [stop_time], [createtime], [updatetime],
                        [random], [visible]';
        }

        if (($bid != -1) && ($gid != -1)) {
            $sql = '
                SELECT {columns}
                FROM [[banners]]
                WHERE [[banners]].[id] = {bid} AND [[banners]].[gid] = {gid}
                ORDER BY [[banners]].[rank] ASC';
        } elseif ($gid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[banners]]
                WHERE [[banners]].[gid] = {gid}
                ORDER BY [[banners]].[rank] ASC';
        } elseif ($bid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[banners]]
                WHERE [id] = {bid}';
        } else {
            $sql = '
                SELECT {columns}
                FROM [[banners]]
                ORDER BY [id] ASC';
        }

        $params            = array();
        $params['bid']     = $bid;
        $params['gid']     = $gid;
        $params['columns'] = $columns;

        if (!empty($limit)) {
            $res = $GLOBALS['db']->setLimit($limit, $offset);
            if (Jaws_Error::IsError($res)) {
                return new Jaws_Error($res->getMessage(), 'SQL');
            }
        }

        $sql = str_replace("{columns}", $columns, $sql);
        $res = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return $res;
    }

    /**
     * Retrieve group's info
     *
     * @access  public
     * @return  array   An array of group's data and Jaws_Error on error
     */
    function GetGroup($gid)
    {
        $sql = '
            SELECT  [id], [title], [limit_count], [visible]
            FROM [[banners_groups]]
            WHERE [id] = {gid}';

        $params            = array();
        $params['gid']     = $gid;

        $res = $GLOBALS['db']->queryRow($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return $res;
    }

    /**
     * Retrieve groups
     *
     * @access  public
     * @param
     * @param
     * @return  array   An array of available banners and Jaws_Error on error
     */
    function GetGroups($gid = -1, $bid = -1, $columns = null)
    {
        if (empty($columns)) {
            $columns = '[id], [title], [limit_count], [visible]';
        }

        if (($gid != -1) && ($bid != -1)) {
            $sql = '
                SELECT {columns}
                FROM [[banners_groups]]
                INNER JOIN [[banners]] ON [[banners_groups]].[id] = [[banners]].[gid]
                WHERE [[banners_groups]].[id] = {gid} AND [[banners]].[id] = {bid}
                ORDER BY [[banners_groups]].[id] ASC';
        } elseif ($bid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[banners_groups]]
                INNER JOIN [[banners]] ON [[banners_groups]].[id] = [[banners]].[gid]
                WHERE [[banners]].[id] = {bid}
                ORDER BY [[banners_groups]].[id] ASC';
        } elseif ($gid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[banners_groups]]
                WHERE [id] = {gid}';
        } else {
            $sql = '
                SELECT {columns}
                FROM [[banners_groups]]
                ORDER BY [id] ASC';
        }

        $params            = array();
        $params['gid']     = $gid;
        $params['bid']     = $bid;
        $params['columns'] = $columns;

        $sql = str_replace("{columns}", $columns, $sql);
        $res = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return $res;
    }

    /**
     * Retrieve banners that can be visible
     *
     * @access  public
     * @return  array   An array of available banners and Jaws_Error on error
     */
    function GetEnableBanners($gid = 0, $width = 0, $random = 0)
    {
        if ($gid == 0) {
            $sql = '
                SELECT [id], [title], [url], [banner], [template]
                FROM [[banners]]
                WHERE ([visible] = 1) AND ([random] = {random}) AND 
                    (([direction] = 0) OR ([direction] = {width})) AND
                    (([views_limitation] = 0) OR ([views] < [views_limitation])) AND
                    (([clicks_limitation] = 0) OR ([clicks] < [clicks_limitation])) AND
                    (([start_time] IS NULL) OR ({now} >= [start_time])) AND
                    (([stop_time] IS NULL) OR ({now} <= [stop_time]))
                ORDER BY [id] ASC';
        } else {
            $sql = '
                SELECT [id], [title], [url], [banner], [template]
                FROM [[banners]]
                WHERE ([[banners]].[gid] = {gid}) AND ([visible] = 1) AND ([random] = {random}) AND 
                    (([direction] = 0) OR ([direction] = {width})) AND
                    (([views_limitation] = 0) OR ([views] < [views_limitation])) AND
                    (([clicks_limitation] = 0) OR ([clicks] < [clicks_limitation])) AND
                    (([start_time] IS NULL) OR ({now} >= [start_time])) AND
                    (([stop_time] IS NULL) OR ({now} <= [stop_time]))
                ORDER BY [[banners]].[id] ASC';
        }

        MDB2::loadFile('Date');
        $params           = array();
        $params['gid']    = $gid;
        $params['width']  = $width;
        $params['random'] = $random;
        $params['now']    = MDB2_Date::mdbNow();

        $res = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return false;
        }
        return $res;
    }

    /**
     * Retrieve visible banners
     *
     * @access  public
     * @return  array   An array of available banners and Jaws_Error on error
     */
    function GetVisibleBanners($gid, $limit_count)
    {
        $limit_count = empty($limit_count)? 256 : $limit_count;
        if ($GLOBALS['app']->Layout->IsSectionWide()) {
            $width = 1;
        } else {
            $width = 2;
        }

        if (($always_array = $this->GetEnableBanners($gid, $width, 0)) == false) {
            $always_array = array();
        }

        if (($random_array = $this->GetEnableBanners($gid, $width, 1)) == false) {
            $random_array = array();
        }

        $res_array = array();
        if ((count($always_array) + count($random_array)) > $limit_count) {
            if(count($always_array) > $limit_count) {
                while (count($always_array) > $limit_count) {
                    array_splice($always_array, mt_rand(0, count($always_array)-1), 1);
                }
                $res_array = $always_array;
            } else {
                while (count($random_array) > ($limit_count - count($always_array))) {
                    array_splice($random_array, mt_rand(0, count($random_array)-1), 1);
                }
                $res_array = array_merge($always_array, $random_array);
            }
        } else {
            $res_array = array_merge($always_array, $random_array);
        }

        return $res_array;
    }

    /**
     * Increment the number of clicks a banner has had by 1.
     *
     * @access  public
     * @param   int     $bid The id of the banner to increment.
     * @return  boolean True on success and Jaws_Error on error
     */
    function ClickBanner($bid)
    {
        $sql = 'UPDATE [[banners]] SET [clicks] = [clicks] + 1 WHERE [id] = {bid}';
        $res = $GLOBALS['db']->query($sql, array('bid' => $bid));
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return true;
    }

    /**
     * Increment the number of views a banner has had by 1.
     *
     * @access  public
     * @param   int     $bid The id of the banenr to increment.
     * @return  boolean True on success and Jaws_Error on error
     */
    function ViewBanner($bid)
    {
        $sql = 'UPDATE [[banners]] SET [views] = [views] + 1 WHERE [id] = {bid}';
        $res = $GLOBALS['db']->query($sql, array('bid' => $bid));
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return true;
    }

}