<?php
/**
 * Blog URL maps
 *
 * @category   GadgetMaps
 * @package    Blog
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Helgi ormar orbjrnsson <dufuz@php.net>
 * @author     Jorge A Gallegos <kad@gulags.org.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
$GLOBALS['app']->Map->Connect('Blog', 'DefaultAction', 'blog');
$GLOBALS['app']->Map->Connect('Blog','LastPost', 'blog/last');
$GLOBALS['app']->Map->Connect(
                            'Blog',
                            'ViewDate',
                            'blog/{year}/{month}/{day}',
                            'index.php',
                            array(
                                    'year' => '\d{4}',
                                    'month' => '[01]?\d',
                                    'day' => '[0-3]?\d')
                    );
$GLOBALS['app']->Map->Connect(
                            'Blog',
                            'ViewDate',
                            'blog/{year}/{month}',
                            'index.php',
                            array(
                                    'year' => '\d{4}',
                                    'month' => '[01]?\d')
                    );
$GLOBALS['app']->Map->Connect('Blog','RSS', 'blog/rss');
$GLOBALS['app']->Map->Connect('Blog',
                              'ShowRSSCategory',
                              'blog/rss/category/{id}',
                              'index.php',
                              array('id' => '\d+')
                              );
$GLOBALS['app']->Map->Connect('Blog',
                              'CommentsRSS',
                              'blog/rss/comment/{id}',
                              'index.php',
                              array('id' => '\d+')
                              );
$GLOBALS['app']->Map->Connect('Blog','Atom', 'blog/atom');
$GLOBALS['app']->Map->Connect('Blog',
                              'ShowAtomCategory',
                              'blog/atom/category/{id}',
                              'index.php',
                              array('id' => '\d+')
                              );
$GLOBALS['app']->Map->Connect('Blog',
                              'CommentsAtom',
                              'blog/atom/comment/{id}',
                              'index.php',
                              array('id' => '\d+')
                              );
$GLOBALS['app']->Map->Connect('Blog',
                              'SingleView', 
                              'blog/show/{id}',
                              'index.php',
                              array('id' =>  '[[:alnum:][:space:][:punct:]]+$',)
                              );

$GLOBALS['app']->Map->Connect('Blog',
                              'ViewAuthorPage',
                              'blog/author/{id}/page/{page}',
                              'index.php',
                              array(
                                    'id'   => '[[:alnum:][:space:][:punct:]]+',
                                    'page' => '[[:digit:]]+$',
                                   )
                              );
$GLOBALS['app']->Map->Connect('Blog',
                              'ViewAuthorPage',
                              'blog/author/{id}',
                              'index.php',
                              array('id' =>  '[[:alnum:][:space:][:punct:]]+$',)
                              );

$GLOBALS['app']->Map->Connect('Blog','ViewPage', 'blog/page/{page}');
$GLOBALS['app']->Map->Connect('Blog','Reply', 'blog/{id}/reply/{comment_id}');

$GLOBALS['app']->Map->Connect('Blog',
                              'ShowCategory',
                              'blog/category/{id}/page/{page}',
                              'index.php',
                              array(
                                    'id'   => '[[:alnum:][:space:][:punct:]]+',
                                    'page' => '[[:digit:]]+$',
                                   )
                              );
$GLOBALS['app']->Map->Connect('Blog',
                              'ShowCategory',
                              'blog/category/{id}',
                              'index.php',
                              array('id' =>  '[[:alnum:][:space:][:punct:]]+$',)
                              );

$GLOBALS['app']->Map->Connect('Blog','Trackback', 'trackback/{id}');
$GLOBALS['app']->Map->Connect('Blog','Archive', 'blog/archive');
$GLOBALS['app']->Map->Connect('Blog','Pingback', 'pingback');
