<?php
/**
 * Chatbox Gadget
 *
 * @category   GadgetModel
 * @package    Chatbox
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ChatboxAdminModel extends Jaws_Model
{
    var $_Name = 'Chatbox';

    /**
     * Install Chatbox gadget in Jaws
     *
     * @access  public
     * @return  boolean true on successful installation, Jaws_Error otherwise
     */
    function InstallGadget()
    {
        // Registry keys.
        $GLOBALS['app']->Registry->NewKey('/gadgets/Chatbox/limit', '7');
        $GLOBALS['app']->Registry->NewKey('/gadgets/Chatbox/use_antispam', 'true');
        $GLOBALS['app']->Registry->NewKey('/gadgets/Chatbox/max_strlen', '50');

        return true;
    }

    /**
     * Uninstall the gadget
     *
     * @access  public
     * @return  boolean  Success/Failure (Jaws_Error)
     */
    function UninstallGadget()
    {
        // Registry keys
        $GLOBALS['app']->Registry->DeleteKey('/gadgets/Chatbox/limit');
        $GLOBALS['app']->Registry->DeleteKey('/gadgets/Chatbox/use_antispam');
        $GLOBALS['app']->Registry->DeleteKey('/gadgets/Chatbox/max_strlen');

        return true;
    }

   /**
     * Update the gadget
     *
     * @access  public
     * @param   string  $old    Current version (in registry)
     * @param   string  $new    New version (in the $gadgetInfo file)
     * @return  boolean  Success/Failure (Jaws_Error)
     */
    function UpdateGadget($old, $new)
    {
        /*
        $result = $this->installSchema('schema.xml', '', "$old.xml");
        if (Jaws_Error::IsError($result)) {
            return $result;
        }
        */

        // Registry keys.
        $GLOBALS['app']->Registry->NewKey('/gadgets/Chatbox/max_strlen', '50');

        return true;
    }

	/**
     * Mark as different status an entry
     *
     * @access  public
     * @param   array  $ids     Id's of the entries to mark as spam
     * @param   string $status  New status (spam by default)
     */
    function MarkCommentsAs($ids, $status = 'spam')
    {
        if (count($ids) == 0 || empty($status)) {
            return true;
        }

        require_once JAWS_PATH.'include/Jaws/Comment.php';
        $api = new Jaws_Comment('Chatbox');
        $api->MarkAs($ids, $status);
        $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_COMMENT_MARKED'), RESPONSE_NOTICE);
        return true;
    }

    /**
     * Delete a comment
     *
     * @access  public
     * @param   string  $id         Comment id
     * @return  boolean Success/Failure
     */
    function DeleteComment($id)
    {
        require_once JAWS_PATH.'include/Jaws/Comment.php';
        $api = new Jaws_Comment('Chatbox');

        $comment = $api->GetComment($id);
        if (Jaws_Error::IsError($comment)) {
            $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_ENTRY_NOT_DELETE'), RESPONSE_ERROR);
            return new Jaws_Error(_t('CHATBOX_ERROR_ENTRY_NOT_DELETE'), _t('CHATBOX_NAME'));
        }

        $res = $api->DeleteComment($id);
        if (Jaws_Error::IsError($res)) {
            $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_ENTRY_NOT_DELETE'), RESPONSE_ERROR);
            return new Jaws_Error(_t('CHATBOX_ERROR_ENTRY_NOT_DELETE'), _t('CHATBOX_NAME'));
        }

        return true;
    }

    /**
     * Does a massive entry delete
     *
     * @access  public
     * @param   array   $ids  Ids of entries
     * @return  boolean Success/Failure
     */
    function MassiveCommentDelete($ids)
    {
        if (!is_array($ids)) {
            $ids = func_get_args();
        }

        foreach($ids as $id) {
            $res = $this->DeleteComment($id);
            if (Jaws_Error::IsError($res)) {
                $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_COMMENT_NOT_DELETED'), RESPONSE_ERROR);
                return new Jaws_Error(_t('CHATBOX_ERROR_COMMENT_NOT_DELETED'), _t('BLOG_NAME'));
            }
        }

        $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ENTRY_DELETED'), RESPONSE_NOTICE);
        return true;
    }

    /**
     * Updates a comment
     *
     * @access  public
     * @param   string  $id         Comment id
     * @param   string  $name       Name of the author
     * @param   string  $title      Title of the comment
     * @param   string  $url        Url of the author
     * @param   string  $email      Email of the author
     * @param   string  $comments   Text of the comment
     * @param   string  $permalink  Permanent link to post
     * @param   string  $status     Comment Status
     * @return  boolean Success/Failure
     */
    function UpdateComment($id, $name, $url, $email, $comments)
    {
        require_once JAWS_PATH.'include/Jaws/Comment.php';

        $api = new Jaws_Comment('Chatbox');

        $prev = $api->GetComment($id);
        if (Jaws_Error::IsError($prev)) {
            $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_COMMENT_NOT_UPDATED'), RESPONSE_ERROR);
            return new Jaws_Error(_t('CHATBOX_ERROR_COMMENT_NOT_UPDATED'), _t('CHATBOX_NAME'));
        }

        $max_strlen = (int)$GLOBALS['app']->Registry->Get('/gadgets/Chatbox/max_strlen');
        $params              = array();
        $params['id']        = $id;
        $params['name']      = strip_tags($name);
        $params['title']     = strip_tags($GLOBALS['app']->UTF8->substr($comments,0, $max_strlen).'...');
        $params['url']       = strip_tags($url);
        $params['email']     = strip_tags($email);
        $params['comments']  = strip_tags($comments);
        $params['permalink'] = $permalink = $GLOBALS['app']->GetSiteURL();
        $params['status']    = $prev['status'];

        $res = $api->UpdateComment($params['id'],        $params['name'],
                                   $params['email'],     $params['url'],
                                   $params['title'],     $params['comments'],
                                   $params['permalink'], $params['status']);

        if (Jaws_Error::IsError($res)) {
            $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_COMMENT_NOT_UPDATED'), RESPONSE_ERROR);
            return new Jaws_Error(_t('CHATBOX_ERROR_COMMENT_NOT_UPDATED'), _t('CHATBOX_NAME'));
        }
        $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_COMMENT_UPDATED'), RESPONSE_NOTICE);
        return true;
    }

    /**
     * Set the properties of the gadget
     *
     * @access  public
     * @param   int     $limit      Limit of chatbox entries
     * @param   int     $max_strlen Maximum length of comment entry
     * @return  boolean True if change was successful, if not, returns Jaws_Error on any error
     */
    function UpdateProperties($limit, $max_strlen)
    {
        $res[] = $GLOBALS['app']->Registry->Set('/gadgets/Chatbox/limit', $limit);
        $res[] = $GLOBALS['app']->Registry->Set('/gadgets/Chatbox/max_strlen', $max_strlen);
        foreach ($res as $r) {
            if (Jaws_Error::IsError($r) || !$r) {
                $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_ERROR_SETTINGS_NOT_UPDATED'), RESPONSE_ERROR);
                return new Jaws_Error(_t('CHATBOX_ERROR_SETTINGS_NOT_UPDATED'), _t('CHATBOX_NAME'));
            }
        }

        $GLOBALS['app']->Registry->Commit('Chatbox');
        $GLOBALS['app']->Session->PushLastResponse(_t('CHATBOX_SETTINGS_UPDATED'), RESPONSE_NOTICE);
        return true;
    }
}
