<?php
/**
 * Chatbox Gadget
 *
 * @category   GadgetInfo
 * @package    Chatbox
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ChatboxInfo extends Jaws_GadgetInfo
{
    /**
     * Sets info about chatbox gadget
     *
     * @access  public
     */
    function ChatboxInfo()
    {
        parent::Init('Chatbox');
        $this->GadgetName(_t('CHATBOX_NAME'));
        $this->GadgetDescription(_t('CHATBOX_DESCRIPTION'));
        $this->GadgetVersion('0.8.0');
        $this->Doc('gadget/Chatbox');

        $acls = array(
            'default',
            'DeleteEntry',
            'UpdateProperties',
        );
        $this->PopulateACLs($acls);
        $this->Requires('ControlPanel');
    }
}
