<?php
/**
 * Chatbox Layout HTML file (for layout purposes)
 *
 * @category   GadgetLayout
 * @package    Chatbox
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ChatboxLayoutHTML
{
    /**
     * Displays the chatbox
     *
     * @access       public
     * @return       template content
     */
    function Display()
    {
        $tpl = new Jaws_Template('gadgets/Chatbox/templates/');
        $tpl->Load('Chatbox.html');
        $tpl->SetBlock('chatbox');
        $tpl->SetVariable('base_script', BASE_SCRIPT);
        $tpl->SetVariable('title', _t('CHATBOX_NAME'));
        $tpl->SetVariable('message', _t('CHATBOX_MESSAGE'));
        $tpl->SetVariable('send', _t('CHATBOX_SEND'));

        $name  = Jaws_Session_Web::GetCookie('visitor_name');
        $email = Jaws_Session_Web::GetCookie('visitor_email');
        $url   = Jaws_Session_Web::GetCookie('visitor_url');

        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        if (!$GLOBALS['app']->Session->Logged()) {
            $tpl->SetBlock('chatbox/unregistered');
            $url_value = empty($url)? 'http://' : $xss->filter($url);
            $tpl->SetVariable('url', _t('GLOBAL_URL'));
            $tpl->SetVariable('urlvalue', $url_value);
            $tpl->SetVariable('rand', rand());
            $tpl->SetVariable('name', _t('GLOBAL_NAME'));
            $tpl->SetVariable('namevalue', isset($name) ? $xss->filter($name) : '');
            $tpl->SetVariable('email', _t('GLOBAL_EMAIL'));
            $tpl->SetVariable('emailvalue', isset($email) ? $xss->filter($email) : '');
            $tpl->ParseBlock('chatbox/unregistered');

            $GLOBALS['app']->Registry->LoadFile('Policy');
            $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
            if ($_captcha != 'DISABLED') {
                require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
                $captcha = new $_captcha();
                $captchaRes = $captcha->Get();
                $tpl->SetBlock('chatbox/captcha');
                $tpl->SetVariable('lbl_captcha', _t('GLOBAL_CAPTCHA_CODE'));
                $tpl->SetVariable('captcha', $captchaRes['captcha']->Get());
                if (!empty($captchaRes['entry'])) {
                    $tpl->SetVariable('captchavalue', $captchaRes['entry']->Get());
                }
                $tpl->SetVariable('captcha_msg', _t('GLOBAL_CAPTCHA_CODE_DESC'));
                $tpl->ParseBlock('chatbox/captcha');
            }
        }

        if ($response = $GLOBALS['app']->Session->PopSimpleResponse('Chatbox')) {
            $tpl->SetBlock('chatbox/response');
            $tpl->SetVariable('msg', $response);
            $tpl->ParseBlock('chatbox/response');
        }

        $model = $GLOBALS['app']->LoadGadget('Chatbox', 'Model');
        $entries = $model->GetEntries($GLOBALS['app']->Registry->Get('/gadgets/Chatbox/limit'));

        if (!Jaws_Error::IsError($entries) && count($entries)) {
            $date = $GLOBALS['app']->loadDate();
            $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            $tpl->SetBlock('chatbox/entries');
            foreach ($entries as $entry) {
                $tpl->SetBlock('chatbox/entries/entry');
                $tpl->SetVariable('name', $xss->filter($entry['name']));
                $tpl->SetVariable('email', $xss->filter($entry['email']));
                $tpl->SetVariable('url', $xss->filter($entry['url']));
                $tpl->SetVariable('updatetime', $date->Format($entry['createtime']));
                $tpl->SetVariable('message', Jaws_Gadget::ParseText($entry['msg_txt'], 'Chatbox'));
                if ($entry['status'] == 'spam') {
                   $tpl->SetVariable('status_message', _t('CHATBOX_COMMENT_IS_SPAM'));
                } elseif ($entry['status'] == 'waiting') {
                    $tpl->SetVariable('status_message', _t('CHATBOX_COMMENT_IS_WAITING'));
                } else {
                    $tpl->SetVariable('status_message', '&nbsp;');
                }
                $tpl->ParseBlock('chatbox/entries/entry');
            }
            $tpl->ParseBlock('chatbox/entries');
        }
        $tpl->ParseBlock('chatbox');

        return $tpl->Get();
    }

}
