<?php
/**
 * Contact AJAX API
 *
 * @category   Ajax
 * @package    Contact
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ContactAdminAjax extends Jaws_Ajax
{
    /**
     * Constructor
     *
     * @access  public
     */
    function ContactAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }

    /**
     * Get information of a Contact
     *
     * @access  public
     * @param   int     Contact ID
     * @return  array   Contact info
     */
    function GetContact($id)
    {
        $this->CheckSession('Contact', 'default');
        $ContactInfo = $this->_Model->GetContact($id);
        if (Jaws_Error::IsError($ContactInfo)) {
            return false; //we need to handle errors on ajax
        }

        return $ContactInfo;
    }

    /**
     * Update contact information
     *
     * @access  public
     * @param   integer $id         Contact ID
     * @param   string  $name       Name
     * @param   string  $email      Email address
     * @param   string  $$company
     * @param   string  $url
     * @param   string  $tel
     * @param   string  $fax
     * @param   string  $mobile
     * @param   string  $address
     * @param   integer $rcipient   Rcipient ID
     * @param   string  $subject    Subject of message
     * @param   string  $message    Message content
     * @return  boolean Success/Failure
     */
    function UpdateContact($id, $name, $email, $company, $url, $tel, $fax, $mobile, $address, $recipient, $subject, $message)
    {
        $this->CheckSession('Contact', 'ManageContacts');
        $this->_Model->UpdateContact($id, $name, $email, $company, $url, $tel, $fax, $mobile, $address, $recipient, $subject, $message);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update contact reply
     *
     * @access  public
     * @param   integer $id     Contact ID
     * @param   string  $reply  Reply content
     * @return  boolean Success/Failure
     */
    function UpdateReply($id, $reply, $send_reply)
    {
        $this->CheckSession('Contact', 'ManageContacts');
        $res = $this->_Model->UpdateReply($id, $reply);
        if (!Jaws_Error::IsError($res) && $send_reply) {
            $GLOBALS['app']->Session->PopLastResponse(); // emptying all responses message
            $this->_Model->SendReply($id);
        }
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete a Contact
     *
     * @access  public
     * @param   string $id  ID of the Contact
     * @return  boolean True on success and Jaws_Error on failure
     */
    function DeleteContact($id)
    {
        $this->CheckSession('Contact', 'ManageContacts');
        $this->_Model->DeleteContact($id);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Get information of a Contact Reply
     *
     * @access  public
     * @param   int     Contact ID
     * @return  array   Reply info
     */
    function GetReply($id)
    {
        $this->CheckSession('Contact', 'default');
        $replyData = $this->_Model->GetReply($id);
        if (Jaws_Error::IsError($replyData)) {
            return false; //we need to handle errors on ajax
        }
        if (isset($replyData['id'])) {
            $replyData['readonly'] = (bool)$replyData['reply_sent'] && !(bool)$this->GetPermission('Contact', 'EditSentMessage');
        }
        return $replyData;
    }

    /**
     * Returns the reply form
     *
     * @access  public
     * @return  string  XHTML
     */
    function ReplyUI()
    {
        $this->CheckSession('Contact', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Contact', 'AdminHTML');
        return $gadget->ReplyUI();
    }

    /**
     * Get information of a Recipient
     *
     * @access  public
     * @param   int     $id    Recipient
     * @return  array   Recipient info
     */
    function GetRecipient($id)
    {
        $this->CheckSession('Contact', 'default');
        $RecipientInfo = $this->_Model->GetRecipient($id);
        if (Jaws_Error::IsError($RecipientInfo)) {
            return false; //we need to handle errors on ajax
        }

        return $RecipientInfo;
    }

    /**
     * Insert the information of a Recipient
     *
     * @access  public
     * @param   string $name    Name of the recipient
     * @param   string $email   Email of recipient
     * @param   string $tel     Phone number of recipient
     * @param   string $fax     Fax number of recipient
     * @param   string $mobile  Mobile number of recipient
     * @param   integer $inform_type Inform Type
     * @param   string $visible The visible of the recipient
     * @return  boolean True on success and Jaws_Error on failure
     */
    function InsertRecipient($name, $email, $tel, $fax, $mobile, $inform_type, $visible)
    {
        $this->CheckSession('Contact', 'ManageRecipients');
        $this->_Model->InsertRecipient($name, $email, $tel, $fax, $mobile, $inform_type, $visible);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update the information of a Recipient
     *
     * @access  public
     * @param   string  $id      ID of the recipient
     * @param   string  $name    Name of the recipient
     * @param   string  $email   Email of recipient
     * @param   string  $tel     Phone number of recipient
     * @param   string  $fax     Fax number of recipient
     * @param   string  $mobile  Mobile number of recipient
     * @param   integer $inform_type Inform Type
     * @param   string  $visible The visible of the recipient
     * @return  boolean True on success and Jaws_Error on failure
     */
    function UpdateRecipient($id, $name, $email, $tel, $fax, $mobile, $inform_type, $visible)
    {
        $this->CheckSession('Contact', 'ManageRecipients');
        $this->_Model->UpdateRecipient($id, $name, $email, $tel, $fax, $mobile, $inform_type, $visible);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete a Recipient
     *
     * @access  public
     * @param   string $id  ID of the Recipient
     * @return  boolean True on success and Jaws_Error on failure
     */
    function DeleteRecipient($id)
    {
        $this->CheckSession('Contact', 'ManageRecipients');
        $this->_Model->DeleteRecipient($id);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Set properties of the gadget
     *
     * @access  public
     * @param   boolean $use_antispam
     * @param   boolean $use_captcha
     * @param   string  $email_format
     * @return  boolean True if change is successful, if not, returns Jaws_Error on any error
     */
    function UpdateProperties($use_antispam, $use_captcha, $email_format)
    {
        $this->CheckSession('Contact', 'UpdateProperties');
        $this->_Model->UpdateProperties($use_antispam, $use_captcha, $email_format);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Get Data
     *
     * @access  public
     * @return  array  Recipients or Contacts
     */
    function GetData($offset, $grid)
    {
        $this->CheckSession('Contact', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Contact', 'AdminHTML');
        if (!is_numeric($offset)) {
            $offset = null;
        }
        return ($grid == 'contacts_datagrid')? $gadget->GetContacts($offset) : $gadget->GetRecipients($offset);
    }
}
?>
