<?php
/**
 * Contact Gadget Admin
 *
 * @category   GadgetModel
 * @package    Contact
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ContactAdminHTML extends Jaws_GadgetHTML
{
    /**
     * Main Constructor
     *
     * @access      public
     */
    function ContactAdminHTML()
    {
        $this->Init('Contact');
    }

    /*
     * Admin of Gadget
     *
     * @access  public
     * @return  string HTML content of administration
     */
    function Admin()
    {
        $this->CheckPermission('default');

        if ($this->GetPermission('ManageContacts')) {
            return $this->Contacts();
        } elseif ($this->GetPermission('ManageRecipients')) {
            return $this->Recipients();
        }

        $this->CheckPermission('UpdateProperties');
        return $this->Properties();
    }

    /**
     * Prepares the contacs menubar
     *
     * @access  public
     * @param   string  $action   Selected action
     * @return  string  XHTML of menubar
     */
    function MenuBar($action)
    {
        $actions = array('Contacts', 'Recipients', 'Properties');
        if (!in_array($action, $actions)) {
            $action = 'Contacts';
        }

        require_once JAWS_PATH . 'include/Jaws/Widgets/Menubar.php';
        $menubar = new Jaws_Widgets_Menubar();
        if ($this->GetPermission('ManageContacts')) {
            $menubar->AddOption('Contacts', _t('CONTACT_NAME'),
                                BASE_SCRIPT . '?gadget=Contact&amp;action=Admin', 'gadgets/Contact/images/contact_mini.png');
        }
        if ($this->GetPermission('ManageRecipients')) {
            $menubar->AddOption('Recipients', _t('CONTACT_RECIPIENTS'),
                                BASE_SCRIPT . '?gadget=Contact&amp;action=Recipients', 'gadgets/Contact/images/recipients_mini.png');
        }
        if ($this->GetPermission('UpdateProperties')) {
            $menubar->AddOption('Properties', _t('GLOBAL_PROPERTIES'),
                                BASE_SCRIPT . '?gadget=Contact&amp;action=Properties', 'gadgets/Contact/images/properties_mini.png');
        }

        $menubar->Activate($action);
        return $menubar->Get();
    }

    /**
     * Prepares the data of contacts
     *
     * @access  public
     * @param   int    $limit  Limit of data
     * @return  array  Data
     */
    function GetContacts($offset = null)
    {
        $model = $GLOBALS['app']->LoadGadget('Contact', 'AdminModel');

        $contacts = $model->GetContacts(12, $offset);
        if (Jaws_Error::IsError($contacts)) {
            return array();
        }

        $date = $GLOBALS['app']->loadDate();
        $newData = array();
        foreach ($contacts as $contact) {
            $contactData = array();
            $contactData['name']  = '<a title="'.$contact['subject'].'">'.$contact['name'].'</a>';

            $contactData['time'] = $date->Format($contact['createtime'],'Y-m-d');
            $actions = '';
            if ($this->GetPermission('ManageContacts')) {
                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_EDIT'),
                                            "javascript: editContact(this, '".$contact['id']."');",
                                            STOCK_EDIT);
                $actions.= $link->Get().'&nbsp;';

                $link =& Piwi::CreateWidget('Link', _t('CONTACT_CONTACTS_MESSAGE_REPLY'),
                                            "javascript: editReply(this, '" . $contact['id'] . "');",
                                            'gadgets/Contact/images/contact_mini.png');
                $actions.= $link->Get().'&nbsp;';

                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_DELETE'),
                                            "javascript: deleteContact(this, '".$contact['id']."');",
                                            STOCK_DELETE);
                $actions.= $link->Get().'&nbsp;';
            }
            $contactData['actions'] = $actions;
            $newData[] = $contactData;
        }
        return $newData;
    }

    /**
     * Prepares the datagrid view (XHTML of datagrid)
     *
     * @access  public
     * @return  string XHTML of datagrid
     */
    function ContactsDataGrid()
    {
        $model = $GLOBALS['app']->LoadGadget('Contact', 'AdminModel');
        $total = $model->TotalOfData('contacts');

        $grid =& Piwi::CreateWidget('DataGrid', array());
        $grid->SetID('contacts_datagrid');
        $grid->TotalRows($total);
        $grid->pageBy(12);
        $column1 = Piwi::CreateWidget('Column', _t('GLOBAL_NAME'), null, false);
        $grid->AddColumn($column1);
        $column2 = Piwi::CreateWidget('Column', _t('GLOBAL_DATE'), null, false);
        $column2->SetStyle('width: 72px; white-space: nowrap;');
        $grid->AddColumn($column2);
        $column3 = Piwi::CreateWidget('Column', _t('GLOBAL_ACTIONS'), null, false);
        $column3->SetStyle('width: 60px; white-space: nowrap;');
        $grid->AddColumn($column3);
        $grid->SetStyle('margin-top: 0px; width: 100%;');

        return $grid->Get();
    }

    /**
     * Show contacts list
     *
     * @access  public
     * @return  string HTML content
     */
    function Contacts()
    {
        $this->CheckPermission('ManageContacts');
        $this->AjaxMe('script.js');

        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('AdminContacts.html');
        $tpl->SetBlock('Contacts');

        //Menu bar
        $tpl->SetVariable('menubar', $this->MenuBar('Contacts'));

        //DataGrid
        $tpl->SetVariable('grid', $this->ContactsDataGrid());

        //ContactUI
        $tpl->SetVariable('contact_ui', $this->ContactUI());

        $btnCancel =& Piwi::CreateWidget('Button', 'btn_cancel', _t('GLOBAL_CANCEL'), STOCK_CANCEL);
        $btnCancel->AddEvent(ON_CLICK, 'stopAction();');
        $btnCancel->SetStyle('visibility: hidden;');
        $tpl->SetVariable('btn_cancel', $btnCancel->Get());

        $btnSave =& Piwi::CreateWidget('Button', 'btn_save', _t('GLOBAL_SAVE'), STOCK_SAVE);
        $btnSave->SetEnabled($this->GetPermission('ManageContacts'));
        $btnSave->AddEvent(ON_CLICK, 'updateContact(false);');
        $btnSave->SetStyle('visibility: hidden;');
        $tpl->SetVariable('btn_save', $btnSave->Get());

        $btnSaveSend =& Piwi::CreateWidget('Button', 'btn_save_send', _t('CONTACT_REPLAY_SAVE_SEND'), STOCK_SAVE);
        $btnSaveSend->SetEnabled($this->GetPermission('ManageContacts'));
        $btnSaveSend->AddEvent(ON_CLICK, 'updateContact(true);');
        $btnSaveSend->SetStyle('display: none;');
        $tpl->SetVariable('btn_save_send', $btnSaveSend->Get());

        $tpl->SetVariable('incompleteContactFields', _t('CONTACT_INCOMPLETE_FIELDS'));
        $tpl->SetVariable('confirmContactDelete',    _t('CONTACT_CONTACTS_CONFIRM_DELETE'));
        $tpl->SetVariable('legend_title',            _t('CONTACT_CONTACTS_MESSAGE_DETAILS'));
        $tpl->SetVariable('messageDetail_title',     _t('CONTACT_CONTACTS_MESSAGE_DETAILS'));
        $tpl->SetVariable('contactReply_title',      _t('CONTACT_CONTACTS_MESSAGE_REPLY'));

        $tpl->ParseBlock('Contacts');
        return $tpl->Get();
    }

    /**
     * Show a form to show/edit a given contact
     *
     * @access  public
     * @return  string HTML content
     */
    function ContactUI()
    {
        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('AdminContacts.html');
        $tpl->SetBlock('ContactUI');

        //name
        $nameEntry =& Piwi::CreateWidget('Entry', 'name', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_name', _t('GLOBAL_NAME'));
        $tpl->SetVariable('name', $nameEntry->Get());

        //email
        $nameEntry =& Piwi::CreateWidget('Entry', 'email', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_email', _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('email', $nameEntry->Get());

        //company
        $nameEntry =& Piwi::CreateWidget('Entry', 'company', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_company', _t('CONTACT_COMPANY'));
        $tpl->SetVariable('company', $nameEntry->Get());

        //url
        $nameEntry =& Piwi::CreateWidget('Entry', 'url', '');
        $nameEntry->setStyle('width: 256px;');
        $tpl->SetVariable('lbl_url', _t('GLOBAL_URL'));
        $tpl->SetVariable('url', $nameEntry->Get());

        //tel
        $nameEntry =& Piwi::CreateWidget('Entry', 'tel', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_tel', _t('CONTACT_TEL'));
        $tpl->SetVariable('tel', $nameEntry->Get());

        //fax
        $nameEntry =& Piwi::CreateWidget('Entry', 'fax', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_fax', _t('CONTACT_FAX'));
        $tpl->SetVariable('fax', $nameEntry->Get());

        //mobile
        $nameEntry =& Piwi::CreateWidget('Entry', 'mobile', '');
        $nameEntry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_mobile', _t('CONTACT_MOBILE'));
        $tpl->SetVariable('mobile', $nameEntry->Get());

        //address
        $nameEntry =& Piwi::CreateWidget('Entry', 'address', '');
        $nameEntry->setStyle('width: 256px;');
        $tpl->SetVariable('lbl_address', _t('CONTACT_ADDRESS'));
        $tpl->SetVariable('address', $nameEntry->Get());

        //recipient
        $recipientCombo =& Piwi::CreateWidget('Combo', 'rid');
        $recipientCombo->SetID('rid');
        $recipientCombo->setStyle('width: 262px;');
        $recipientCombo->AddOption($GLOBALS['app']->Registry->Get('/config/owner_name'), 0);
        $model = $GLOBALS['app']->LoadGadget('Contact', 'Model');
        $recipients = $model->GetRecipients();
        if (!Jaws_Error::IsError($result)) {
            foreach ($recipients as $recipient) {
                $recipientCombo->AddOption($recipient['name'], $recipient['id']);
            }
        }
        $tpl->SetVariable('lbl_recipient', _t('CONTACT_RECIPIENT'));
        $tpl->SetVariable('recipient', $recipientCombo->Get());

        //subject
        $subjectEntry =& Piwi::CreateWidget('Entry', 'subject', '');
        $subjectEntry->setStyle('width: 256px;');
        $tpl->SetVariable('lbl_subject', _t('CONTACT_SUBJECT'));
        $tpl->SetVariable('subject', $subjectEntry->Get());

        //message
        $messageText =& Piwi::CreateWidget('TextArea', 'message','');
        $messageText->SetStyle('width: 256px;');
        $messageText->SetRows(8);
        $tpl->SetVariable('lbl_message', _t('CONTACT_MESSAGE'));
        $tpl->SetVariable('message', $messageText->Get());

        $tpl->ParseBlock('ContactUI');
        return $tpl->Get();
    }

    /**
     * Show a form to edit/send contact reply
     *
     * @access  public
     * @return  string HTML content
     */
    function ReplyUI()
    {
        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('AdminContacts.html');
        $tpl->SetBlock('ReplyUI');

        //name
        $nameEntry =& Piwi::CreateWidget('Entry', 'name', '');
        $nameEntry->setStyle('width: 160px;');
        $nameEntry->SetReadOnly(true);
        $tpl->SetVariable('lbl_name', _t('GLOBAL_NAME'));
        $tpl->SetVariable('name', $nameEntry->Get());

        //email
        $nameEntry =& Piwi::CreateWidget('Entry', 'email', '');
        $nameEntry->setStyle('width: 160px;');
        $nameEntry->SetReadOnly(true);
        $tpl->SetVariable('lbl_email', _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('email', $nameEntry->Get());

        //subject
        $subjectEntry =& Piwi::CreateWidget('Entry', 'subject', '');
        $subjectEntry->setStyle('width: 256px;');
        $subjectEntry->SetReadOnly(true);
        $tpl->SetVariable('lbl_subject', _t('CONTACT_SUBJECT'));
        $tpl->SetVariable('subject', $subjectEntry->Get());

        //message
        $messageText =& Piwi::CreateWidget('TextArea', 'message','');
        $messageText->SetStyle('width: 256px;');
        $messageText->SetReadOnly(true);
        $messageText->SetRows(8);
        $tpl->SetVariable('lbl_message', _t('CONTACT_MESSAGE'));
        $tpl->SetVariable('message', $messageText->Get());

        //reply
        $replyText =& Piwi::CreateWidget('TextArea', 'reply','');
        $replyText->SetStyle('width: 256px;');
        $replyText->SetRows(10);
        $tpl->SetVariable('lbl_reply', _t('CONTACT_REPLY'));
        $tpl->SetVariable('reply', $replyText->Get());

        $tpl->ParseBlock('ReplyUI');
        return $tpl->Get();
    }

    /**
     * Prepares the data of recipient
     *
     * @access  public
     * @param   int    $limit  Limit of data
     * @return  array  Data
     */
    function GetRecipients($offset = null)
    {
        $model = $GLOBALS['app']->LoadGadget('Contact', 'AdminModel');

        $recipients = $model->GetRecipients(false, 10, $offset);
        if (Jaws_Error::IsError($recipients)) {
            return array();
        }

        $newData = array();
        foreach ($recipients as $recipient) {
            $recipientData = array();
            $recipientData['name']  = $recipient['name'];
            $recipientData['email'] = $recipient['email'];
            $recipientData['visible'] = ($recipient['visible']?_t('GLOBAL_YES') : _t('GLOBAL_NO'));
            $actions = '';
            if ($this->GetPermission('ManageRecipients')) {
                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_EDIT'),
                                            "javascript: editRecipient(this, '".$recipient['id']."');",
                                            STOCK_EDIT);
                $actions.= $link->Get().'&nbsp;';
                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_DELETE'),
                                            "javascript: deleteRecipient(this, '".$recipient['id']."');",
                                            STOCK_DELETE);
                $actions.= $link->Get().'&nbsp;';
            }
            $recipientData['actions'] = $actions;
            $newData[] = $recipientData;
        }
        return $newData;
    }

    /**
     * Prepares the datagrid view (XHTML of datagrid)
     *
     * @access  public
     * @return  string XHTML of datagrid
     */
    function RecipientsDataGrid()
    {
        $model = $GLOBALS['app']->LoadGadget('Contact', 'AdminModel');
        $total = $model->TotalOfData('contacts_recipients');

        $datagrid =& Piwi::CreateWidget('DataGrid', array());
        $datagrid->TotalRows($total);
        $datagrid->SetID('recipient_datagrid');
        $column1 = Piwi::CreateWidget('Column', _t('GLOBAL_TITLE'), null, false);
        $datagrid->AddColumn($column1);
        $column2 = Piwi::CreateWidget('Column', _t('GLOBAL_EMAIL'), null, false);
        $column2->SetStyle('width: 160px; white-space:nowrap;');
        $datagrid->AddColumn($column2);
        $column3 = Piwi::CreateWidget('Column', _t('GLOBAL_VISIBLE'), null, false);
        $column3->SetStyle('width: 56px; white-space:nowrap;');
        $datagrid->AddColumn($column3);
        $column4 = Piwi::CreateWidget('Column', _t('GLOBAL_ACTIONS'), null, false);
        $column4->SetStyle('width: 60px; white-space: nowrap;');
        $datagrid->AddColumn($column4);
        $datagrid->SetStyle('margin-top: 0px; width: 100%;');


        return $datagrid->Get();
    }

    /**
     * Show recipients list
     *
     * @access  public
     * @return  string HTML content
     */
    function Recipients()
    {
        $this->CheckPermission('ManageRecipients');
        $this->AjaxMe('script.js');

        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('AdminRecipients.html');
        $tpl->SetBlock('recipients');

        $tpl->SetVariable('menubar', $this->MenuBar('Recipients'));
        $tpl->SetVariable('grid', $this->RecipientsDataGrid());

        // Tabs titles
        $tpl->SetVariable('legend_title', _t('CONTACT_RECIPIENTS_ADD'));

        $titleentry =& Piwi::CreateWidget('Entry', 'name', '');
        $titleentry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_name', _t('GLOBAL_TITLE'));
        $tpl->SetVariable('name', $titleentry->Get());

        $emailentry =& Piwi::CreateWidget('Entry', 'email', '');
        $emailentry->setStyle('direction: ltr; width: 160px;');
        $tpl->SetVariable('lbl_email', _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('email', $emailentry->Get());

        $entry =& Piwi::CreateWidget('Entry', 'tel', '');
        $entry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_tel', _t('CONTACT_TEL'));
        $tpl->SetVariable('tel', $entry->Get());

        $entry =& Piwi::CreateWidget('Entry', 'fax', '');
        $entry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_fax', _t('CONTACT_FAX'));
        $tpl->SetVariable('fax', $entry->Get());

        $entry =& Piwi::CreateWidget('Entry', 'mobile', '');
        $entry->setStyle('width: 160px;');
        $tpl->SetVariable('lbl_mobile', _t('CONTACT_MOBILE'));
        $tpl->SetVariable('mobile', $entry->Get());

        $informType =& Piwi::CreateWidget('Combo', 'inform_type');
        $informType->SetID('inform_type');
        $informType->setStyle('width: 164px;');
        $informType->AddOption(_t('GLOBAL_DISABLE'), 0);
        $informType->AddOption(_t('GLOBAL_EMAIL'),   1);
        $informType->SetDefault(0);
        $tpl->SetVariable('lbl_inform_type', _t('CONTACT_RECIPIENTS_INFORM_TYPE'));
        $tpl->SetVariable('inform_type', $informType->Get());

        $visibleType =& Piwi::CreateWidget('Combo', 'visible');
        $visibleType->SetID('visible');
        $visibleType->setStyle('width: 80px;');
        $visibleType->AddOption(_t('GLOBAL_NO'),  0);
        $visibleType->AddOption(_t('GLOBAL_YES'), 1);
        $visibleType->SetDefault(1);
        $tpl->SetVariable('lbl_visible', _t('GLOBAL_VISIBLE'));
        $tpl->SetVariable('visible', $visibleType->Get());

        $btnCancel =& Piwi::CreateWidget('Button', 'btn_cancel', _t('GLOBAL_CANCEL'), STOCK_CANCEL);
        $btnCancel->AddEvent(ON_CLICK, 'stopAction();');
        $tpl->SetVariable('btn_cancel', $btnCancel->Get());

        $btnSave =& Piwi::CreateWidget('Button', 'btn_save', _t('GLOBAL_SAVE'), STOCK_SAVE);
        $btnSave->SetEnabled($this->GetPermission('ManageRecipients'));
        $btnSave->AddEvent(ON_CLICK, 'updateRecipient();');
        $tpl->SetVariable('btn_save', $btnSave->Get());

        $tpl->SetVariable('incompleteRecipientFields', _t('CONTACT_INCOMPLETE_FIELDS'));
        $tpl->SetVariable('confirmRecipientDelete',    _t('CONTACT_CONFIRM_DELETE_RECIPIENT'));

        $tpl->ParseBlock('recipients');

        return $tpl->Get();
    }

    /**
     * Show contacts Setting
     *
     * @access  public
     * @return  string HTML content
     */
    function Properties()
    {
        $this->CheckPermission('UpdateProperties');
        $this->AjaxMe('script.js');

        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('AdminProperties.html');
        $tpl->SetBlock('Properties');

        //Menu bar
        $tpl->SetVariable('menubar', $this->MenuBar('Properties'));

        $use_antispam = $GLOBALS['app']->Registry->Get('/gadgets/Contact/use_antispam');
        $antispamCombo =& Piwi::CreateWidget('Combo', 'use_antispam');
        $antispamCombo->SetID('use_antispam');
        $antispamCombo->setStyle('width: 128px;');
        $antispamCombo->AddOption(_t('GLOBAL_NO'),  'false');
        $antispamCombo->AddOption(_t('GLOBAL_YES'), 'true');
        $antispamCombo->SetDefault($use_antispam);
        $tpl->SetVariable('lbl_use_antispam', _t('CONTACT_PROPERTIES_USE_ANTISPAM'));
        $tpl->SetVariable('use_antispam', $antispamCombo->Get());

        $use_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Contact/use_captcha');
        $captchaCombo =& Piwi::CreateWidget('Combo', 'use_captcha');
        $captchaCombo->SetID('use_captcha');
        $captchaCombo->setStyle('width: 128px;');
        $captchaCombo->AddOption(_t('GLOBAL_NO'),  'false');
        $captchaCombo->AddOption(_t('GLOBAL_YES'), 'true');
        $captchaCombo->SetDefault($use_captcha);
        $tpl->SetVariable('lbl_use_captcha', _t('CONTACT_PROPERTIES_USE_CAPTCHA'));
        $tpl->SetVariable('use_captcha', $captchaCombo->Get());

        $email_format = $GLOBALS['app']->Registry->Get('/gadgets/Contact/email_format');
        $formatCombo =& Piwi::CreateWidget('Combo', 'email_format');
        $formatCombo->SetID('email_format');
        $formatCombo->setStyle('width: 128px;');
        $formatCombo->AddOption(_t('CONTACT_PROPERTIES_EMAIL_FORMAT_PLAINTEXT'), 'text');
        $formatCombo->AddOption(_t('CONTACT_PROPERTIES_EMAIL_FORMAT_HTML'),      'html');
        $formatCombo->SetDefault($email_format);
        $tpl->SetVariable('lbl_email_format', _t('CONTACT_PROPERTIES_EMAIL_FORMAT'));
        $tpl->SetVariable('email_format', $formatCombo->Get());

        if ($this->GetPermission('UpdateSetting')) {
            $btnupdate =& Piwi::CreateWidget('Button', 'btn_save', _t('GLOBAL_SAVE'), STOCK_SAVE);
            $btnupdate->AddEvent(ON_CLICK, 'updateProperties();');
            $tpl->SetVariable('btn_save', $btnupdate->Get());
        }

        $tpl->ParseBlock('Properties');
        return $tpl->Get();
    }
}
