<?php
/**
 * Contact Gadget
 *
 * @category   Gadget
 * @package    Contact
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ContactHTML extends Jaws_GadgetHTML
{
    /**
     * Main Constructor
     *
     * @access  public
     */
    function ContactHTML()
    {
        $this->Init('Contact');
    }

    /**
     * Default Action
     *
     * @access  public
     * @return  string  HTML content of DefaultAction
     */
    function DefaultAction()
    {
        $this->SetTitle(_t('CONTACT_US'));
        $layoutGadget = $GLOBALS['app']->LoadGadget('Contact', 'LayoutHTML');
        return $layoutGadget->Display();
    }

    /**
     * ContactMini Action
     *
     * @access  public
     * @return  string  HTML content of ContactMini
     */
    function ContactMini()
    {
        $this->SetTitle(_t('CONTACT_US'));
        $layoutGadget = $GLOBALS['app']->LoadGadget('Contact', 'LayoutHTML');
        return $layoutGadget->DisplayMini();
    }

    /**
     * ContactSimple Action
     *
     * @access  public
     * @return  string  HTML content of ContactSimple
     */
    function ContactSimple()
    {
        $this->SetTitle(_t('CONTACT_US'));
        $layoutGadget = $GLOBALS['app']->LoadGadget('Contact', 'LayoutHTML');
        return $layoutGadget->DisplaySimple();
    }

    /**
     * ContactFull Action
     *
     * @access  public
     * @return  string  HTML content of ContactFull
     */
    function ContactFull()
    {
        $this->SetTitle(_t('CONTACT_US'));
        $layoutGadget = $GLOBALS['app']->LoadGadget('Contact', 'LayoutHTML');
        return $layoutGadget->DisplayFull();
    }

    /**
     * Save contact in database
     *
     * @access  public
     */
    function Send()
    {
        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('contact_name', 'contact_email', 'contact_company', 'contact_url',
                                    'contact_tel', 'contact_fax', 'contact_mobile', 'contact_address',
                                    'captcha', 'captchaKey', 'contact_recipient', 'contact_subject', 'contact_message'),
                              'post');
        require_once JAWS_PATH . 'include/Jaws/Header.php';

        if ($GLOBALS['app']->Session->Logged()) {
            $post['contact_name']  = $GLOBALS['app']->Session->GetAttribute('name');
            $post['contact_email'] = $GLOBALS['app']->Session->GetAttribute('email');
            $post['contact_url']   = $GLOBALS['app']->Session->GetAttribute('url');
        }

        if (trim($post['contact_name'])    == '' ||
            trim($post['contact_subject']) == '' ||
            trim($post['contact_message']) == '')
        {
            $GLOBALS['app']->Session->PushSimpleResponse(_t('GLOBAL_ERROR_INCOMPLETE_FIELDS'), 'Contact');
            $GLOBALS['app']->Session->PushSimpleResponse($post, 'Contact_Data');
            Jaws_Header::Referrer();
        }

        if (!$GLOBALS['app']->Session->Logged()) {
            if ($GLOBALS['app']->Registry->Get('/gadgets/Contact/use_captcha') == 'true') {
                $GLOBALS['app']->Registry->LoadFile('Policy');
                $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
                if ($_captcha != 'DISABLED') {
                    require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
                    $captcha = new $_captcha();
                    if (!$captcha->Check()) {
                        $GLOBALS['app']->Session->PushSimpleResponse(_t('GLOBAL_CAPTCHA_ERROR_DOES_NOT_MATCH'), 'Contact');
                        $GLOBALS['app']->Session->PushSimpleResponse($post, 'Contact_Data');
                        Jaws_Header::Referrer();
                    }
                }
            }
        }

        if ($GLOBALS['app']->Registry->Get('/gadgets/Contact/use_antispam') == 'true') {
            require_once JAWS_PATH . 'libraries/pear/Validate.php';
            if (Validate::email($post['contact_email'], true) === false) {
                $GLOBALS['app']->Session->PushSimpleResponse(_t('CONTACT_RESULT_BAD_EMAIL_ADDRESS'), 'Contact');
                $GLOBALS['app']->Session->PushSimpleResponse($post, 'Contact_Data');
                Jaws_Header::Referrer();
            }
        }

        $model = $GLOBALS['app']->LoadGadget('Contact', 'Model');
        $result = $model->InsertContact($post['contact_name'],
                                        $post['contact_email'],
                                        $post['contact_company'],
                                        $post['contact_url'],
                                        $post['contact_tel'],
                                        $post['contact_fax'],
                                        $post['contact_mobile'],
                                        $post['contact_address'],
                                        $post['contact_recipient'],
                                        $post['contact_subject'],
                                        $post['contact_message']);
        if (Jaws_Error::IsError($result)) {
            $res_msg = _t('CONTACT_RESULT_ERROR_DB');
        } else {
            $cid = $GLOBALS['db']->lastInsertID('contacts', 'id');
            $rid = (int)$post['contact_recipient'];
            if (!empty($rid)) {
                $recipient = $model->GetRecipient((int)$post['contact_recipient']);
                if (Jaws_Error::IsError($recipient) || !isset($recipient['id'])) {
                    $res_msg = _t('CONTACT_ERROR_RECIPIENT_DOES_NOT_EXISTS');
                } elseif ($recipient['inform_type'] == 1) { //Send To Email
                    $to = $recipient['email'];
                    $model->SendEmailToRecipient($to, $cid);
                }
            }
            $res_msg = _t('CONTACT_RESULT_SENT');
        }
        $GLOBALS['app']->Session->PushSimpleResponse($res_msg, 'Contact');
        Jaws_Header::Referrer();
    }
}
