<?php
/**
 * Contact admin model
 *
 * @category   GadgetModel
 * @package    Contact
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ContactModel extends Jaws_Model
{
    /**
     * We define the gadget name
     */
    var $_Name = 'Contact';

    /**
     * Get information of a Contact
     *
     * @access  public
     * @param   int Contact ID
     * @return  array Array of Contact Information or Jaws_Error on failure
     */
    function GetContact($id)
    {
        $sql = '
            SELECT
                [id], [name], [email], [company], [url], [tel], [fax], [mobile], [address],
                [recipient], [subject], [msg_txt], [createtime], [updatetime]
            FROM [[contacts]]
            WHERE [id] = {id}';

        $result = $GLOBALS['db']->queryRow($sql, array('id' => $id));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Get information of one Recipient
     *
     * @access  public
     * @param   string ID of the Recipient
     * @return  array  Array with the information of a Recipient or Jaws_Error on failure
     */
    function GetRecipient($id)
    {
        $sql = '
            SELECT
                [id], [name], [email], [tel], [fax], [mobile], [inform_type], [visible]
            FROM [[contacts_recipients]]
            WHERE [id] = {id}';

        $row = $GLOBALS['db']->queryRow($sql, array('id' => $id));
        if (Jaws_Error::IsError($row)) {
            return new Jaws_Error($row->getMessage(), 'SQL');
        }

        if (isset($row['id'])) {
            return $row;
        }

        return new Jaws_Error(_t('CONTACT_ERROR_RECIPIENT_DOES_NOT_EXISTS'), _t('CONTACT_NAME'));
    }

    /**
     * Get a list of the available Recipients
     *
     * @access  public
     * @param   boolean
     * @param   boolean
     * @param   boolean
     * @return  array Array of Recipients or Jaws_Error on failure
     */
    function GetRecipients($onlyVisible = false, $limit = false, $offset = null)
    {
        if (is_numeric($limit)) {
            $res = $GLOBALS['db']->setLimit($limit, $offset);
            if (Jaws_Error::IsError($res)) {
                return new Jaws_Error($res->getMessage(), 'SQL');
            }
        }

        if ($onlyVisible) {
            $sql = '
                SELECT
                    [id], [name], [email], [tel], [fax], [mobile]
                FROM [[contacts_recipients]]
                WHERE [visible] = 1';
        } else {
            $sql = '
                SELECT
                    [id], [name], [email], [tel], [fax], [mobile], [visible]
                FROM [[contacts_recipients]]';
        }

        $result = $GLOBALS['db']->queryAll($sql);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Sends email to user
     *
     * @access  public
     * @param   string  $name       Name
     * @param   string  $email      Email address
     * @param   string  $$company
     * @param   string  $url
     * @param   string  $tel
     * @param   string  $fax
     * @param   string  $mobile
     * @param   string  $address
     * @param   string  $rcipient   Rcipient ID
     * @param   string  $subject    Subject of message
     * @param   string  $message    Message content
     * @return  boolean Success/Failure
     */
    function InsertContact($name, $email, $company, $url, $tel, $fax, $mobile, $address, $rcipient, $subject, $message)
    {
        $sql = "
            INSERT INTO [[contacts]]
                ([name], [email], [company], [url], [tel], [fax], [mobile], [address], [recipient],
                [subject], [msg_txt], [reply], [reply_sent], [createtime], [updatetime])
            VALUES
                ({name}, {email}, {company}, {url}, {tel}, {fax}, {mobile}, {address}, {rcipient}, {subject}, {message},
                {reply}, {reply_sent}, {now}, {now})";

        MDB2::loadFile('Date');
        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $params = array();
        $params['name']       = $xss->parse($name);
        $params['email']      = $xss->parse($email);
        $params['company']    = $xss->parse($company);
        $params['url']        = $xss->parse($url);
        $params['tel']        = $xss->parse($tel);
        $params['fax']        = $xss->parse($fax);
        $params['mobile']     = $xss->parse($mobile);
        $params['address']    = $xss->parse($address);
        $params['rcipient']   = (int)$rcipient;
        $params['subject']    = $xss->parse($subject);
        $params['message']    = $xss->parse($message);
        $params['reply']      = '';
        $params['reply_sent'] = 0;
        $params['now']      = MDB2_Date::mdbNow();

        $result = $GLOBALS['db']->query($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return false;
        }

        Jaws_Session_Web::SetCookie('visitor_name',  $name,  time()+(60*24*150));
        Jaws_Session_Web::SetCookie('visitor_email', $email, time()+(60*24*150));
        Jaws_Session_Web::SetCookie('visitor_url',   $url,   time()+(60*24*150));

        return true;
    }

    /**
     * Send email to recipient
     *
     * @access  public
     * @param   string   $to   Recipient email address
     * @param   integer  $cid   Contact ID
     * @return  boolean Success/Failure
     */
    function SendEmailToRecipient($to, $cid)
    {
        $contact = $this->GetContact($cid);
        if (Jaws_Error::IsError($contact)) {
            return $contact;
        }
        if (!isset($contact['id'])) {
            return new Jaws_Error(_t('CONTACT_ERROR_CONTACT_DOES_NOT_EXISTS'), _t('CONTACT_NAME'));
        }

        $from_name  = $contact['name'];
        $from_email = $contact['email'];

        $format = $GLOBALS['app']->Registry->Get('/gadgets/Contact/email_format');
        if ($format == 'html') {
            require_once JAWS_PATH . 'include/Jaws/StringHtml.php';
            $message = Jaws_StringHtml::AutoParagraph($contact['msg_txt']);
        } else {
            $message = $contact['msg_txt'];
        }

        $tpl = new Jaws_Template('gadgets/Contact/templates/');
        $tpl->Load('SendToRecipient.html', false, true);
        $tpl->SetBlock($format);
        $tpl->SetVariable('lbl_name',      _t('GLOBAL_NAME'));
        $tpl->SetVariable('lbl_email',     _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('lbl_company',   _t('CONTACT_COMPANY'));
        $tpl->SetVariable('lbl_url',       _t('GLOBAL_URL'));
        $tpl->SetVariable('lbl_tel',       _t('CONTACT_TEL'));
        $tpl->SetVariable('lbl_fax',       _t('CONTACT_FAX'));
        $tpl->SetVariable('lbl_mobile',    _t('CONTACT_MOBILE'));
        $tpl->SetVariable('lbl_address',   _t('CONTACT_ADDRESS'));
        $tpl->SetVariable('lbl_recipient', _t('CONTACT_RECIPIENT'));
        $tpl->SetVariable('lbl_subject',   _t('CONTACT_SUBJECT'));
        $tpl->SetVariable('lbl_message',   _t('CONTACT_MESSAGE'));
        $tpl->SetVariable('name',          $contact['name']);
        $tpl->SetVariable('email',         $contact['email']);
        $tpl->SetVariable('company',       $contact['company']);
        $tpl->SetVariable('url',           $contact['url']);
        $tpl->SetVariable('tel',           $contact['tel']);
        $tpl->SetVariable('fax',           $contact['fax']);
        $tpl->SetVariable('mobile',        $contact['mobile']);
        $tpl->SetVariable('address',       $contact['address']);
        $tpl->SetVariable('recipient',     $to);
        $tpl->SetVariable('subject',       $contact['subject']);
        $tpl->SetVariable('message',       $message);
        $tpl->ParseBlock($format);
        $template = $tpl->Get();

        require_once JAWS_PATH . 'include/Jaws/Mail.php';
        $mail = new Jaws_Mail;
        $mail->SetHeaders($to, $from_name, $from_email, $contact['subject']);
        $mail->AddRecipient($to, false, false);
        $mail->SetBody($template, $format);
        $result = $mail->send();
        if (Jaws_Error::IsError($result)) {
            return $result;
        }

        return true;
    }
}