/**
 * Contact Javascript actions
 *
 * @category   Ajax
 * @package    Contact
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh  <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
/**
 * Use async mode, create Callback
 */
var ContactCallback = {
    updatecontact: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getDG();
            stopAction();
        }
        showResponse(response);
    },

    updatereply: function(response) {
        if (response[0]['css'] == 'notice-message') {
            stopAction();
        }
        showResponse(response);
    },

    deleterecipient: function(response) {
        if (response[0]['css'] == 'notice-message') {
            $('recipient_datagrid').deleteItem();          
            getDG();
            stopAction();
        }
        showResponse(response);
    },
    
    insertrecipient: function(response) {
        if (response[0]['css'] == 'notice-message') {
            $('recipient_datagrid').addItem();
            $('recipient_datagrid').setCurrentPage(0);
            getDG();
            stopAction();
        }
        showResponse(response);
    },

    updaterecipient: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getDG();
            stopAction();
        }
        showResponse(response);
    },

    updateproperties: function(response) {
        showResponse(response);
    },

    deletecontact: function(response) {
        if (response[0]['css'] == 'notice-message') {
            $('contacts_datagrid').deleteItem();          
            getDG();
            stopAction();
        }
        showResponse(response);
    }
}

function isValidEmail(email) {
    return (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,4})+$/.test(email));
}

/**
 * Select DataGrid row
 *
 */
function selectDataGridRow(rowElement)
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRowColor = rowElement.style.backgroundColor;
    rowElement.style.backgroundColor = '#ffffcc';
    selectedRow = rowElement;
}

/**
 * Unselect DataGrid row
 *
 */
function unselectDataGridRow()
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRow = null;
    selectedRowColor = null;
}

/**
 * Clean the form
 *
 */
function stopAction() 
{
    switch(currentAction) {
    case 'Recipients':
        $('id').value      = 0;
        $('name').value    = '';
        $('email').value   = '';
        $('tel').value     = '';
        $('fax').value     = '';
        $('mobile').value  = '';
        $('inform_type').value  = 0;
        $('visible').value = 1;
        unselectDataGridRow();
        $('name').focus();
        break;
    case 'Contacts':
        $('id').value      = 0;
        $('name').value    = '';
        $('email').value   = '';
        $('company').value = '';
        $('url').value     = '';
        $('tel').value     = '';
        $('fax').value     = '';
        $('mobile').value  = '';
        $('address').value = '';
        $('rid').selectedIndex = -1;
        $('subject').value = '';
        $('message').value = '';
        $('btn_save_send').style.display = 'none';
        $('btn_save').style.visibility   = 'hidden';
        $('btn_cancel').style.visibility = 'hidden';
        unselectDataGridRow();
        $('name').focus();
        break;
    case 'Reply':
        $('id').value      = 0;
        $('name').value    = '';
        $('email').value   = '';
        $('subject').value = '';
        $('message').value = '';
        $('reply').value   = '';
        $('reply').readOnly = true;
        $('btn_save_send').style.display = 'none';
        $('btn_save').style.visibility   = 'hidden';
        $('btn_cancel').style.visibility = 'hidden';
        unselectDataGridRow();
    }
}

/**
 * Edit a Contact
 *
 */
function editContact(element, id)
{
    currentAction = 'Contacts';
    $('legend_title').innerHTML = messageDetail_title;
    if (cacheContactForm != null) {
        $('c_work_area').innerHTML = cacheContactForm;
    }

    selectDataGridRow(element.parentNode.parentNode);

    var contact = contactSync.getcontact(id);
    $('id').value      = contact['id'];
    $('name').value    = contact['name'];
    $('email').value   = contact['email'];
    $('company').value = contact['company'];
    $('url').value     = contact['url'];
    $('tel').value     = contact['tel'];
    $('fax').value     = contact['fax'];
    $('mobile').value  = contact['mobile'];
    $('address').value = contact['address'];
    $('rid').value     = contact['recipient'];
    $('subject').value = contact['subject'];
    $('message').value = contact['msg_txt'];
    $('btn_save_send').style.display = 'none';
    $('btn_save').style.visibility   = 'visible';
    $('btn_cancel').style.visibility = 'visible';
}

/**
 * Edit Poll Answers
 */
function editReply(element, id)
{
    if (cacheContactForm == null) {
        cacheContactForm = $('c_work_area').innerHTML;
    }

    selectDataGridRow(element.parentNode.parentNode);

    if (cacheReplyForm == null) {
        cacheReplyForm = contactSync.replyui();
    }
    currentAction = 'Reply';

    selectedContact = id;
    $('legend_title').innerHTML = contactReply_title;
    $('c_work_area').innerHTML = cacheReplyForm;
    var replyData = contactSync.getreply(selectedContact);
    $('id').value      = replyData['id'];
    $('name').value    = replyData['name'];
    $('email').value   = replyData['email'];
    $('subject').value = replyData['subject'];
    $('message').value = replyData['msg_txt'];
    $('reply').value   = replyData['reply'];
    $('btn_save').style.visibility   = 'visible';
    $('btn_cancel').style.visibility = 'visible';
    $('btn_save_send').style.display = 'inline';
    $('reply').readOnly = Boolean(replyData['readonly']);
    $('reply').focus();
}

/**
 * Update a Contact
 */
function updateContact(send_reply)
{
    switch(currentAction) {
    case 'Contacts':
        contactAsync.updatecontact(
                        $('id').value,
                        $('name').value,
                        $('email').value,
                        $('company').value,
                        $('url').value,
                        $('tel').value,
                        $('fax').value,
                        $('mobile').value,
                        $('address').value,
                        $('rid').value,
                        $('subject').value,
                        $('message').value);
        break;
    case 'Reply':
        contactAsync.updatereply(
                        $('id').value,
                        $('reply').value,
                        send_reply);
        break;
    }
}

/**
 * Delete contact
 *
 */
function deleteContact(element, id)
{
    stopAction();
    selectDataGridRow(element.parentNode.parentNode);
    if (confirm(confirmContactDelete)) {
        contactAsync.deletecontact(id);
    }
    unselectDataGridRow();
}

/**
 * Edit a Recipient
 *
 */
function editRecipient(element, id)
{
    currentAction = 'Recipients';
    selectDataGridRow(element.parentNode.parentNode);
    var recipient = contactSync.getrecipient(id);
    $('id').value      = recipient['id'];
    $('name').value    = recipient['name'];
    $('email').value   = recipient['email'];
    $('tel').value     = recipient['tel'];
    $('fax').value     = recipient['fax'];
    $('mobile').value  = recipient['mobile'];
    $('inform_type').value = recipient['inform_type'];
    $('visible').value = recipient['visible'];
}

/**
 * Add/Update a Recipient
 */
function updateRecipient()
{
    if (jawsTrim($('name').value) == '' ||
        jawsTrim($('email').value) == '' ||
        !isValidEmail(jawsTrim($('email').value))) {
        alert(incompleteRecipientFields);
        return;
    }

    if($('id').value==0) {
        contactAsync.insertrecipient(
                        $('name').value,
                        $('email').value,
                        $('tel').value,
                        $('fax').value,
                        $('mobile').value,
                        $('inform_type').value,
                        $('visible').value);
    } else {
        contactAsync.updaterecipient(
                        $('id').value,
                        $('name').value,
                        $('email').value,
                        $('tel').value,
                        $('fax').value,
                        $('mobile').value,
                        $('inform_type').value,
                        $('visible').value);
    }
}

/**
 * Delete a Recipient
 */
function deleteRecipient(element, id)
{
    stopAction();
    selectDataGridRow(element.parentNode.parentNode);
    if (confirm(confirmRecipientDelete)) {
        contactAsync.deleterecipient(id);
    }
    unselectDataGridRow();
}

/**
 * Update the properties
 *
 */
function updateProperties()
{
    contactAsync.updateproperties(
                        $('use_antispam').value,
                        $('use_captcha').value,
                        $('email_format').value);
}

var contactAsync = new contactadminajax(ContactCallback);
contactAsync.serverErrorFunc = Jaws_Ajax_ServerError;
contactAsync.onInit = showWorkingNotification;
contactAsync.onComplete = hideWorkingNotification;

var contactSync  = new contactadminajax();
contactSync.serverErrorFunc = Jaws_Ajax_ServerError;
contactSync.onInit = showWorkingNotification;
contactSync.onComplete = hideWorkingNotification;

//Cache for Contact template
var cacheContactForm = null;
//Cache for Contact Reply template
var cacheReplyForm = null;

//Which action are we runing?
var currentAction = null;

//Which row selected in DataGrid
var selectedRow = null;
var selectedRowColor = null;
