<?php
/**
 * ControlPanel Core Gadget Admin
 *
 * @category   GadgetAdmin
 * @package    ControlPanel
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class ControlPanelAdminHTML extends Jaws_GadgetHTML
{
    /**
     * Gadget constructor
     *
     * @access public
     */
    function ControlPanelAdminHTML()
    {
        $this->Init('ControlPanel');
    }

    /**
     * Calls default action(MainMenu)
     *
     * @access public
     * @return string template content
     */
    function DefaultAction()
    {
        return $this->MainMenu();
    }

    /**
     * Displays the Control Panel main menu
     *
     * @access       public
     * @return       template content
     */
    function MainMenu()
    {
        // Load the template
        $tpl = new Jaws_Template('gadgets/ControlPanel/templates/');
        $tpl->Load('MainMenu.html');

        $jms = $GLOBALS['app']->LoadGadget('Jms', 'AdminModel');
        $coreGadgets = array_keys($jms->GetGadgetsList(true, true, true));

        $general = array();
        $coreitems = $GLOBALS['app']->Registry->Get('/gadgets/core_items');
        $coreitems = explode(',', $coreitems);
        foreach ($coreitems as $item) {
            if (!is_dir(JAWS_PATH . 'gadgets/' . $item)) continue;
            if ($item != '' && $item != 'ControlPanel' && in_array($item, $coreGadgets)) {
                if (Jaws_Error::IsError(Jaws_GadgetInfo::Init($item))) {
                    continue;
                }

                if ($this->GetPermission('Manage'.$item, $item)) {
                    $general[] = array(_t(strtoupper($item).'_NAME'),
                                       _t(strtoupper($item).'_DESCRIPTION'),
                                       'gadgets/'.$item.'/images/logo.png',
                                       BASE_SCRIPT . '?gadget='.$item);
                }
            }
        }

       /*
       if ($this->GetPermission('DatabaseBackups')) {
            $general[] = array(_t('CONTROLPANEL_GENERAL_BACKUP'),
                               _t('CONTROLPANEL_GENERAL_BACKUP'),
                               'gadgets/ControlPanel/images/db-backup.png',
                               BASE_SCRIPT . '?gadget=ControlPanel&amp;action=DBBackup');
        }
        */

        if ($GLOBALS['app']->Registry->Get('/config/show_viewsite') == 'true') {
            $general[] = array(_t('CONTROLPANEL_GENERAL_VIEWSITE'),
                               _t('CONTROLPANEL_GENERAL_VIEWSITE'),
                               'gadgets/ControlPanel/images/view_site.png',
                               'index.php');
        }
        
        //If no items are found for general section then we shoudln't print it
        if (count($general) > 0) {
            // Parse out core gadgets and CP components
            $tpl->SetBlock('main');
            $tpl->SetVariable('title',_t('CONTROLPANEL_GENERAL'));
            foreach ($general as $item) {
                $tpl->SetBlock('main/item');
                $tpl->SetVariable('name', $item[0]);
                $tpl->SetVariable('desc', $item[1]);
                $tpl->SetVariable('icon', Jaws::CheckImage($item[2]));
                $tpl->SetVariable('url', $item[3]);
                $tpl->ParseBlock('main/item');
            }
            $tpl->ParseBlock('main');
        }

        // gadgets
        $installedgadgets = array();
        $gadgetsections = array();
        $last = '';

        $gadgets = $jms->GetGadgetsList(false, true, true);
        foreach ($gadgets as $gadget => $tgadget) {
            if ($this->GetPermission('default', $gadget)) {
                $gadgetinfo = $GLOBALS['app']->loadGadget($gadget, 'Info');
                if (!Jaws_Error::IsError($gadgetinfo)) {
                    $section = $gadgetinfo->GetSection();
                    if (!isset($gadgetsections[$section]['gadgets'])) {
                        $gadgetsections[$section]['gadgets'] = array();
                        $gadgetsections[$section]['section'] = $section;
                    }
                    $tmp = array(
                                 'name'  => $gadget,
                                 'tname' => $tgadget['name'],
                                 'desc'  => $tgadget['description'],
                                 );

                    array_push($gadgetsections[$section]['gadgets'], $tmp);
                }
            }
        }

        foreach ($gadgetsections as $section) {
            $tpl->SetBlock('main');
            $tpl->SetVariable('title', _t('CONTROLPANEL_' . strtoupper($section['section'])));
            foreach ($section['gadgets'] as $gadget) {
                $tpl->SetBlock('main/item');
                $tpl->SetVariable('name', $gadget['tname']);
                $tpl->SetVariable('desc', $gadget['desc']);
                $tpl->SetVariable('icon', Jaws::CheckImage('gadgets/'.$gadget['name'].'/images/logo.png'));
                $tpl->SetVariable('url', BASE_SCRIPT . '?gadget='.$gadget['name']);
                $tpl->ParseBlock('main/item');
            }
            $tpl->ParseBlock('main');
        }

        if ($this->GetPermission('ManageGadgets', 'Jms')) {
            $GLOBALS['app']->Translate->LoadTranslation('Jms', JAWS_PATH . 'gadgets');

            $jms = $GLOBALS['app']->LoadGadget('Jms', 'AdminModel');
            //Count non-installed gadgets..
            $noninstalled = $jms->GetGadgetsList(null, false);
            //Count out date gadgets..
            $nonupdated   = $jms->GetGadgetsList(null, true, false);
            $jms = null;
            if ((count($noninstalled) + count($nonupdated)) > 0) {
                $tpl->SetBlock('sidebar');
                if (count($noninstalled) > 0) {
                    $tpl->SetBlock('sidebar/notifications');
                    $tpl->SetVariable('notify-title', _t('JMS_SIDEBAR_DISABLED_GADGETS'));
                    $tpl->SetVariable('notify_desc', _t('JMS_SIDEBAR_GADGETS_WAITING'));
                    foreach ($noninstalled as $key => $gadget) {
                        $tpl->SetBlock('sidebar/notifications/item');
                        $gadgetCompleteDesc = $gadget['name'] . ' - ' . $gadget['description'];
                        $icon = Jaws::CheckImage('gadgets/' . $key . '/images/logo.png');
                        $tpl->SetVariable('title', $gadgetCompleteDesc);
                        $tpl->SetVariable('name', $gadget['name']);
                        $tpl->SetVariable('icon', $icon);
                        $tpl->SetVariable('url', BASE_SCRIPT . '?gadget=Jms&amp;action=EnableGadget&amp;comp='.
                                          $key . '&amp;location=sidebar');
                        $tpl->SetVariable('install', _t('JMS_INSTALL'));
                        $tpl->ParseBlock('sidebar/notifications/item');
                    }
                    $tpl->ParseBlock('sidebar/notifications');
                }

                if (count($nonupdated) > 0) {
                    $tpl->SetBlock('sidebar/notifications');
                    $tpl->SetVariable('notify-title', _t('JMS_SIDEBAR_NOTUPDATED_GADGETS'));
                    $tpl->SetVariable('notify_desc', _t('JMS_SIDEBAR_NOTUPDATED_SUGESTION'));
                    foreach ($nonupdated as $key => $gadget) {
                        $tpl->SetBlock('sidebar/notifications/item');
                        $gadgetCompleteDesc = $gadget['name'] . ' - ' . $gadget['description'];
                        $icon = Jaws::CheckImage('gadgets/' . $key . '/images/logo.png');
                        $tpl->SetVariable('title', $gadgetCompleteDesc);
                        $tpl->SetVariable('name', $gadget['name']);
                        $tpl->SetVariable('icon', $icon);
                        $tpl->SetVariable('url', BASE_SCRIPT . '?gadget=Jms&amp;action=UpdateGadget&amp;comp='.
                                          $key . '&amp;location=sidebar');
                        $tpl->SetVariable('install', _t('JMS_UPDATE'));
                        $tpl->ParseBlock('sidebar/notifications/item');
                    }
                    $tpl->ParseBlock('sidebar/notifications');
                }
                $tpl->ParseBlock('sidebar');
            }
        }

        return $tpl->Get();
    }

    /**
     * Get HTML login form
     *
     * @access public
     * @param  string  $message If a message is needed
     * @return string  HTML of the form
     */
    function ShowLoginForm($message = '')
    {
        $GLOBALS['app']->Translate->LoadTranslation('ControlPanel', JAWS_PATH . 'gadgets');

        $use_crypt = ($GLOBALS['app']->Registry->Get('/crypt/enabled') == 'true')? true : false;
        if ($use_crypt) {
            require_once JAWS_PATH . 'include/Jaws/Crypt.php';
            $JCrypt = new Jaws_Crypt();
            $use_crypt = $JCrypt->Init();
        }

        $tpl = new Jaws_Template('gadgets/ControlPanel/templates/');
        $tpl->Load('Login.html');
        $tpl->SetBlock('login');

        $tpl->SetVariable('BASE_URL', $GLOBALS['app']->GetSiteURL().'/'.BASE_SCRIPT);
        $tpl->SetVariable('admin_script', BASE_SCRIPT);
        $tpl->SetVariable('site-name', $GLOBALS['app']->Registry->Get('/config/site_name'));
        $tpl->SetVariable('site-description', $GLOBALS['app']->Registry->Get('/config/site_description'));
        $tpl->SetVariable('control-panel', _t('CONTROLPANEL_NAME'));

        $request =& Jaws_Request::getInstance();
        $form =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'post');
        $form->setID('login_form');
        $form->shouldValidate($use_crypt, $use_crypt);

        $redirectTo = '';
        if (isset($_SERVER['QUERY_STRING'])) {
            $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            $queryString = $xss->parse($_SERVER['QUERY_STRING']);
            if (!empty($queryString)) {
                $redirectTo  = '?' . $queryString;
                $redirectTo  = $xss->filter($redirectTo);
            }
        }

        $form->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'ControlPanel'));
        $form->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'Login'));
        $form->Add(Piwi::CreateWidget('HiddenEntry', 'redirect_to', $redirectTo));

        if ($use_crypt) {
            $form->Add(Piwi::CreateWidget('HiddenEntry', 'modulus',  $JCrypt->math->bin2int($JCrypt->pub_key->getModulus())));
            $form->Add(Piwi::CreateWidget('HiddenEntry', 'exponent', $JCrypt->math->bin2int($JCrypt->pub_key->getExponent())));
        }

        include_once JAWS_PATH . 'include/Jaws/Widgets/FieldSet.php';
        $fieldset = new Jaws_Widgets_FieldSet(_t('CONTROLPANEL_LOGIN_TITLE'));
        $fieldset->SetDirection('vertical');
        $fieldset->SetStyle('width: 100%;');

        $username = $request->get('username', 'post');
        $usernameEntry =& Piwi::CreateWidget('Entry', 'username',
                                             isset($username) ? $username : '');
        $usernameEntry->SetTitle(_t('GLOBAL_USERNAME'));
        $fieldset->Add($usernameEntry);

        $tpl->SetVariable('loadObject', $usernameEntry->GetID());

        $passEntry =& Piwi::CreateWidget('PasswordEntry', 'password', '');
        $passEntry->SetTitle(_t('GLOBAL_PASSWORD'));
        $fieldset->Add($passEntry);

        $rememberMe =& Piwi::CreateWidget('CheckButtons', 'remember');
        $rememberMe->setID('remember');
        $rememberMe->setColumns(1);
        $rememberMe->AddOption(_t('GLOBAL_REMEMBER_ME'), 'true');
        $fieldset->Add($rememberMe);

        if ($use_crypt) {
            $useCrypt =& Piwi::CreateWidget('CheckButtons', 'usecrypt');
            $useCrypt->setID('usecrypt');
            $useCrypt->setColumns(1);
            $useCrypt->AddOption(_t('CONTROLPANEL_LOGIN_SECURE'), 'true');
            $useCrypt->SetDefault('true');
            $fieldset->Add($useCrypt);
        }

        $submit =& Piwi::CreateWidget('Button', 'loginButton', _t('GLOBAL_LOGIN'), STOCK_OK);
        $submit->SetSubmit();
        $fieldset->Add($submit);

        $form->Add($fieldset);

        $tpl->SetVariable('form', $form->Get());
        $tpl->SetVariable('back', _t('CONTROLPANEL_LOGIN_BACK_TO_SITE'));

        $prefix = '.' . strtolower(_t('GLOBAL_LANG_DIRECTION'));
        if ($prefix !== '.rtl') {
            $prefix = '';
        }

        $hLinks = $GLOBALS['app']->Layout->AddHeadLink(
                                    'gadgets/ControlPanel/resources/public.css',
                                    'stylesheet', 'text/css', '',
                                    null, false, '', true);
        $sLinks[] = $GLOBALS['app']->Layout->AddScriptLink('libraries/js/bigint.js', 'text/javascript', true);
        $sLinks[] = $GLOBALS['app']->Layout->AddScriptLink('libraries/js/bigintmath.js', 'text/javascript', true);
        $sLinks[] = $GLOBALS['app']->Layout->AddScriptLink('libraries/js/rsa.js', 'text/javascript', true);
        $tmpArray = array();
        $headContent = $GLOBALS['app']->Layout->GetHeaderContent($hLinks, $sLinks, $tmpArray, $tmpArray);

        $tpl->SetBlock('login/head');
        $tpl->SetVariable('ELEMENT', $headContent);
        $tpl->ParseBlock('login/head');

        if (!empty($message)) {
            $tpl->SetBlock('login/message');
            $tpl->SetVariable('message', $message);
            $tpl->ParseBlock('login/message');
        }

        $tpl->ParseBlock('login');

        return $tpl->Get();
    }

    /**
     * Terminates Control Panel session and redirects to website
     *
     * @access public
     */
    function Logout()
    {
        $GLOBALS['app']->Session->Logout();
        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT);
    }

    /**
     * Returns the database sql dump
     *
     * @access public
     * @return string template content
     * @todo rewrite to work with MDB2
     */
    function DBBackup()
    {
        $this->CheckPermission('DatabaseBackup');
        $GLOBALS['db']->Dump();
        $GLOBALS['app']->Session->PushLastResponse(_t('CONTROLPANEL_BACKUP_CREATED'), RESPONSE_NOTICE);
        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT);

    }
}
