<?php
/**
 * Faq Gadget
 *
 * @category   Gadget
 * @package    Faq
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class FaqHTML extends Jaws_GadgetHTML
{
    /**
     * Gadget constructor
     *
     * @access       public
     */
    function FaqHTML()
    {
        $this->Init('Faq');
    }

    /**
     * Calls default action(View)
     *
     * @access       public
     * @return       template content
     */
    function DefaultAction()
    {
        return $this->View();
    }

    /**
     * Displays a concrete question & answer
     *
     * @access       public
     * @return       template content
     */
    function ViewQuestion()
    {
        $tpl = new Jaws_Template('gadgets/Faq/templates/');
        $tpl->Load('Question.html');
        $tpl->SetBlock('faq_question');
        $model = $GLOBALS['app']->LoadGadget('Faq', 'Model');

        $request =& Jaws_Request::getInstance();
        $qid = $request->get('id', 'get');

        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $qid = $xss->defilter($qid);

        $q = $model->GetQuestion($qid);
        if (!Jaws_Error::IsError($q)) {
            $this->SetTitle($q['question']);
            $tpl->SetVariable('title', $q['question']);
            $tpl->SetVariable('answer', $this->ParseText($xss->parse($q['answer'], false), 'Faq'));
        }
        $tpl->ParseBlock('faq_question');

        return $tpl->Get();
    }

    /**
     * Displays a concrete category
     *
     * @access       public
     * @return       template content
     */
    function ViewCategory()
    {
        $model = $GLOBALS['app']->LoadGadget('Faq', 'Model');

        $request =& Jaws_Request::getInstance();
        $cat_id  = $request->get('id', 'get');

        $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $cat_id  = $xss->defilter($cat_id);

        $questions = $model->GetQuestions($cat_id, true);
        if (is_array($questions) && count($questions) > 0) {
            $tpl = new Jaws_Template('gadgets/Faq/templates/');
            $tpl->Load('Category.html');
            foreach ($questions as $cat) {
                $tpl->SetBlock('faq_category');
                $tpl->SetVariable('title', $xss->filter($cat['category']));
                $tpl->SetVariable('description', $this->ParseText($xss->parse($cat['description'], false), 'Faq'));
                if (isset($cat['questions']) && is_array($cat['questions'])) {
                    $pos = 0;
                }

                foreach ($cat['questions'] as $q) {
                    $pos++;
                    $tpl->SetBlock('faq_category/question');
                    $tpl->SetVariable('pos', $pos);
                    $tpl->SetVariable('id', $q['id']);
                    $tpl->SetVariable('question', $q['question'], 'Faq', false);
                    $tpl->SetVariable('url', $this->GetURLFor('ViewCategory', array('id' => $cat_id)).'#question'.$q['id']);
                    $tpl->ParseBlock('faq_category/question');
                }

                if (isset($cat['questions']) && is_array($cat['questions'])) {
                    $pos = 0;
                }

                foreach ($cat['questions'] as $q) {
                    $pos++;
                    $tpl->SetBlock('faq_category/item');
                    $tpl->SetVariable('top_label', _t('FAQ_GO_TO_TOP'));
                    $tpl->SetVariable('top_link', $this->GetURLFor('ViewCategory', array('id' => $cat_id)).'#topfaq');
                    $tpl->SetVariable('id', $q['id']);
                    $tpl->SetVariable('pos', $pos);
                    $qid = empty($q['fast_url']) ? $q['id'] : $xss->filter($q['fast_url']);
                    $tpl->SetVariable('url', $this->GetURLFor('ViewQuestion', array('id' => $qid)));
                    $tpl->SetVariable('question', $q['question']);
                    $tpl->SetVariable('answer', $this->ParseText($xss->parse($q['answer'], false), 'Faq'));
                    $tpl->ParseBlock('faq_category/item');
                }
                $tpl->ParseBlock('faq_category');
            }
            return $tpl->Get();
        }

        // FIXME: We should return something like "No questions found"
        return '';
    }

    /**
     * Displays complete FAQ to the user: first fastlinks and below questions and answers
     *
     * @access       public
     * @return       template content
     */
    function View()
    {
        $tpl = new Jaws_Template('gadgets/Faq/templates/');
        $tpl->Load('ViewAll.html');
        $tpl->SetBlock('faq');
        $tpl->SetVariable('title', _t('FAQ_TITLE'));
        $this->SetTitle(_t('FAQ_TITLE'));

        $model = $GLOBALS['app']->LoadGadget('Faq', 'Model');
        $questions = $model->GetQuestions(null, true);
        if (is_array($questions) && count($questions) > 0) {
            $tpl->SetBlock('faq/summary');
            $tpl->SetVariable('contents', _t('FAQ_CONTENTS'));
            $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            foreach ($questions as $cat) {
                $tpl->SetBlock('faq/summary/category');
                $tpl->SetVariable('id', $cat['id']);
                $tpl->SetVariable('category', $xss->filter($cat['category']));
                $tpl->SetVariable('description', $xss->filter($cat['description']));
                if (isset($cat['questions']) && is_array($cat['questions'])) {
                    foreach ($cat['questions'] as $q) {
                        $tpl->SetBlock('faq/summary/category/item');
                        $tpl->SetVariable('id', $q['id']);
                        $tpl->SetVariable('question', $q['question'], 'Faq', false);
                        $tpl->SetVariable('url', $this->GetURLFor('View').'#question'.$q['id']);
                        $tpl->ParseBlock('faq/summary/category/item');
                    }
                }
                $tpl->ParseBlock('faq/summary/category');
            }
            $tpl->ParseBlock('faq/summary');
            $catPos = 0;
            foreach ($questions as $cat) {
                $catPos++;
                $tpl->SetBlock('faq/category');
                $tpl->SetVariable('id', $cat['id']);
                $tpl->SetVariable('pos', $catPos);
                $tpl->SetVariable('category', $xss->filter($cat['category']));
                if (isset($cat['questions']) && is_array($cat['questions'])) {
                    $qPos = 0;
                }

                foreach ($cat['questions'] as $q) {
                    $qPos++;
                    $tpl->SetBlock('faq/category/question');
                    $tpl->SetVariable('top_label', _t('FAQ_GO_TO_TOP'));
                    $tpl->SetVariable('top_link', $this->GetURLFor('View').'#topfaq');
                    $tpl->SetVariable('pos', $qPos);
                    $tpl->SetVariable('id', $q['id']);
                    $qid = empty($q['fast_url']) ? $q['id'] : $xss->filter($q['fast_url']);
                    $tpl->SetVariable('url', $this->GetURLFor('ViewQuestion', array('id' => $qid)));
                    $tpl->SetVariable('question', $q['question']);
                    $tpl->SetVariable('answer', $this->ParseText($xss->parse($q['answer'], false), 'Faq'));
                    $tpl->ParseBlock('faq/category/question');
                }
                $tpl->ParseBlock('faq/category');
            }
        }
        $tpl->ParseBlock('faq');

        return $tpl->Get();
    }
}