<?php
/**
 * Filebrowser Admin Gadget
 *
 * @category   GadgetAdmin
 * @package    FileBrowser
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class FileBrowserAdminHTML extends Jaws_GadgetHTML
{
    /**
     * Public constructor
     *
     * @access  public
     */
    function FileBrowserAdminHTML()
    {
        $this->Init('FileBrowser');
    }

    /**
     * Prints the admin section
     *
     * @access  public
     * @return  string  HTML content of administration
     */
    function Admin()
    {
        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'AdminModel');
        $this->CheckPermission('default');

        $request =& Jaws_Request::getInstance();

        $tpl = new Jaws_Template('gadgets/FileBrowser/templates/');
        $tpl->Load('AdminFileBrowser.html');
        $tpl->SetBlock('filebrowser');
        $tpl->SetVariable('base_script', BASE_SCRIPT);

        $get = $request->get(array('path'), 'get');
        $path = !is_null($get['path']) && !empty($get['path']) ? $get['path'] : '/';

        if (!file_exists($model->GetFileBrowserRootDir() . $path)) {
            $GLOBALS['app']->Session->PushLastResponse(_t('FILEBROWSER_ERROR_DIRECTORY_DOES_NOT_EXISTS'), RESPONSE_ERROR);
        }

        $dir_array = $model->GetCurrentRootDir($path);
        $path_link = '';
        $location_link = '';
        foreach ($dir_array as $d) {
            if ($d != '/') {
                $d .= '/';
            }
            $path_link .= $d;
            $location_link .= '<a href="'.BASE_SCRIPT.'?gadget=FileBrowser&action=ReadDir&path=' . $path_link . '">' . $d . '</a>';
        }
        $tpl->SetVariable('path', $path);
        $tpl->SetVariable('location', _t('FILEBROWSER_LOCATION'));
        $tpl->SetVariable('confirm_delete_file', _t('GLOBAL_CONFIRM_DELETE', _t('FILEBROWSER_FILE')));
        $tpl->SetVariable('confirm_delete_dir', _t('GLOBAL_CONFIRM_DELETE', _t('FILEBROWSER_DIR')));
        $tpl->SetVariable('location_link', $location_link);

        $files = $model->ReadDir($path);
        if (Jaws_Error::IsError($files)) {
            Jaws_Error::Fatal($files->getMessage(), __FILE__, __LINE__);
        }

        foreach ($files as $if => $f) {
            if ($f['is_dir']) {
                $url = BASE_SCRIPT . '?gadget=FileBrowser&amp;action=ReadDir&amp;path=' . $f['relative'];
            } else {
                $url = $f['url'];
            }
            $files[$if]['file_link'] = "<span id=\"file_link$if\"><img src=\"" . JAWS_DPATH . $f['mini_icon'].
                                       "\"> <a href=\"{$url}\">{$f['filename']}</a></span>";

            $keyField =& Piwi::CreateWidget('Entry', 'file_entry'.$if, str_replace('"','&quot;', $f['filename']));
            $keyField->SetId('file_entry' . $if);
            $keyField->SetEnabled(false);

            $okButton =& Piwi::CreateWidget('Button', 'ok' . $if, '', STOCK_OK);
            $okButton->AddEvent(ON_CLICK, 'saveRename()');
            $cancelButton =& Piwi::CreateWidget('Button', 'cancel' . $if, '', STOCK_CANCEL);
            $cancelButton->AddEvent(ON_CLICK, 'cancelRename()');

            $hbox =& Piwi::CreateWidget('HBox');
            $hbox->SetId('file_entry_box' . $if);
            $hbox->SetStyle('border: 1px solid transparent; background: transparent; width: 100%; display: none;');
            $hbox->PackStart($keyField);
            $hbox->PackStart($okButton);
            $hbox->PackStart($cancelButton);

            $files[$if]['file_link'] .= $hbox->Get();
            $files[$if]['action'] = '';
            if ($f['is_dir']) {
                if ($this->GetPermission('RenameDir')) {
                    $files[$if]['action'] = '<a href="javascript:void(0);" onclick="renameFile(\'dir\', ' . $if . '); return false;">' . _t('FILEBROWSER_RENAME') . '</a>';
                }
                if ($this->GetPermission('DeleteDir')) {
                    if ($files[$if]['action'] != '') {
                        $files[$if]['action'] .= ' | ';
                    }
                    $files[$if]['action'] .= '<a href="javascript:void(0);" onclick="deleteDir(\'' . $f['filename'] . '\'); return false;">' . _t('GLOBAL_DELETE') . '</a>';
                }
            } else {
                if ($this->GetPermission('RenameFile')) {
                    $files[$if]['action'] = '<a href="javascript:void(0);" onclick="renameFile(\'file\', ' . $if . '); return false;">' . _t('FILEBROWSER_RENAME') . '</a>';
                }
                if ($this->GetPermission('DeleteFile')) {
                    if ($files[$if]['action'] != '') {
                        $files[$if]['action'] .= ' | ';
                    }
                    $files[$if]['action'] .= '<a href="javascript:void(0);" onclick="deleteFile(\'' . $f['filename'] . '\'); return false;">' . _t('GLOBAL_DELETE') . '</a>';
                }
            }
        }

        if (count($files) > 0) {
            $datagrid =& Piwi::CreateWidget('DataGrid', $files);
            $datagrid->SetID('fb_datagrid');
            $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('FILEBROWSER_FILENAME'), 'file_link', false));
            $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('FILEBROWSER_SIZE'), 'size', false));
            $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('GLOBAL_ACTIONS'), 'action', false));
            $datagrid->SetStyle('width: 100%;');
            $tpl->SetVariable('grid', $datagrid->Get());
        } else {
            $tpl->SetVariable('grid', '');
        }

        // Fieldset for forms
        include_once JAWS_PATH . 'include/Jaws/Widgets/FieldSet.php';

        if ($this->GetPermission('AddFile')) {
            $uploadform =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'post', 'multipart/form-data');
            $uploadform->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'FileBrowser'));
            $uploadform->Add(Piwi::CreateWidget('HiddenEntry', 'path', $path));
            $uploadform->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'AddFile'));

            $fieldset = new Jaws_Widgets_FieldSet(_t('FILEBROWSER_UPLOAD_FILE'));
            $file =& Piwi::CreateWidget('FileEntry', 'file', '');
            $file->SetTitle(_t('FILEBROWSER_FILENAME'));
            $fieldset->Add($file);
            $buttonbox =& Piwi::CreateWidget('HBox');
            $buttonbox->SetStyle(_t('GLOBAL_LANG_DIRECTION')=='rtl'?'float: left;' : 'float: right;'); //hig style
            $submit =& Piwi::CreateWidget('Button', 'addnewfile', _t('FILEBROWSER_UPLOAD_FILE'), STOCK_SAVE);
            $submit->SetSubmit();
            $buttonbox->Add($submit);
            $uploadform->Add($fieldset);
            $uploadform->Add($buttonbox);

            $tpl->SetVariable('upload_form', $uploadform->Get());
        } else {
            $tpl->SetVariable('upload_form', '');
        }

        if ($this->GetPermission('AddDir')) {
            $dirform =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'post');
            $dirform->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'FileBrowser'));
            $dirform->Add(Piwi::CreateWidget('HiddenEntry', 'path', $path));
            $dirform->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'AddDir'));

            $fieldset = new Jaws_Widgets_FieldSet(_t('FILEBROWSER_CREATE_DIR'));
            $dir =& Piwi::CreateWidget('Entry', 'directory', '');
            $dir->SetStyle('Width: 95%;');
            $dir->SetTitle(_t('FILEBROWSER_DIR'));
            $fieldset->Add($dir);
            $buttonbox =& Piwi::CreateWidget('HBox');
            $buttonbox->SetStyle(_t('GLOBAL_LANG_DIRECTION')=='rtl'?'float: left;' : 'float: right;'); //hig style
            $submit =& Piwi::CreateWidget('Button', 'addnewdir', _t('FILEBROWSER_CREATE_DIR'), STOCK_OK);
            $submit->SetSubmit();
            $buttonbox->Add($submit);
            $dirform->Add($fieldset);
            $dirform->Add($buttonbox);

            $tpl->SetVariable('createdir_form', $dirform->Get());
        } else {
            $tpl->SetVariable('createdir_form', '');
        }

        $tpl->ParseBlock('filebrowser');

        return $tpl->Get();
    }

    /**
     * Read a new directory and return the Admin layout
     *
     * @access  public
     * @return  string HTML content of Admin
     */
    function ReadDir()
    {
        $this->CheckPermission('default');
        return $this->Admin();
    }

    /**
     * Creates a new directory
     *
     * @access       public
     */
    function AddDir()
    {
        $this->CheckPermission('AddDir');
        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'AdminModel');

        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('path', 'directory'), 'post');

        $model->CreateDir($post['path'], $post['directory']);

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT . '?gadget=FileBrowser&action=ReadDir&path=' . $post['path']);
    }

    /**
     * Uploads a new file
     *
     * @access       public
     */
    function AddFile()
    {
        $this->CheckPermission('AddFile');
        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'AdminModel');

        $request =& Jaws_Request::getInstance();
        $path = $request->get('path', 'post');

        $uploaddir = $model->GetFileBrowserRootDir() . $path;

        require_once 'File/Util.php';
        $uploaddir = File_Util::realpath($uploaddir) . DIRECTORY_SEPARATOR;

        if (!File_Util::pathInRoot($uploaddir, $model->GetFileBrowserRootDir())) {
            $GLOBALS['app']->Session->PushLastResponse(_t('GLOBAL_ERROR_UPLOAD'), RESPONSE_ERROR);
        } else {
            $res = Jaws_Utils::UploadFiles($_FILES,
                                           $uploaddir,
                                           '',
                                           $GLOBALS['app']->Registry->Get('/gadgets/FileBrowser/black_list'));
            if (Jaws_Error::IsError($res)) {
                $GLOBALS['app']->Session->PushLastResponse($res->getMessage(), RESPONSE_ERROR);
            } else {
                $GLOBALS['app']->Session->PushLastResponse(_t('GLOBAL_FILE_UPLOADED', $res['file']), RESPONSE_NOTICE);
            }
        }

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT . '?gadget=FileBrowser&action=ReadDir&path=' . $path);
    }

    /**
     * Deletes a file or dir
     *
     * @access       private
     */
    function DeleteItem()
    {
        $this->CheckPermission('DeleteFile');
        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'AdminModel');

        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('path', 'file'), 'post');

        $model->DeleteFile($post['path'], $post['file']);

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT . '?gadget=FileBrowser&action=ReadDir&path=' . $post['path']);
    }

    /**
     * Deletes a file
     *
     * @access       public
     */
    function DeleteFile()
    {
        $this->CheckPermission('DeleteFile');
        $this->DeleteItem();
    }

    /**
     * Deletes a dir
     *
     * @access       public
     */
     function DeleteDir()
     {
        $this->CheckPermission('DeleteDir');
        $this->DeleteItem();
    }

    /**
     * Rename a file or directory
     *
     * @var string  $type   file or directory
     * @access      private
     */
    function Rename($type)
    {

        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('path', 'oldname', 'file'), 'post');

        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'AdminModel');
        $model->Rename($type, $post['path'] . '/' . $post['oldname'], $post['path'] . '/' . $post['file']);

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location(BASE_SCRIPT . '?gadget=FileBrowser&action=ReadDir&path=' . $post['path']);
    }

    /**
     * Renames a file
     *
     * @access       public
     */
    function RenameFile()
    {
        $this->CheckPermission('RenameFile');
        $this->Rename('file');
    }

    /**
     * Renames a directory
     *
     * @access       public
     */
    function RenameDir()
    {
        $this->CheckPermission('RenameFile');
        $this->Rename('dir');
    }
}