<?php
/**
 * Filebrowser Gadget
 *
 * @category   Gadget
 * @package    FileBrowser
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class FileBrowserHTML extends Jaws_GadgetHTML
{
    /**
     * Public constructor
     *
     * @access  public
     */
    function FileBrowserHTML()
    {
        $this->Init('FileBrowser');
    }

    /**
     * Default action to be run if none is defined.
     *
     * @access public
     * @return string HTML content of Default action
     */
    function DefaultAction()
    {
        return $this->Display();
    }

    /**
     * Prints all the files with their titles and contents
     *
     * @access  public
     * @return  string  HTML content with titles and contents
     */
    function Display()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/FileBrowser/frontend_avail') != 'true') {
            return false;
        }
        $request =& Jaws_Request::getInstance();
        if ($request->get('path', 'get')) {
            $path = $request->get('path', 'get');
        } elseif ($request->get('path', 'post')) {
            $path = $request->get('path', 'post');
        } else {
            $path = '';
        }

        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'Model');
        $locationTree = $model->GetCurrentRootDir($path);
        if (Jaws_Error::IsError($locationTree)) {
            return '';
        }

        $GLOBALS['app']->Layout->AddHeadLink('gadgets/FileBrowser/resources/style.css', 'stylesheet',
                                             'text/css', 'FileBrowser');
        $tpl = new Jaws_Template('gadgets/FileBrowser/templates/');
        $tpl->Load('FileBrowser.html');
        $tpl->SetBlock('filebrowser');
        $tpl->SetVariable('title', _t('FILEBROWSER_NAME'));
        $tpl->SetVariable('base_script', BASE_SCRIPT);
        $this->SetTitle(_t('FILEBROWSER_NAME'));
        $combolocation =& Piwi::CreateWidget('Combo', 'path');
        foreach ($locationTree as $_path => $dir) {
            if (!empty($dir)) {
                if ($_path{0} == '/') {
                    $_path = substr($_path, 1);
                }
                $_path .= (empty($_path) ? '' : '/');
                $combolocation->AddOption($dir, $this->GetURLFor('Display', array('path' => $_path), false));
            }
        }
        $combolocation->SetDefault($this->GetURLFor('Display', array('path' => $path . '/'), false));
        $combolocation->AddEvent(ON_CHANGE, 'window.location = this.value;');
        $tpl->SetVariable('location', _t('FILEBROWSER_LOCATION'));
        $tpl->SetVariable('combolocation', $combolocation->Get());
        if ($items = $model->ReadDir($path)) {
            $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            $date = $GLOBALS['app']->loadDate();
            foreach ($items as $item) {
                $tpl->SetBlock('filebrowser/item');
                $tpl->SetVariable('icon', JAWS_DPATH . $item['icon']);
                $tpl->SetVariable('name', $xss->filter($item['filename']));
                if ($item['is_dir']) {
                    $relative = $xss->filter($item['relative']) . '/';
                    $url = $this->GetURLFor('Display', array('path' => $relative), false);
                    $tpl->SetVariable('url', $url);
                } else {
                    $tpl->SetVariable('url', $xss->filter($item['url']));
                }
                $tpl->SetVariable('date', $date->Format($item['date']));
                $tpl->SetVariable('size', $item['size']);
                $tpl->ParseBlock('filebrowser/item');
            }
        }
        $tpl->ParseBlock('filebrowser');

        return $tpl->Get();
    }
}
?>
