<?php
/**
 * FileBrowser Layout HTML file (for layout purposes)
 *
 * @category   GadgetLayout
 * @package    FileBrowser
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class FileBrowserLayoutHTML
{
    /**
     * Prints all the files with their titles and contents of initial folder
     *
     * @access  public
     * @return  string  HTML content with titles and contents
     */
    function InitialFolder()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/FileBrowser/frontend_avail') != 'true') {
            return false;
        }

        $tpl = new Jaws_Template('gadgets/FileBrowser/templates/');
        $tpl->Load('FileBrowser.html');
        $tpl->SetBlock('initial_folder');
        $tpl->SetVariable('title', _t('FILEBROWSER_NAME'));

        $model = $GLOBALS['app']->LoadGadget('FileBrowser', 'Model');
        $items = $model->ReadDir('/');
        if (!Jaws_Error::IsError($items)) {
            $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            foreach ($items as $item) {
                $tpl->SetBlock('initial_folder/item');
                $tpl->SetVariable('icon', JAWS_DPATH . $item['mini_icon']);
                $tpl->SetVariable('name', $xss->filter($item['filename']));
                $tpl->SetVariable('url',  $xss->filter($item['url']));
                $tpl->SetVariable('date', $item['date']);
                $tpl->SetVariable('size', $item['size']);
                $tpl->ParseBlock('initial_folder/item');
            }
        }
        $tpl->ParseBlock('initial_folder');

        return $tpl->Get();
    }
}
?>
