<?php
/**
 * Glossary AJAX API
 *
 * @category   Ajax
 * @package    Glossary
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class GlossaryAdminAjax extends Jaws_Ajax
{
    /**
     * Constructor
     *
     * @access  public
     */
    function GlossaryAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }

    /**
     * Get a term
     *
     * @access public
     * @param  int    $id Term ID
     * @return array  Term data
     */
    function GetTerm($id)
    {
        $this->CheckSession('Glossary', 'default');
        $term = $this->_Model->GetTerm($id);
        if (Jaws_Error::IsError($term)) {
            return false;
        }

        return $term;
    }

    /**
     * Create a new term
     *
     * @access public
     * @param  string  $term     Term
     * @param  string  $contents Term description
     * @return array   Response (notice or error)
     */
    function NewTerm($term, $contents)
    {
        $this->CheckSession('Glossary', 'AddTerm');
        $id = $this->_Model->NewTerm($term, $contents);
        $response = $GLOBALS['app']->Session->PopLastResponse();
        $response['id'] = $id;
        return $response;
    }

    /**
     * Update a term
     *
     * @access public
     * @param  int    $id       Term ID
     * @param  string $term     Term
     * @param  string $contents Term description
     * @return array  Response (notice or error)
     */
    function UpdateTerm($id, $term, $contents)
    {
        $this->CheckSession('Glossary', 'UpdateTerm');
        $this->_Model->UpdateTerm($id, $term, $contents);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete a term
     *
     * @access  public
     * @param   int     $id  Term ID
     * @return  array   Response (notice or error)
     */
    function DeleteTerm($id)
    {
        $this->CheckSession('Glossary', 'DeleteTerm');
        $this->_Model->DeleteTerm($id);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Parse text
     *
     * @access  public
     * @param   string  $text    Input text (not parsed)
     * @return  string  Parsed text
     */
    function ParseText($text)
    {
        $this->CheckSession('Glossary', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Glossary', 'AdminHTML');
        return $gadget->ParseText($text, 'Glossary');
    }
}