<?php
/**
 * Glossary Gadget
 *
 * @category   Gadget
 * @package    Glossary
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class GlossaryHTML extends Jaws_GadgetHTML
{
    /**
     * Constructor
     *
     * @access  public
     */
    function GlossaryHTML()
    {
        $this->Init('Glossary');
    }

    /**
     * Runs the default action
     *
     * @access  public
     * @return  string  HTML content of Default action
     */
    function DefaultAction()
    {
        return $this->Display();
    }

    /**
     * Look for a term and prints it
     *
     * @access  public
     * @return  string HTML content
     */
    function ViewTerm()
    {
        $tpl = new Jaws_Template('gadgets/Glossary/templates/');
        $tpl->Load('ViewTerm.html');
        $tpl->SetBlock('definition');
        $tpl->SetVariable('title', _t('GLOSSARY_NAME'));
        $model = $GLOBALS['app']->LoadGadget('Glossary', 'Model');

        $request =& Jaws_Request::getInstance();
        $term = $request->get('term', 'get');

        $term = $model->GetTerm($term);
        if (!Jaws_Error::IsError($term) && isset($term['term'])) {
            $this->SetTitle($term['term']);
            $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            $date = $GLOBALS['app']->loadDate();
            $tpl->SetBlock('definition/term');
            $_term = $xss->filter($term['term']);
            $_url = $this->GetURLFor('ViewTerm', array('term' => $term['id']));
            $tpl->SetVariable('term', $_term);
            $tpl->SetVariable('url', $_url);
            $tpl->SetVariable('description', $this->ParseText($term['description'], 'Glossary'));
            $tpl->SetVariable('created_in', _t('GLOBAL_CREATETIME'));
            $tpl->SetVariable('updated_in', _t('GLOBAL_UPDATETIME'));
            $tpl->SetVariable('createtime', $date->Format($term['createtime']));
            $tpl->SetVariable('updatetime', $date->Format($term['updatetime']));
            $tpl->ParseBlock('definition/term');
        } else {
            $tpl->SetBlock('definition/notfound');
            ///FIXME doing the filter here might not be needed since Jaws_Request already does that.
            $tpl->SetVariable('term',
                              !is_null($term) ?
                              $xss->filter($term) : _t('GLOSSARY_ERROR_TERM_NO_TERM'));
            $tpl->SetVariable('notfound', _t('GLOSSARY_ERROR_TERM_DOES_NOT_EXISTS'));
            $tpl->ParseBlock('definition/notfound');
        }
        $tpl->ParseBlock ('definition');

        return $tpl->Get();
    }

    /**
     * Look for all the terms, order them and prints them all together
     *
     * @access   public
     * @return   string HTML Content
     */
    function Display()
    {
        $tpl = new Jaws_Template('gadgets/Glossary/templates/');
        $tpl->Load('AlphabeticList.html');
        $tpl->SetBlock('list');
        $tpl->SetVariable('title', _t('GLOSSARY_NAME'));
        $this->SetTitle(_t('GLOSSARY_NAME'));

        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        if (!isset($_SERVER['REQUEST_URI']) || empty($_SERVER['REQUEST_URI'])) {
            $base_url = $xss->filter($_SERVER['SCRIPT_NAME']);
        } else {
            $base_url = $xss->filter($_SERVER['REQUEST_URI']);
        }

        for ($i = 65; $i <= 90; $i++) {
            $tpl->SetBlock('list/letters');
            $tpl->SetVariable('base_url', $base_url);
            $tpl->SetVariable('letter', chr($i));
            $tpl->ParseBlock ('list/letters');
        }

        $model = $GLOBALS['app']->LoadGadget('Glossary', 'Model');
        $termssize = $model->GetSizeOfTerms();
        if (!Jaws_Error::IsError($termssize)) {
            foreach ($model->GetSizeOfTerms() as $term_letter) {
                if ($term_letter['size'] > 0) {
                    $tpl->SetBlock('list/letter');
                    $tpl->SetVariable('letter', $xss->filter($term_letter['letter']));
                    $termsof = $model->GetTermsOf($term_letter['letter']);
                    if (!Jaws_Error::IsError($termsof)) {
                        foreach ($termsof as $term) {
                            $tpl->SetBlock('list/letter/term');
                            $_term = $xss->filter($term['term']);
                            $_url = $this->GetURLFor('ViewTerm', array('term' => $term['id']));
                            $tpl->SetVariable('term', $_term);
                            $tpl->SetVariable('url', $_url);
                            $tpl->SetVariable('description', $this->ParseText($term['description'], 'Glossary'));
                            $tpl->ParseBlock('list/letter/term');
                        }
                    }
                    $tpl->ParseBlock ('list/letter');
                }
            }
        }
        $tpl->ParseBlock ('list');

        return $tpl->Get ();
    }
}
?>