<?php
/**
 * Glossary Gadget (layout actions)
 *
 * @category   Gadget
 * @package    Glossary
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class GlossaryLayoutHTML
{
    /**
     * Look for a random term and prints it
     *
     * @access  public
     * @return  string HTML content
     */
    function RandomTerms()
    {
        $tpl = new Jaws_Template('gadgets/Glossary/templates/');
        $tpl->Load('Random.html');
        $tpl->SetBlock('random');
        $model = $GLOBALS['app']->LoadGadget('Glossary', 'Model');
        $term = $model->GetRandomTerm();
        if (!Jaws_Error::IsError($term)) {
            $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            $tpl->SetVariable('title', _t('GLOSSARY_RANDOM_TERM'));
            $tpl->SetVariable('term', $xss->filter($term['term']));
            $tpl->SetVariable('description', Jaws_Gadget::ParseText($term['description'], 'Glossary'));
        }
        $tpl->ParseBlock('random');

        return $tpl->Get();
    }

    /**
     * Looks for a list of terms (general) and prints them
     *
     * @access   public
     * @return   string HTML Content
     */
    function ListOfTerms()
    {
        $tpl = new Jaws_Template('gadgets/Glossary/templates/');
        $tpl->Load('SimpleList.html');
        $tpl->SetBlock('list_of_terms');
        $tpl->SetVariable('title', _t('GLOSSARY_NAME'));
        $model = $GLOBALS['app']->LoadGadget('Glossary', 'Model');
        $terms = $model->GetTerms();
        if (!Jaws_Error::IsError ($terms)) {
            $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
            foreach ($terms as $t) {
                $tpl->SetBlock('list_of_terms/term');
                $_term = $xss->filter($t['term']);
                $_url = $GLOBALS['app']->Map->GetURLFor('Glossary', 'ViewTerm', array('term' => $t['id']));
                $tpl->SetVariable('term', $_term);
                $tpl->SetVariable('url', $_url);
                $tpl->ParseBlock('list_of_terms/term');
            }
        }
        $tpl->ParseBlock('list_of_terms');

        return $tpl->Get();
    }
}
?>
