<?php
/**
 * Glossary Gadget
 *
 * @category   GadgetModel
 * @package    Glossary
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class GlossaryModel extends Jaws_Model
{
    var $_Name = 'Glossary';

    /**
     * Get the list of term that begin with a letter
     *
     * @access  public
     * @param   string  $letter Letter to find
     * @return  array   Returns an array of the terms that begin with a letter and Jaws_Error on failure
     */
    function GetTermsOf($letter)
    {
        $sql = "
            SELECT
                [id], [user_id], [term], [description], [updatetime]
            FROM [[term]]
            WHERE
                [term] LIKE {letter_lower}
              OR
                [term] LIKE {letter_upper}";

        require_once JAWS_PATH.'include/Jaws/UTF8.php';
        $params = array();
        $params['letter_upper'] = Jaws_UTF8::strtoupper($letter).'%';
        $params['letter_lower'] = Jaws_UTF8::strtolower($letter).'%';

        $result = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Get the relation of how many terms are in each letter
     *
     * @access  public
     * @return  array   An array with the relation of how many terms have a letter
     */
    function GetSizeofTerms()
    {
        $alphabet = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
                          'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
                          'U', 'V', 'W', 'X', 'Y', 'Z');
        $relation = array();
        foreach ($alphabet as $letter) {
            $tmp = $this->GetTermsOf($letter);
            $relation[] = array('letter' => $letter,
                                'size'   => count($tmp));
        }

        return $relation;
    }

    /**
     * Get a term
     *
     * @access  public
     * @param   int     $id  Term ID
     * @return  array   Returns the properties of a term and false on error
     */
    function GetTerm($id)
    {
        $params       = array();
        $params['id'] = $id;
        $sql = "
            SELECT
                [id], [user_id], [term], [description], [createtime], [updatetime]
            FROM [[term]]
            WHERE ";
        $sql .= is_numeric($id) ? '[id] = {id}' : '[term] = {id}';


        $result = $GLOBALS['db']->queryRow($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Get a random term
     *
     * @access  public
     * @return  array   Returns the properties of a term and false on error
     */
    function GetRandomTerm()
    {
        $GLOBALS['db']->dbc->loadModule('Function', null, true);
        $rand = $GLOBALS['db']->dbc->function->random();
        $sql = '
            SELECT
                [id], [user_id], [term], [description], [updatetime]
            FROM [[term]]
            ORDER BY ' . $rand;

        $result = $GLOBALS['db']->setLimit('1');
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        $result = $GLOBALS['db']->queryRow($sql);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Get a list of all the terms
     *
     * @access  public
     * @return  array   Returns an array with all the terms
     */
    function GetTerms()
    {
        $sql = "
            SELECT
                [id], [user_id], [term], [description], [updatetime]
            FROM [[term]]
            ORDER BY [term]";

        $result = $GLOBALS['db']->queryAll($sql);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }
}