<?php
/**
 * Languages AJAX API
 *
 * @category   Ajax
 * @package    Languages
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class LanguagesAdminAjax extends Jaws_Ajax
{
    /**
     * Constructor
     *
     * @access  public
     */
    function LanguagesAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }

    /**
     * @access  public
     *
     * @param   string  $lang_str   Language code and name
     * @return  boolean Success/Failure (Jaws_Error)
     */
    function SaveLanguage($lang_str)
    {
        $this->CheckSession('Languages', 'ManageLanguages');
        $this->_Model->SaveLanguage($lang_str);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * @access  public
     *
     * @param   string  $component  Component name
     * @param   string  $langTo     Slave language code
     * @return  boolean Success/Failure (Jaws_Error)
     */
    function GetLangDataUI($component, $langTo)
    {
        $this->CheckSession('Languages', 'ManageLanguages');
        $gadget = $GLOBALS['app']->LoadGadget('Languages', 'AdminHTML');
        return $gadget->GetLangDataUI($component, $langTo);
    }

    /**
     * @access  public
     *
     * @return  boolean Success/Failure (Jaws_Error)
     */
    function SetLangData($component, $langTo, $data)
    {
        $this->CheckSession('Languages', 'ManageLanguages');
        $this->_Model->SetLangData($component, $langTo, $data);
        return $GLOBALS['app']->Session->PopLastResponse();
    }
}