<?php
/**
 * Get google page rank
 *
 * @category   Scripts
 * @package    Launcher
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2008-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class PageRank
{
    /**
     * convert a string to a 32-bit integer
     */
    function StrToNum($Str, $Check, $Magic)
    {
        $Int32Unit = 4294967296; //2^32
        $length = strlen($Str);
        for ($i = 0; $i < $length; $i++) {
            $Check *= $Magic;
            //If the float is beyond the boundaries of integer (usually +/- 2.15e+9 = 2^31),
            //  the result of converting to integer is undefined
            //  refer to http://www.php.net/manual/en/language.types.integer.php
            if ($Check >= $Int32Unit) {
                $Check = ($Check - $Int32Unit * (int) ($Check / $Int32Unit));
                //if the check less than -2^31
                $Check = ($Check < -2147483648) ? ($Check + $Int32Unit) : $Check;
            }
            $Check += ord($Str{$i});
        }
        return $Check;
    }

    /**
     * genearate a hash for a url
     */
    function HashURL($String)
    {
        $Check1 = $this->StrToNum($String, 0x1505, 0x21);
        $Check2 = $this->StrToNum($String, 0, 0x1003F);

        $Check1 >>= 2;  
        $Check1 = (($Check1 >> 4) & 0x3FFFFC0 ) | ($Check1 & 0x3F);
        $Check1 = (($Check1 >> 4) & 0x3FFC00 ) | ($Check1 & 0x3FF);
        $Check1 = (($Check1 >> 4) & 0x3C000 ) | ($Check1 & 0x3FFF);

        $T1 = (((($Check1 & 0x3C0) << 4) | ($Check1 & 0x3C)) <<2 ) | ($Check2 & 0xF0F );
        $T2 = (((($Check1 & 0xFFFFC000) << 4) | ($Check1 & 0x3C00)) << 0xA) | ($Check2 & 0xF0F0000 );

        return ($T1 | $T2);
    }

    /**
     * genearate a checksum for the hash string
     */
    function CheckHash($Hashnum)
    {
        $CheckByte = 0;
        $Flag = 0;

        $HashStr = sprintf('%u', $Hashnum);
        $length = strlen($HashStr);

        for ($i = $length - 1;  $i >= 0;  $i --) {
            $Re = $HashStr{$i};
            if (1 === ($Flag % 2)) {
                $Re += $Re;
                $Re = (int)($Re / 10) + ($Re % 10);
            }
            $CheckByte += $Re;
            $Flag ++;
        }

        $CheckByte %= 10;
        if (0 !== $CheckByte) {
            $CheckByte = 10 - $CheckByte;
            if (1 === ($Flag % 2) ) {
                if (1 === ($CheckByte % 2)) {
                    $CheckByte += 9;
                }
                $CheckByte >>= 1;
            }
        }

        return '7'.$CheckByte.$HashStr;
    }

    /**
     *
     */
    function GetRank($url)
    {
        $rank = 'na';
        $ch   = $this->CheckHash($this->HashURL($url));
        $url  = urlencode($url);
        $file = "http://www.google.com/search?client=navclient-auto&ch=$ch&features=Rank&q=info:$url";

        $rdata = @file($file);
        if (!empty($rdata)) {
            $rankarray = explode(':', $rdata[0]);
            $rank = end($rankarray);
        }

        return $rank;
    }
}

function GooglePageRank() {
    $gRank = new PageRank();
    $url = $GLOBALS['app']->GetSiteURL().'/';
    $rank = $gRank->GetRank($url);
    unset($gRank);

    $theme = $GLOBALS['app']->Registry->Get('/config/theme');
    if (!is_dir(JAWS_DATA . 'themes/'.$theme.'/PageRank')) {
        $pg_images = $GLOBALS['app']->getSiteURL() . '/gadgets/Launcher/images/PageRank/';
    } else {
        $pg_images = $GLOBALS['app']->getDataURL(true) . "themes/$theme/PageRank/";
    }

    return "<img src='{$pg_images}pr$rank.gif' alt='$rank' />";
}