<?php
/**
 * LinkDump Gadget
 *
 * @category   GadgetModel
 * @package    LinkDump
 * @author     Amir Mohammad Saied <amirsaied@gmail.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class LinkDumpModel extends Jaws_Model
{
    var $_Name = 'LinkDump';

    /**
     * Get information about a link
     *
     * @access  public
     * @param   int     $id The links id
     * @return  array   An array contains link information and Jaws_Error on error
     */
    function GetLink($id)
    {
        $params       = array();
        $params['id'] = $id;

        $sql = '
            SELECT
                [id], [gid], [title], [description], [url], [createtime], [updatetime], [clicks], [rank]
            FROM [[linkdump_links]]
            WHERE [id] = {id}';
        $row = $GLOBALS['db']->queryRow($sql, $params);
        if (Jaws_Error::IsError($row)) {
            return new Jaws_Error($row->getMessage(), 'SQL');
        }

        $sql = '
            SELECT 
                [tag] 
            FROM [[linkdump_links_tags]]
            INNER JOIN [[linkdump_tags]] ON [tag_id] = [id]
            WHERE [link_id] = {id}';
        $res = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }
        
        $cstags = '';
        foreach ($res as $tag) {
            $cstags .= ', '.$tag['tag'];
        }

        if (isset($row['id'])) {
            $row['tags'] = empty($cstags)? '' : substr($cstags, 2);
            return $row;
        }

        return new Jaws_Error(_t('LINKDUMP_LINKS_NOT_EXISTS', 'GetLink'), _t('LINKDUMP_NAME'));
    }

    /**
     * Retrieve All links tagged by a specific keyword
     *
     * @access  public
     * @param   string  $tag    The keyword (tag)
     * @return  array   An array contains links info
     */
    function GetTagLinks($tag)
    {
        $sql = 'SELECT [id] FROM [[linkdump_tags]] WHERE [tag] = {tag}';
        $res = $GLOBALS['db']->queryRow($sql, array('tag' => strtolower($tag)));
        $tag_id = $res['id'];

        $sql = '
            SELECT
                [id], [title], [description], [url], [createtime], [updatetime], [clicks]
            FROM [[linkdump_links]]
            INNER JOIN [[linkdump_links_tags]] on [link_id] = [id]
            WHERE [tag_id] = {tag_id}';
        $res  = $GLOBALS['db']->queryAll($sql, array('tag_id' => $tag_id));

        return $res;
    }

    /**
     * Inrease the link's clicks by one
     *
     * @access  public
     * @param   int $id Link's id
     * @return  boolean True on success and Jaws_Error otherwise
     */
    function Click($id)
    {
        $params       = array();
        $params['id'] = $id;

        $sql = 'UPDATE [[linkdump_links]] SET [clicks] = [clicks] + 1 WHERE [id] = {id}';
        $res  = $GLOBALS['db']->query($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return true;
    }

    /**
     * Generates a TagCloud
     *
     * @return  TagCloud data or Jaws_Error on error
     */
    function CreateTagCloud()
    {
        $sql = 'SELECT
                    COUNT([tag_id]) as howmany, [tag], [tag_id]
                FROM [[linkdump_links_tags]]
                INNER JOIN [[linkdump_tags]] ON [tag_id] = [id]
                GROUP BY [tag_id], [tag]
                ORDER BY [tag]';

        $types = array('integer', 'text', 'integer');
        $res = $GLOBALS['db']->queryAll($sql, array(), $types);
        if (Jaws_Error::isError($res)) {
            return new Jaws_Error(_t('LINKDUMP_ERROR_TAGCLOUD_CREATION_FAILED'), _t('BLOG_NAME'));
        }

        return $res;
    }

    /**
     * Returns a group information
     *
     * @access  public
     * @return  array  Array of group information and Jaws_Error on error
     */
    function GetGroup($gid)
    {
        $sql = '
            SELECT
                [id], [title], [fast_url], [limit_count], [link_type]
            FROM [[linkdump_groups]]';
        if (is_numeric($gid)) {
            $sql .= '
                WHERE [id] = {gid}';
        } else {
            $sql .= '
                WHERE [fast_url] = {gid}';
        }

        $params = array();
        $params['gid'] = $gid;

        $result = $GLOBALS['db']->queryRow($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('GLOBAL_ERROR_QUERY_FAILED'), _t('LINKDUMP_NAME'));
        }

        return $result;
    }

    /**
     * Returns a list with all the menus
     *
     * @access  public
     * @return  array  Array with all the available menus and Jaws_Error on error
     */
    function GetGroups()
    {
        $sql = '
            SELECT
                [id], [title], [fast_url], [limit_count], [link_type]
            FROM [[linkdump_groups]] ';

        $result = $GLOBALS['db']->queryAll($sql);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('GLOBAL_ERROR_QUERY_FAILED'), _t('LINKDUMP_NAME'));
        }

        return $result;
    }

    /**
     * Retrive all links
     *
     * @access  public
     * @param   mixed   $limit  Limit of data to retrieve (false by default, returns all)
     * @return  array   An array contains all links and info. and Jaws_Error on error
     */
    function GetGroupLinks($gid = null, $limit = false)
    {
        $sql = '
            SELECT
                [id], [gid], [title], [description], [url], [createtime], [updatetime], [clicks], [rank]
            FROM [[linkdump_links]] ';
        if (!empty($gid)) {
            $sql.= 'WHERE [gid] = {gid} ';
        }

        $sql.= 'ORDER BY [rank], [id] ASC';

        $params = array();
        $params['gid'] = $gid;

        if (!empty($limit)) {
            $res = $GLOBALS['db']->setLimit($limit);
            if (Jaws_Error::IsError($res)) {
                return new Jaws_Error($rs->getMessage(), 'SQL');
            }
        }

        $res = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($res)) {
            return new Jaws_Error($res->getMessage(), 'SQL');
        }

        return $res;
    }
}