<?php
/**
 * LinkDump - URL List gadget hook
 *
 * @category   GadgetHook
 * @package    LinkDump
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class LinkDumpURLListHook
{
    /**
     * Returns an array with all available items the Menu gadget 
     * can use
     *
     * @access  public
     */
    function Hook()
    {
        $urls[] = array('url'   => $GLOBALS['app']->Map->GetURLFor('LinkDump', 'DefaultAction'),
                        'title' => _t('LINKDUMP_NAME'));

        //LinkDump model
        $model  = $GLOBALS['app']->loadGadget('LinkDump', 'Model');
        $groups = $model->GetGroups();
        if (!Jaws_Error::IsError($groups)) {
            $max_size = 20;
            foreach ($groups as $group) {
                $url = $GLOBALS['app']->Map->GetURLFor('LinkDump', 'Group', array('id' => $group['id']));
                $urls[] = array('url'   => $url,
                                'title' => ($GLOBALS['app']->UTF8->strlen($group['title']) > $max_size)?
                                            $GLOBALS['app']->UTF8->substr($group['title'], 0, $max_size) . '...' :
                                            $group['title']);
            }
        }

        return $urls;
    }
}