/**
 * LinkDump Javascript actions
 *
 * @category   Ajax
 * @package    LinkDump
 * @author     Amir Mohammad Saied <amirsaied@gmail.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
/**
 * Use async mode, create Callback
 */
var LinkDumpCallback = { 
    updategroup: function(response) {
        if (response[0]['css'] == 'notice-message') {
            $('group_'+$('gid').value).getElementsByTagName('a')[1].innerHTML = $('title').value;
            stopAction();
        }
        showResponse(response);
    }
}

/**
 * Select Tree row
 *
 */
function selectTreeRow(rowElement)
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRowColor = rowElement.style.backgroundColor;
    rowElement.style.backgroundColor = '#e0e0e0';
    selectedRow = rowElement;
}

/**
 * Unselect Tree row
 *
 */
function unselectTreeRow()
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRow = null;
    selectedRowColor = null;
}

/**
 * Saves data / changes
 */
function saveLink()
{
    if (currentAction == 'Groups') {
        if (jawsTrim($('title').value) == '') {
            alert(incompleteFields);
            return false;
        }

        lc = parseInt($('limit_count').value);
        $('limit_count').value = (lc < 1)? '1' : ((lc > max_limit_count)? max_limit_count : lc);

        cacheLinkForm = null;
        if (selectedGroup == null) {
            var response = linkdumpSync.insertgroup(
                                    $('title').value,
                                    $('fast_url').value,
                                    $('limit_count').value,
                                    $('links_type').value);
            if (response[0]['css'] == 'notice-message') {
                var gid = response[0]['message'].substr(0, response[0]['message'].indexOf('%%'));
                response[0]['message'] = response[0]['message'].substr(response[0]['message'].indexOf('%%')+2);
                AddNewGroup(gid);
                stopAction();
            }
            showResponse(response);
        } else {
            linkdump.updategroup(
                                $('gid').value,
                                $('title').value,
                                $('fast_url').value,
                                $('limit_count').value,
                                $('links_type').value);
        }
    } else {
        if (jawsTrim($('title').value) == '') {
        alert(incompleteFields);
        return false;
        }
        if (selectedLink == null) {
            var response = linkdumpSync.insertlink(
                                            $('gid').value,
                                            $('title').value,
                                            $('url').value,
                                            $('description').value,
                                            $('tags').value,
                                            $('rank').value);
            if (response[0]['css'] == 'notice-message') {
                var lid = response[0]['message'].substr(0, response[0]['message'].indexOf('%%'));
                response[0]['message'] = response[0]['message'].substr(response[0]['message'].indexOf('%%')+2);
                AddNewLinkItem($('gid').value, lid, $('rank').value);
                stopAction();
            }
            showResponse(response);
        } else {
            var response = linkdumpSync.updatelink(
                                            $('lid').value,
                                            $('gid').value,
                                            $('title').value,
                                            $('url').value,
                                            $('description').value,
                                            $('tags').value,
                                            $('rank').value);
            if (response[0]['css'] == 'notice-message') {
                $('link_'+$('lid').value).getElementsByTagName('a')[0].innerHTML = $('title').value;
                new_parent = $('links_group_'+$('gid').value);
                old_parent = $('link_'+$('lid').value).parentNode;
                if (old_parent != new_parent) {
                    if (new_parent.innerHTML == noLinkExists) {
                        new_parent.innerHTML = '';
                        new_parent.appendChild($('link_'+$('lid').value));
                    } else if (jawsTrim(new_parent.innerHTML) != '') {
                        new_parent.appendChild($('link_'+$('lid').value));
                    } else {
                        Element.remove($('link_'+$('lid').value));
                    }

                    if (jawsTrim(old_parent.innerHTML) == '') {
                        old_parent.innerHTML = noLinkExists;
                    }
                }
                stopAction();
            }
            showResponse(response);
        }
    }
}

function AddNewGroup(gid) {
    var mainDiv = document.createElement('div');
    var cloneDiv =$('group_1').getElementsByTagName('div')[0].cloneNode(true);
    mainDiv.className = 'links_group';
    mainDiv.id = "group_"+gid;
    mainDiv.appendChild(cloneDiv);
    $('links_tree').appendChild(mainDiv);
    var links = mainDiv.getElementsByTagName('a');
    links[0].href      = 'javascript: listLinks('+gid+');';
    links[1].href = 'javascript: editGroup('+gid+');';
    links[1].innerHTML = $('title').value;
    links[2].href = 'javascript: addLink('+gid+');';

    var linksDiv = document.createElement('div');
    linksDiv.className = 'links';
    linksDiv.id = "links_group_"+gid;
    mainDiv.appendChild(linksDiv);
}

function AddNewLinkItem(gid, lid, rank)
{
    gLinksDiv = $('links_group_'+gid);
    var mainDiv = document.createElement('div');
    mainDiv.id = "link_"+lid;
    if (gLinksDiv.innerHTML == noLinkExists) {
        gLinksDiv.innerHTML = '';
    }
    gLinksDiv.appendChild(mainDiv);

    var img = document.createElement('img');
    img.className = 'icon';
    img.src = linkImageSrc;
    mainDiv.appendChild(img);

    var anchor = document.createElement('a');
    anchor.onclick = function() {
                        editLink(this, lid);
                     }
    anchor.innerHTML = $('title').value;
    mainDiv.appendChild(anchor);
}

function listLinks(gid)
{
    gNode = $('group_'+gid);
    gFlagimage = gNode.getElementsByTagName('img')[0];
    divSubList = $('links_group_'+gid);
    if (divSubList.innerHTML == '') {
        var links_list = linkdumpSync.getlinkslist(gid);
        if (jawsTrim(links_list) != '') {
            divSubList.innerHTML = links_list;
        } else {
            divSubList.innerHTML = noLinkExists;
        }
        gFlagimage.src = linksListCloseImageSrc;
    } else {
        divSubList.innerHTML = '';
        gFlagimage.src = linksListOpenImageSrc;
    }
    stopAction();
}

/**
 * Stops doing a certain action
 */
function stopAction()
{
    $('btn_cancel').style.display = 'none';
    $('btn_del').style.display    = 'none';
    $('btn_save').style.display   = 'none';
    $('btn_add').style.display    = 'inline';
    selectedLink  = null;
    selectedGroup = null;
    currentAction = null;
    unselectTreeRow();
    $('links_edit').innerHTML = '';
    $('edit_area').getElementsByTagName('span')[0].innerHTML = '';
}

/**
 * Add group
 */
function addGroup()
{
    if (cacheGroupForm == null) {
        cacheGroupForm = linkdumpSync.getgroupui();
    }
    currentAction = 'Groups';

    $('edit_area').getElementsByTagName('span')[0].innerHTML = addGroupTitle;
    selectedGroup = null;
    $('btn_cancel').style.display = 'inline';
    $('btn_del').style.display    = 'none';
    $('btn_save').style.display   = 'inline';
    $('btn_add').style.display    = 'none';
    $('links_edit').innerHTML = cacheGroupForm;
}

/**
 * Add link
 */
function addLink(gid)
{
    if ($('links_group_'+gid).innerHTML == '') {
        listLinks(gid);
    }
    if (cacheLinkForm == null) {
        cacheLinkForm = linkdumpSync.getlinkui();
    }

    currentAction = 'Links';

    $('edit_area').getElementsByTagName('span')[0].innerHTML =
        addLinkTitle + ' - ' + $('group_'+gid).getElementsByTagName('a')[1].innerHTML;

    selectedLink = null;
    $('btn_cancel').style.display = 'inline';
    $('btn_del').style.display    = 'none';
    $('btn_save').style.display   = 'inline';
    $('btn_add').style.display    = 'none';
    $('links_edit').innerHTML = cacheLinkForm;

    $('gid').value = gid;
}

/**
 * Edit group
 */
function editGroup(gid)
{
    if (gid == 0) return;
    unselectTreeRow();
    if (cacheGroupForm == null) {
        cacheGroupForm = linkdumpSync.getgroupui();
    }
    currentAction = 'Groups';
    selectedGroup = gid;

    $('edit_area').getElementsByTagName('span')[0].innerHTML =
        editGroupTitle + ' - ' + $('group_'+gid).getElementsByTagName('a')[1].innerHTML;
    $('btn_cancel').style.display = 'inline';
    $('btn_del').style.display    = 'inline';
    $('btn_save').style.display   = 'inline';
    $('btn_add').style.display    = 'none';
    $('links_edit').innerHTML   = cacheGroupForm;  

    var groupInfo = linkdumpSync.getgroups(selectedGroup);

    $('gid').value         = groupInfo['id'];
    $('title').value       = groupInfo['title'];
    $('fast_url').value    = groupInfo['fast_url'];
    $('limit_count').value = groupInfo['limit_count'];
    $('links_type').value  = groupInfo['link_type'];
}

/**
 * Edit menu
 */
function editLink(element, lid)
{
    if (lid == 0) return;
    selectTreeRow(element.parentNode);
    if (cacheLinkForm == null) {
        cacheLinkForm = linkdumpSync.getlinkui();
    }
    currentAction = 'Links';
    selectedLink = lid;

    $('edit_area').getElementsByTagName('span')[0].innerHTML =
        editLinkTitle + ' - ' + $('link_'+lid).getElementsByTagName('a')[0].innerHTML;
    $('btn_cancel').style.display = 'inline';
    $('btn_del').style.display    = 'inline';
    $('btn_save').style.display   = 'inline';
    $('btn_add').style.display    = 'none';
    $('links_edit').innerHTML = cacheLinkForm;  

    var linkInfo = linkdumpSync.getlink(selectedLink);

    $('lid').value         = linkInfo['id'];
    $('gid').value         = linkInfo['gid'];
    $('title').value       = linkInfo['title'];
    $('url').value         = linkInfo['url'];
    $('description').value = linkInfo['description'];
    $('tags').value        = linkInfo['tags'];
}

/**
 * Delete group/link
 */
function delLinks()
{
    if (currentAction == 'Groups') {
        var gid = selectedGroup;
        var msg = confirmGroupDelete;
        msg = msg.substr(0,  msg.indexOf('%s%')) + $('group_'+gid).getElementsByTagName('a')[1].innerHTML + msg.substr(msg.indexOf('%s%')+3);
        if (confirm(msg)) {
            cacheMenuForm = null;
            var response = linkdumpSync.deletegroup(gid);
            if (response[0]['css'] == 'notice-message') {
                Element.remove($('group_'+gid));
            }
            stopAction();
            showResponse(response);
        }
    } else {
        var lid = selectedLink;
        var msg = confirmLinkDelete;
        msg = msg.substr(0,  msg.indexOf('%s%'))+
              $('link_'+lid).getElementsByTagName('a')[0].innerHTML+
              msg.substr(msg.indexOf('%s%')+3);
        if (confirm(msg)) {
            var response = linkdumpSync.deletelink(lid, $('gid').value);
            if (response[0]['css'] == 'notice-message') {
                link_parent = $('link_'+lid).parentNode;
                Element.remove($('link_'+lid));
                if (jawsTrim(link_parent.innerHTML) == '') {
                    link_parent.innerHTML = noLinkExists;
                }
            }
            stopAction();
            showResponse(response);
        }
    }
}

function upCount()
{
    var lc = parseInt($('limit_count').value);
    lc = isNaN(lc)? 0 : lc;
    lc++;
    lc = (lc < 1)? 1 : ((lc > max_limit_count)? max_limit_count : lc);
    $('limit_count').value = lc;
}

function downCount()
{
    var lc = parseInt($('limit_count').value);
    lc = isNaN(lc)? 0 : lc;
    lc--;
    lc = (lc < 1)? 1 : ((lc > max_limit_count)? max_limit_count : lc);
    $('limit_count').value = lc;
}

var linkdump = new linkdumpadminajax(LinkDumpCallback);
linkdump.serverErrorFunc = Jaws_Ajax_ServerError;
linkdump.onInit = showWorkingNotification;
linkdump.onComplete = hideWorkingNotification;

var linkdumpSync  = new linkdumpadminajax();
linkdumpSync.serverErrorFunc = Jaws_Ajax_ServerError;
linkdumpSync.onInit = showWorkingNotification;
linkdumpSync.onComplete = hideWorkingNotification;

//Current group
var selectedGroup = null;

//Current Link
var selectedLink = null;

//Cache for saving the group form template
var cacheGroupForm = null;

//Cache for saving the menu form template
var cacheLinkForm = null;

//Which row selected in Tree
var selectedRow = null;
var selectedRowColor = null;
