<?php
/**
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class AddressProtector
{
    function Get($email, $name)
    {
        $ap_dir = JAWS_DATA . 'cache' . DIRECTORY_SEPARATOR . 'addressprotector';
        if (file_exists($ap_dir. DIRECTORY_SEPARATOR . md5($email . $name))) {
            $contents = file_get_contents($ap_dir. DIRECTORY_SEPARATOR. md5($email . $name));
            $contents = '<a href="http://address-protector.com/' . $contents . '">' . $name . '</a>';
            return $contents;
        }

        Jaws_Utils::mkdir($ap_dir);
        if (!is_dir($ap_dir) || !Jaws_Utils::is_writable($ap_dir) || !(bool)ini_get('allow_url_fopen')) {
            $contents = str_replace(array('@', '.'), array('(at)', 'dot'), $email);
            return $contents;
        }

        $addressprotector_url = "http://address-protector.com/?mode=textencrypt&name=<name>&email=<email>";
        $nameUrl  = str_replace('<name>', urlencode($name), $addressprotector_url);
        $emailUrl = str_replace('<email>', $email, $nameUrl);
        $handle = @fopen($emailUrl, 'rb');
        if (is_resource($handle)) {
            $contents = '';
            while (!feof($handle)) {
                $contents .= fread($handle, 8192);
            }
            fclose($handle);           
        } else {
            $contents = str_replace(array('@', '.'), array('(at)', 'dot'), $email);
        }
        if (substr($contents, -1, 1) == "\n") {
            $contents = substr($contents, 0, -1);
        }             
        file_put_contents($ap_dir. DIRECTORY_SEPARATOR. md5($email . $name), $contents);
        $contents = '<a href="http://address-protector.com/' . $contents . '">' . $name . '</a>';
        return $contents;
    }
}