<?php
/**
 * Poll Gadget
 *
 * @category   GadgetModel
 * @package    Poll
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class PollModel extends Jaws_Model
{
    var $_Name = 'Poll';


    /**
     * Add a new vote to the poll
     *
     * @access  public
     * @param   int     $pid Poll's ID
     * @return  boolean True if the poll was incremented and false on error
     */
    function AddPollVote($pid)
    {
        $sql = '
            UPDATE [[poll]] SET
                [votes] = [votes] + 1
            WHERE [id] = {pid}';

        $result = $GLOBALS['db']->query($sql, array('pid' => $pid));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('POLL_ERROR_VOTE_NOT_ADDED'), _t('POLL_NAME'));
        }

        return true;
    }

    /**
     * Add a new vote to the poll's answer
     *
     * @access  public
     * @param   int     $pid Poll's ID
     * @param   int     $aid Answer's ID
     * @return  boolean True if the poll answer was incremented and false on error
     */
    function AddAnswerVote($pid, $aid)
    {
        $sql = '
            UPDATE [[poll_answers]] SET
                [votes] = [votes] + 1
            WHERE [id] = {aid} AND [pid] = {pid}';

        $params        = array();
        $params['pid'] = $pid;
        $params['aid'] = $aid;

        $result = $GLOBALS['db']->query($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('POLL_ERROR_VOTE_NOT_ADDED'), _t('POLL_NAME'));
        }

        return true;
    }

    /**
     * Get Poll Answers
     *
     * @access  public
     * @param   int     $pid  Poll's ID
     * @return  array   An array with the information of the answer and false on error
     */
    function GetPollAnswers($pid)
    {
        $sql = "
            SELECT [id], [answer], [votes]
            FROM [[poll_answers]]
            WHERE [pid] = {pid}
            ORDER BY [rank] ASC";
        $result = $GLOBALS['db']->queryAll($sql, array('pid' => $pid));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Get Poll data
     *
     * @access  public
     * @return  array   An array of poll properties and Jaws_Error on error
     */
    function GetPoll($pid)
    {
        $sql = '
            SELECT  [id], [gid], [question], [select_type], [poll_type], [result_view],
                    [start_time], [stop_time], [votes], [visible]
            FROM [[poll]]
            WHERE [id] = {pid}';

        $result = $GLOBALS['db']->queryRow($sql, array('pid' => $pid));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Gets the last visible poll
     *
     * @access  public
     * @return  array   An array with the last visible and returns false on error
     */
    function GetLastPoll()
    {
        $sql = '
            SELECT MAX([id])
            FROM [[poll]]
            WHERE ([visible] = {visible}) AND
                  (([start_time] IS NULL) OR ({now} >= [start_time])) AND
                  (([stop_time] IS NULL) OR ({now} <= [stop_time]))';
        MDB2::loadFile('Date');
        $params            = array();
        $params['now']     = MDB2_Date::mdbNow();
        $params['visible'] = 1;
        $max = $GLOBALS['db']->queryOne($sql, $params);
        if (Jaws_Error::IsError($max)) {
            return new Jaws_Error($max->getMessage(), 'SQL');
        }

        if ($max > 0) {
            return $this->GetPoll($max);
        }

        return false;
    }

    /**
     * Get the list of polls
     *
     * @access  public
     * @return  array   An array of available polls and Jaws_Error on error
     */
    function GetPolls($pid = -1, $gid = -1, $onlyVisible = false, $limit = 0, $offset = null, $columns = null)
    {
        if (empty($columns)) {
            $columns = '[id], [gid], [question], [select_type], [poll_type], [result_view],
                        [start_time], [stop_time], [votes], [visible]';
        }

        if (($pid != -1) && ($gid != -1)) {
            $sql = '
                SELECT {columns}
                FROM [[poll]]
                WHERE [[poll]].[id] = {pid} AND [[poll]].[gid] = {gid}'.
                ($onlyVisible?' AND [visible] = 1 ':' ').'ORDER BY [[poll]].[id] ASC';
        } elseif ($gid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[poll]]
                WHERE [[poll]].[gid] = {gid}'.($onlyVisible?' AND [visible] = 1 ':' ').'ORDER BY [[poll]].[id] ASC';
        } elseif ($pid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[poll]]
                WHERE [id] = {pid}'.($onlyVisible?' AND [visible] = 1 ':' ').'ORDER BY [id] ASC';
        } else {
            $sql = '
                SELECT {columns}
                FROM [[poll]]'.($onlyVisible?' WHERE [visible] = 1 ':' ').'ORDER BY [id] ASC';
        }

        $params            = array();
        $params['pid']     = $pid;
        $params['gid']     = $gid;
        $params['columns'] = $columns;

        if (!empty($limit)) {
            $res = $GLOBALS['db']->setLimit($limit, $offset);
            if (Jaws_Error::IsError($res)) {
                return new Jaws_Error($res->getMessage(), 'SQL');
            }
        }

        $sql = str_replace("{columns}", $columns, $sql);
        $result = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }

    /**
     * Retrieve poll groups
     *
     * @access  public
     * @return  array  An array of available poll groups and Jaws_Error on error
     */
    function GetPollGroups($gid = -1, $limit = 0, $offset = null, $columns = null)
    {
        if (empty($columns)) {
            $columns = '[id], [title], [visible]';
        }

        if ($gid != -1) {
            $sql = '
                SELECT {columns}
                FROM [[poll_groups]]
                WHERE [id] = {gid}
                ORDER BY [id] ASC';
        } else {
            $sql = '
                SELECT {columns}
                FROM [[poll_groups]]
                ORDER BY [id] ASC';
        }

        $params            = array();
        $params['gid']     = $gid;
        $params['columns'] = $columns;

        if (!empty($limit)) {
            $res = $GLOBALS['db']->setLimit($limit, $offset);
            if (Jaws_Error::IsError($res)) {
                return new Jaws_Error($res->getMessage(), 'SQL');
            }
        }

        $sql = str_replace("{columns}", $columns, $sql);
        $result = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }    

    /**
     * Get the list of visible polls
     *
     * @access  public
     * @return  array   An array with the visible polls and returns false on error
     */
    function GetEnabledPolls()
    {
        $params           = array();
        $params['visible'] = 1;
        $sql = "
            SELECT
                [id], [question], [visible], [create_time]
            FROM [[poll]]
            WHERE [visible] = {visible}
            ORDER BY [create_time] DESC";

        $result = $GLOBALS['db']->queryAll($sql, $params);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error($result->getMessage(), 'SQL');
        }

        return $result;
    }
}