<?php
/**
 * Quotes AJAX API
 *
 * @category   Ajax
 * @package    Quotes
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class QuotesAdminAjax extends Jaws_Ajax
{
    /**
     * Constructor
     *
     * @access  public
     */
    function QuotesAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }

    /**
     * Get information of a quote(s)
     *
     * @access  public
     * @param   integer $qid
     * @param   integer  $gid
     * @return  array   Quote(s) information
     */
    function GetQuotes($qid, $gid = -1)
    {
        $this->CheckSession('Quotes', 'default');
        $quoteInfo = $this->_Model->GetQuotes($qid, $gid);
        if (Jaws_Error::IsError($quoteInfo) || !isset($quoteInfo[0])) {
            return false; //we need to handle errors on ajax
        }

        return ($qid == -1)? $quoteInfo : $quoteInfo[0];
    }

    /**
     * Insert the information of a Quote
     *
     * @access  public
     * @return  boolean True on success and Jaws_Error on failure
     */
    function InsertQuote($title, $quotation, $gid, $start_time, $stop_time, $show_title, $published)
    {
        $this->CheckSession('Quotes', 'ManageQuotes');
        $this->_Model->InsertQuote($title, $quotation, $gid, $start_time, $stop_time, $show_title, $published);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update the information of a Quote
     *
     * @access  public
     * @return  boolean True on success and Jaws_Error on failure
     */
    function UpdateQuote($id, $title, $quotation, $gid, $start_time, $stop_time, $show_title, $published)
    {
        $this->CheckSession('Quotes', 'ManageQuotes');
        $this->_Model->UpdateQuote($id, $title, $quotation, $gid, $start_time, $stop_time, $show_title, $published);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete a Quote
     *
     * @access  public
     * @param   int    $id Quote ID
     * @return  array  Response (notice or error)
     */
    function DeleteQuote($id)
    {
        $this->CheckSession('Quotes', 'ManageQuotes');
        $this->_Model->DeleteQuote($id);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Get information of a quote group
     *
     * @access  public
     * @param   int     $gid    Group ID
     * @return  array   Group information
     */
    function GetGroup($gid)
    {
        $this->CheckSession('Quotes', 'default');
        $group = $this->_Model->GetGroup($gid);
        if (Jaws_Error::IsError($group)) {
            return false; //we need to handle errors on ajax
        }

        return $group;
    }

    /**
     * Insert groups
     *
     * @access  public
     * @return  boolean True on success and Jaws_Error on failure
     */
    function InsertGroup($title, $view_mode, $view_type, $show_title, $limit_count, $randomly, $published)
    {
        $this->CheckSession('Quotes', 'ManageQuoteGroups');
        $this->_Model->InsertGroup($title, $view_mode, $view_type, $show_title, $limit_count, $randomly, $published);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Update groups
     *
     * @access  public
     * @return  boolean True on success and Jaws_Error on failure
     */
    function UpdateGroup($gid, $title, $view_mode, $view_type, $show_title, $limit_count, $randomly, $published)
    {
        $this->CheckSession('Quotes', 'ManageQuoteGroups');
        $this->_Model->UpdateGroup($gid, $title, $view_mode, $view_type, $show_title, $limit_count, $randomly, $published);

        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Get the quotes-group form
     *
     * @access  public
     * @return  string
     */
    function GroupQuotesUI()
    {
        $this->CheckSession('Quotes', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('Quotes', 'AdminHTML');
        return $gadget->GroupQuotesUI();
    }

    /**
     * Add a group of quote (by they ids) to a certain group
     *
     * @access  public
     * @param   int     $gid  Group's ID
     * @param   array   $quotes Array with quote id
     * @return  array   Response (notice or error)
     */
    function AddQuotesToGroup($gid, $quotes)
    {
        $this->CheckSession('Quotes', 'ManageQuoteGroups');
        $res = $this->_Model->AddQuotesToGroup($gid, $quotes);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Delete an group
     *
     * @access  public
     * @param   int     $gid   group ID
     * @return  array   Response (notice or error)
     */
    function DeleteGroup($gid)
    {
        $this->CheckSession('Quotes', 'ManageQuoteGroups');
        $this->_Model->DeleteGroup($gid);

        return $GLOBALS['app']->Session->PopLastResponse();
    }
}