<?php
/**
 * ServerTime Gadget
 *
 * @category   Gadget
 * @package    ServerTime
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ServerTimeAdminHTML extends Jaws_GadgetHTML
{
    /**
     * Constructor
     *
     * @access  public
     */
    function ServerTimeAdminHTML()
    {
        $this->Init('ServerTime');
    }

    /**
     * Displays the administration page.
     *
     * @access public
     * @return string HTML content
     */
    function Admin()
    {
        $this->CheckPermission('default');
        $this->AjaxMe('script.js');

        $model = $GLOBALS['app']->LoadGadget('ServerTime', 'AdminModel');

        $tpl = new Jaws_Template('gadgets/ServerTime/templates/');
        $tpl->Load('AdminServerTime.html');
        $tpl->SetBlock('servertime');

        //Ok, the config..
        if ($this->GetPermission('UpdateProperties')) {
            $form =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'post');
            $form->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'ServerTime'));
            $form->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'UpdateProperties'));

            include_once JAWS_PATH . 'include/Jaws/Widgets/FieldSet.php';
            $fieldset = new Jaws_Widgets_FieldSet(_t('SERVERTIME_NAME'));
            $fieldset->SetDirection('vertical');
            $fieldset->SetStyle('white-space: nowrap;');

            $format_str =& Piwi::CreateWidget('Entry', 'format_str');
            $format_str->SetTitle(_t('SERVERTIME_FORMAT_TEXT'));
            $format_str->SetStyle('width: 300px;');
            $format_reg = $GLOBALS['app']->Registry->get('/gadgets/ServerTime/display_format');
            $format_str->SetValue($format_reg);
            $fieldset->Add($format_str);

            $form->Add($fieldset);
            $submit =& Piwi::CreateWidget('Button', 'save', _t('GLOBAL_UPDATE', _t('GLOBAL_SETTINGS')), STOCK_SAVE);
            $submit->SetStyle(_t('GLOBAL_LANG_DIRECTION')=='rtl'?'float: left;' : 'float: right;');
            $submit->AddEvent(ON_CLICK, 'javascript: updateProperties(this.form);');
            $form->Add($submit, _t('SERVERTIME_EXAMPLE_TEXT'));

            $tpl->SetVariable('form', $form->Get());
        }

        //Stats..
        $tpl->SetVariable('example',_t('SERVERTIME_EXAMPLE_TEXT'));
        $tpl->ParseBlock('servertime');

        return $tpl->Get();
    }
}
