<?php
/**
 * ServerTime Gadget
 *
 * @category   GadgetModel
 * @package    ServerTime
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class ServerTimeModel extends Jaws_Model
{
    /**
     * Initializes the model
     *
     * @access  public
     */
    function ServerTimeModel()
    {
        $this->_Name = 'ServerTime';
    }

    /**
     * Return the data and time in a nice format
     *
     * @access  public
     * @param   string  $format
     * @return  string  formated Date and Time of server
     */
    function GetDateTime($format = '')
    {
        if (empty($format)) {
            $format = $GLOBALS['app']->Registry->get('/gadgets/ServerTime/display_format');
        }
        $format = $this->ParseText($format);
        
        return $format;
    }

    /**
     * The ParseText function
     *
     * @access  private
     * @param   string  $format
     * @return  string  Converted $format
     */
    function ParseText($format) 
    {
        $howMany = preg_match_all('#\[t\](.*?)\[/t\]#si', $format, $matches);
        $date = $GLOBALS['app']->loadDate();
        
        for ($i = 0; $i < $howMany; $i++) {
            $match_text = $matches[1][$i];
            $new_text = $date->Format(time(), $match_text);
            $pattern = '#\[t\]'.$match_text.'\[/t\]#si';
            $format = preg_replace($pattern, $new_text, $format);
        }

        return $format;
    }
}
?>
