<?php
/**
 * SimpleSite Layout HTML file (for layout purposes)
 *
 * @category   GadgetLayout
 * @package    SimpleSite
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class SimpleSiteLayoutHTML
{
    /**
     * Constructor
     */
    function SimpleSiteLayoutHTML()
    {
        // Nothing here
    }
    
    /**
     * Show the Menu
     *
     * @param   boolean $showTop Show top elements if true otherwise not.
     * @access  public
     * @return  string Menu in HTML 
     */
    function Show($showTop = true, $twoLevels = false)
    {
        $model = $GLOBALS['app']->LoadGadget('SimpleSite', 'Model');
        if ($GLOBALS['app']->Layout->GetRequestedGadget() == 'SimpleSite') {
            $request =& Jaws_Request::getInstance();
            $aux = $model->GetItems($request->get('path', 'get'), $twoLevels);
            $items = array();
            if (!$showTop) {
                foreach ($aux as $item) {
                    $items = array_merge($items, $item['childs']);            
                }
            } else {
                $items = $aux;
            }
        } else {
            if ($showTop) {
                $items = $model->GetItems('__TOP__', $twoLevels);
            } else {
                $items = array();
            }
        }
        $tpl = new Jaws_Template('gadgets/SimpleSite/templates/');
        $tpl->Load('Show.html');
        $tpl->SetBlock('branch');
        $tplString = $tpl->GetCurrentBlockContent();
        $tpl->SetBlock('branch/menu');
        $tplString = str_replace(
                        '##menu##',
                        '<!-- BEGIN menu -->'.$tpl->GetCurrentBlockContent().'<!-- END menu -->',
                        $tplString);
        $tplString = '<!-- BEGIN branch -->' . $tplString . '<!-- END branch -->';

        $tpl->SetBlock('simplesite_show');
        $tpl->SetVariable('title', '');
        $tpl->SetVariable('menus_tree', $this->DisplayMenu($items, $tplString));
        $tpl->ParseBlock('simplesite_show');

        return $tpl->get();
    }

    /** 
     * Show the Menu without the top elements
     * 
     * @access public
     * @return string Menu in HTML
     */
    function ShowWithoutTop() 
    {
        return $this->Show(false);
    }

    /**
     * Show the menu with the first two levels opened
     *
     * @access public
     * @return string Menu in HTML
     */
    function ShowTwoLevels()
    {
        return $this->Show(true, true);
    }

    /**
     * Internal recursive function to build the menu
     * 
     * @access private
     * @return string Menu in HTML
     */
    function DisplayMenu(&$items, &$tplString, $level = 1) {
        $tpl = new Jaws_Template();
        $tpl->LoadFromString($tplString);
        $request =& Jaws_Request::getInstance();
        $tpl->SetBlock('branch');
        foreach ($items as $item) {
            $tpl->SetBlock('branch/menu');
            $tpl->SetVariable('level', $level);
            $tpl->SetVariable('url', $item['url']);
            $tpl->SetVariable('title', $item['title']);
            $active = '';
            if (($GLOBALS['app']->Layout->GetRequestedGadget() == 'SimpleSite') && 
                ($request->get('path', 'get') == $item['path'])) {
                    $active = 'active';
            }
            $tpl->SetVariable('active', $active);
            if (count($item['childs']) > 0) {
                $tpl->SetVariable('submenu', $this->DisplayMenu($item['childs'], $tplString, $level + 1));
            } else {
                $tpl->SetVariable('submenu', '');
            }
            $tpl->ParseBlock('branch/menu');
        }
        $tpl->ParseBlock('branch');

        return $tpl->Get();
    }

    /** 
     * Show the top menu
     *
     * @access public
     * @return string HTML top menu
     */
    function TopMenu()
    {
        $tpl = new Jaws_Template('gadgets/SimpleSite/templates/');
        $tpl->Load('TopMenu.html');
        $tpl->SetBlock('topmenu');
        $model = $GLOBALS['app']->LoadGadget('SimpleSite', 'Model');

        if ($GLOBALS['app']->Layout->GetRequestedGadget() == 'SimpleSite') {
            $request =& Jaws_Request::getInstance();
            $items = $model->GetItems($request->get('path', 'get'));
        } else {
            $items = $model->GetItems('__TOP__');
        }
        foreach ($items as $item) {
            $tpl->SetBlock('topmenu/item');
            $tpl->SetVariable('url',$item['url']);
            $tpl->SetVariable('title',$item['title']);
            $tpl->ParseBlock('topmenu/item');
        }
        $tpl->ParseBlock('topmenu');
        return $tpl->Get();
    }
     
}
?>
