<?php
/**
 * SimpleSite Gadget
 *
 * @category   GadgetModel
 * @package    SimpleSite
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class SimpleSiteModel extends Jaws_Model
{
    var $_Name = 'SimpleSite';

    var $_items;

    /**
     * Return an item
     *
     * @access  public
     * @param   int     $id The ID of the simplesite to return.
     * @return  array   Array that has the properties of a specific simplesite
     */
    function GetItem($id)
    {
        $sql = '
            SELECT [id], [parent_id], [title], [shortname], [rfc_type], [reference], [priority],
                   [changefreq], [rank], [path], [createtime], [updatetime]
            FROM [[simplesite]] 
            WHERE [id] = {id}';

        $result = $GLOBALS['db']->queryRow($sql, array('id' => $id));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ITEM'), _t('SIMPLESITE_NAME'));
        }

        return $result;
    }

    /**
     * Get a list (array ) of the simplesite with the items of each one
     *
     * @param   string  $path   Path of the elements to get (optional)
     * @param   boolean $twoLevels If set to true it returns at least a 2 level depth menu (optional)
     * @access  public
     * @return  array   Array that contains all the simplesites with their items
     */
    function GetItems($path = null, $twoLevels = false)
    {
        if (!empty($this->_items)) {
            return $this->_items;
        }

        $parentID = array();

        if ($path == "__TOP__") {
            $parentID[] = 0;
            if ($twoLevels) {
                $sql = "
                    SELECT
                        [id], [path], [parent_id]
                    FROM [[simplesite]] 
                    WHERE [parent_id] = 0";
                $result = $GLOBALS['db']->queryAll($sql);
                if (Jaws_Error::IsError($result)) {
                    return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ALL_ITEMS'), _t('SIMPLESITE_NAME'));
                }
                foreach ($result as $row) {
                    $parentID[] = $row['id'];
                }
            }
        } elseif (!empty($path)) {
            // TODO: Sanitize path for queries
            $path = $path;
            $parentID[] = 0;
            $sql = "SELECT [id], [path], [parent_id]
                    FROM [[simplesite]] 
                    WHERE ";
            $pathitems = explode('/', $path);
            $itempath = '';
            foreach ($pathitems as $pi) {
                if ($pi != '') {
                    $sql .= "( [path] = '" . $itempath . $pi . "') OR ";
                    $itempath .= $pi . '/';
                }
            }
            $sql = substr($sql, 0, -3);
            if ($twoLevels) {
                $sql .= ' OR [parent_id] = 0';
            }

            $result = $GLOBALS['db']->queryAll($sql);
            if (Jaws_Error::IsError($result)) {
                return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ALL_ITEMS'), _t('SIMPLESITE_NAME'));
            }

            foreach ($result as $row) {
                if (($twoLevels) && ($row['parent_id'] ==  0)) {
                    $parentID[] = $row['id'];
                }
                
                if (ereg($row['path'], $path)) {
                    $parentID[] = $row['id'];
                }
            }
        }

        $sql = "
            SELECT
                [id], [parent_id], [title], [shortname], [rfc_type], [reference],
                [path], [rank], [changefreq], [priority]
            FROM [[simplesite]] ";
        if (count($parentID) > 0) {
            $sql .= " WHERE [parent_id] IN (" . implode(',', $parentID) . ")";
        }
        $sql .= " ORDER BY [parent_id], [rank] ";
        $result = $GLOBALS['db']->queryAll($sql);
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ALL_ITEMS'), _t('SIMPLESITE_NAME'));
        }

        foreach ($result as $row) {
            $aux[$row['parent_id']][] = $row;
        }

        $this->_items = array();
        $this->_items = $this->CreateItemsArray($aux, 0, '');

        return $this->_items;
    }

    /**
     * Create a hierachical array based on parents...
     * @access private
     * @params  array   $items      Array with all the items
     * @params  int     $parent     Parent id to extract
     * @return  array   Childs array
     */
    function CreateItemsArray(&$items, $parent) 
    {
        $result = array();
        if (isset($items[$parent]) && is_array($items[$parent])) {
            foreach ($items[$parent] as $index=>$item) {
                $result[$index] = $item;
                if ($item['rfc_type'] == 'url') {
                    $result[$index]['url'] = $item['reference'];
                } else {
                    $result[$index]['url'] = $GLOBALS['app']->Map->GetURLFor('SimpleSite', 'Display', array('path' => $item['path']));
                }
                $result[$index]['childs'] = $this->CreateItemsArray($items, $item['id']);
            }
        }
        return $result;
    }

    /**
     * Returns a single item by title.
     *
     * @access  public
     * @param   string  $title  Item title 
     * @return  array   Array that has the properties of a specific item
     */
    function GetSimpleSiteItemByTitle($title)
    {
        $sql = 'SELECT [id] FROM [[simplesite]] WHERE [title] = {title}';
        $result = $GLOBALS['db']->queryRow($sql, array('title' => $title));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ITEM'), _t('SIMPLESITE_NAME'));
        }

        if (!isset($result['id'])) {
            return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ITEM'), _t('SIMPLESITE_NAME'));
        }

        return $result;
    }

    /**
     * Gets the contents via path
     *
     * @access public
     * @param  string $path     Node path
     * @return string   HTML Contents.
     */
    function GetContent($path)
    {
        // Get type and reference
        $sql = "SELECT [rfc_type], [reference] FROM [[simplesite]] WHERE [path] = {path}";
        $result = $GLOBALS['db']->queryRow($sql, array('path' => $path));
        if (Jaws_Error::IsError($result)) {
            return new Jaws_Error(_t('SIMPLESITE_ERROR_GET_ITEM'), _t('SIMPLESITE_NAME'));
        }

        switch ($result['rfc_type']) {
            case 'StaticPage':
                        $staticPage = $GLOBALS['app']->loadGadget('StaticPage', 'HTML');
                        return $staticPage->Page($result['reference']);
                        break;
            case 'Launcher':
                        $launcher = $GLOBALS['app']->loadGadget('Launcher', 'LayoutHTML');
                        return $launcher->Display($result['reference']);
                        break;
            case 'Blog':
                        $blog = $GLOBALS['app']->loadGadget('Blog', 'HTML');
                        return $blog->SingleView(true, $result['reference']);
                        break;
            default:
                        require_once JAWS_PATH . 'include/Jaws/HTTPError.php';
                        return Jaws_HTTPError::Get(404);
                        
        }
    }
    
        /**
     * Create XML struct of sitemap
     *
     * @access  public
     * @param   boolean  $writeToDisk Flag that determinates if content should be written to disk
     * @return  mixed    Returns the XML(string) if it was required, or true
     */
    function makeSitemap($writeToDisk = false)
    {
        $string   = $this->getXMLString();
        $filename = 'sitemap.xml';

        if ($writeToDisk) {
            if (Jaws_Utils::is_writable(JAWS_DATA.'xml/sitemap/')) {
                ///FIXME we need to do more error checking over here
                @file_put_contents(JAWS_DATA . 'xml/sitemap/' . $filename, $string);
                //chmod!
                Jaws_Utils::chmod(JAWS_DATA . 'xml/sitemap/' . $filename);
            }
            return false;
        }
        return $string;
    }

    /**
     * Build the sitemap.xml XML structure
     *
     * @access  public
     * @return  string  XML structure of sitemap.xml
     */
    function getXMLString()
    {
        $xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        $xmlString.= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";

        $sql = '
            SELECT
                [id], [parent_id], [title], [reference], [rank], [priority],
                [changefreq], [updatetime]
            FROM [[simplesite]]
            ORDER BY [id], [priority]';

        $result = $GLOBALS['db']->queryAll($sql);
        if (!Jaws_Error::IsError($result)) {
            $date = $GLOBALS['app']->loadDate();
            foreach($result as $row) {
                if (empty($row['reference'])) {
                    continue;
                }
                $reference = $row['reference'];
                if (!preg_match('/^(http|https):\/\/[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}'
                               .'((:[0-9]{1,5})?\/.*)?$/i' ,$reference)) {
                    $reference = $GLOBALS['app']->getSiteURL() . '/' . $reference;
                }
                $lastmod   = $date->ToISO($row['updatetime']);
                $reference = htmlentities($reference, ENT_QUOTES, 'UTF-8');
                $reference = str_replace("\n", "", $reference);                
                
                $xmlString.= "<url>\n";
                $xmlString.= "   <loc>".$reference."</loc>\n";
                $xmlString.= "   <lastmod>".$lastmod."</lastmod>\n";
                
                if (!empty($row['changefreq'])) {
                    $xmlString.= "   <changefreq>".$row['changefreq']."</changefreq>\n";
                }
                
                if (is_numeric($row['priority'])) {
                    $xmlString.= "   <priority>".$row['priority']."</priority>\n";
                }
                $xmlString.= "</url>\n";
            }
        }
        $xmlString.= "</urlset>";
        return $xmlString;
    }       
    
    /**
     * Ping the sitemap.xml file to many search engines
     *
     * @access  public
     * @param   boolean  $redo  (Optional) Rewrite sitemap before sending it
     */
    function ping($redo = false)
    {
        if ($redo === true) {
            $buildSitemap = $this->makeSitemap(true);
        }
        
        $url = htmlentities($GLOBALS['app']->Map->GetURLFor('Sitemap', 'GetXML'),
                            ENT_QUOTES,
                            'UTF-8');
        $sengines = array(
                          'http://www.google.com/webmasters/sitemaps/ping?sitemap={local}' => 'get',
                          'http://submissions.ask.com/ping?sitemap={local}' => 'get'
                          );
        
        
        require_once 'HTTP/Request.php';

        $httpRequest = new HTTP_Request();
        foreach($sengines as $engine => $method) {
            $method = strtolower($method);
            if ($method == 'post') {
                $httpRequest->setMethod(HTTP_REQUEST_METHOD_POST);
            } else {
                $httpRequest->setMethod(HTTP_REQUEST_METHOD_GET);
            }
            $engine      = str_replace('local', $url, $engine);
            
            $httpRequest->setURL($engine);
            $resRequest  = $httpRequest->sendRequest();

            if (PEAR::isError($resRequest) || (int) $httpRequest->getResponseCode() <> 200) {
                if (isset($GLOBALS['log'])) {
                    $GLOBALS['log']->Log(JAWS_LOG_INFO, 'Could not ping sitemap URL to: '.$engine);
                }
            }
        }
        return true;
    }
}