<?php
/**
 * StaticPage AJAX API
 *
 * @category   Ajax
 * @package    StaticPage
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class StaticPageAdminAjax extends Jaws_Ajax
{
    // {{{ Constructor PHP4
    /**
     * PHP 4 Constructor
     *
     * @access  public
     */
    function StaticPageAdminAjax(&$model)
    {
        $this->_Model =& $model;
    }
    // }}}
    // {{{ Function DeletePage
    /**
     * Deletes a page and all translated of it.
     *
     * @access  public
     * @param   int     $id  Page ID
     * @return  array   Response (notice or error)
     */
    function DeletePage($id)
    {
        $this->CheckSession('StaticPage', 'DeletePage');
        $this->_Model->DeletePage($id);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Executes a massive-delete of pages
     *
     * @access  public
     * @param   array   $pages  Array with the ids of pages
     * @return  array   Response (notice or error)
     */
    function MassiveDelete($pages)
    {
        $this->CheckSession('StaticPage', 'DeletePage');
        $this->_Model->MassiveDelete($pages);
        return $GLOBALS['app']->Session->PopLastResponse();
    }
    
    /**
     * Update settings
     *
     * @access  public
     * @param   string  $defaultPage  Default page to use
     * @param   string  $multiLang    Use a multilanguage 'schema'?
     * @return  array   Response (notice or error)
     */
    function UpdateSettings($defaultPage, $multiLang)
    {
        $this->CheckSession('StaticPage', 'Properties');
        $this->_Model->UpdateSettings($defaultPage, $multiLang);
        return $GLOBALS['app']->Session->PopLastResponse();
    }

    /**
     * Parse text
     *
     * @access  public
     * @param   string  $text  Input text
     * @return  string  parsed Text
     */
    function ParseText($text)
    {
        $this->CheckSession('StaticPage', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('StaticPage', 'AdminHTML');
        return $gadget->ParseText($text, 'StaticPage');
    }

    /**
     * Get total pages of a search
     *
     * @access  public
     * @param   string  $status  Status of page(s) we want to display
     * @param   string  $search  Keyword (title/description) of pages we want to look for
     * @return  int     Total of posts
     */
    function SizeOfSearch($status, $search)
    {
        $this->CheckSession('StaticPage', 'default');
        $pages = $this->_Model->SearchPages($status, $search, null);
        return count($pages);
    }

    /**
     * Returns an array with all the pages
     *
     * @access  public
     * @param   string  $status  Status of page(s) we want to display
     * @param   string  $search  Keyword (title/description) of pages we want to look for
     * @param   int     $limit   Data limit
     * @return  array   Pages data
     */
    function SearchPages($status, $search, $limit)
    {
        $this->CheckSession('StaticPage', 'default');
        $gadget = $GLOBALS['app']->LoadGadget('StaticPage', 'AdminHTML');
        if (!is_numeric($limit)) {
            $limit = 0;
        }
        return $gadget->GetPages($status, $search, $limit);
    }
    
    
    /**
     * This function will perform an autodraft of the content and set
     * it's value to not published, which will later be changed when the
     * user clicks on save.
     *
     * @access public
     * @param int    $id        The id of the staticpage id to update
     * @param string $fast_url  The value of the fast_url. This will
     *                          be autocreated if nothing is passed.
     * @param bool   $showtitle This will to know if we show the title or not.
     * @param string $title     The new autosaved title
     * @param string $content   The content of the new page
     * @param string $language  The language of page
     * @param bool   $published If the item is published or not. Default: draft
     */
    function AutoDraft($id = '', $fast_url = '', $showtitle = '', $title = '', $content = '',
                       $language = '', $published = '')
    {
        $this->CheckSession('StaticPage', 'default');

        if ($id == 'NEW') {
            $this->_Model->AddPage($fast_url, $show_title, $title, $content, $language, $published, true);
            $newid    = $GLOBALS['db']->lastInsertID('static_pages', 'id');
            $response['id'] = $newid;
            $response['message'] = _t('STATICPAGE_PAGE_AUTOUPDATED',
                                      date('H:i:s'),
                                      (int)$id,
                                      date('D, d'));
            $GLOBALS['app']->Session->PushLastResponse($response, RESPONSE_NOTICE);
        } else {
            $this->_Model->UpdatePage($id, $fast_url, $showtitle, $title, $content, $language, $published, true);
        }
        return $GLOBALS['app']->Session->PopLastResponse();
    }
}
?>
