<?php
/**
 * StaticPage Gadget
 *
 * @category   Gadget
 * @package    StaticPage
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class StaticPageHTML extends Jaws_GadgetHTML
{
    /**
     * Constructor
     *
     * @access public
     */
    function StaticPageHTML()
    {
        $this->Init('StaticPage');
    }

    /**
     * Excutes the default action, currently displaying the default page.
     *
     * @access public
     * @return string
     */
    function DefaultAction()
    {
        return $this->Page($GLOBALS['app']->Registry->Get('/gadgets/StaticPage/default_page'));
    }

    /**
     * Displays an individual page.
     *
     * @var	int	$id	Page ID (optional)
     * @access public
     * @return string
     */
    function Page($page_id = null)
    {
        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('id','language'), 'get');

        $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $post['id'] = $xss->defilter($post['id']);

        $model = $GLOBALS['app']->LoadGadget('StaticPage', 'Model');
        $page_id = is_null($page_id)? $post['id'] : $page_id;
        $page_language = $post['language'];
        if (empty($page_language)) {
            // if page language not set try to load language traslation of page that same as site language
            $page_language = $GLOBALS['app']->GetLanguage();
            if (!$model->TranslationExists($page_id, $page_language)) {
                $page_language = null;
            }
        }

        if (empty($page_language)) {
            $page = $model->GetPage($page_id);
        } else {
            $page = $model->GetPage($page_id, $page_language);
        }

        if (Jaws_Error::IsError($page)) {
            require_once JAWS_PATH . 'include/Jaws/HTTPError.php';
            return Jaws_HTTPError::Get(404);
        } else {
            //add static page language to meta language tag
            $this->AddToMetaLanguages($page_language);

            $tpl = new Jaws_Template('gadgets/StaticPage/templates/');
            $tpl->Load('StaticPage.html');
            $tpl->SetBlock('page');

            if ($page['published'] === false) {
                $this->SetTitle(_t('STATICPAGE_TITLE_NOT_FOUND'));
                $tpl->SetVariable('content', _t('STATICPAGE_CONTENT_NOT_FOUND'));
                $tpl->SetBlock('page/title');
                $tpl->SetVariable('title', _t('STATICPAGE_TITLE_NOT_FOUND'));
                $tpl->ParseBlock('page/title');
            } else {
                $this->SetTitle($page['title']);
                $text = $this->ParseText($page['content'], 'StaticPage');
                $tpl->SetVariable('content', $text, false);
                if ($page['show_title'] === true) {
                    $tpl->SetBlock('page/title');
                    $tpl->SetVariable('title', $page['title']);
                    $tpl->ParseBlock('page/title');
                }

                if ($GLOBALS['app']->Registry->Get('/gadgets/StaticPage/multilanguage') == 'yes') {
                    $translations = $model->GetTranslationsOfPage($page['page_id'], true);
                    if (!Jaws_Error::isError($translations) && count($translations)>1) {
                        $tpl->SetBlock('page/translations');
                        $tpl->SetVariable('avail_trans', _t('STATICPAGE_AVAIL_TRANSLATIONS'));
                        foreach ($translations as $trans) {
                            //if ($page['language'] == $trans['language']) continue;
                            $tpl->SetBlock('page/translations/language');
                            $tpl->SetVariable('lang', $trans['language']);
                            $param = array('id' => !empty($page['fast_url']) ? $page['fast_url'] : $page['page_id'],
                                           'language' => $trans['language']);
                            $tpl->SetVariable('url', $this->GetURLFor('Page', $param));
                            $tpl->ParseBlock('page/translations/language');
                        }
                        $tpl->ParseBlock('page/translations');
                    }
                }
            }
        }
        $tpl->ParseBlock('page');

        return $tpl->Get();
    }

    /**
     * Displays an index of available static pages.
     *
     * @access public
     * @return string
     */
    function Index()
    {
        $layoutGadget = $GLOBALS['app']->LoadGadget('StaticPage', 'LayoutHTML');
        return $layoutGadget->Display();
    }
}
