<?php
/**
 * StaticPage Gadget (layout actions in client side)
 *
 * @category   GadgetLayout
 * @package    StaticPage
 * @author     Jon Wood <jon@jellybob.co.uk>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class StaticPageLayoutHTML
{
    /**
     * Displays a layout block of static pages.
     *
     * @access public
     * @return string
     */
    function Display()
    {
        $model = $GLOBALS['app']->LoadGadget('StaticPage', 'Model');
        $pages = $model->GetPages();
        if (Jaws_Error::IsError($pages)) {
            return _t('STATICPAGE_ERROR_INDEX_NOT_LOADED');
        }

        $xss  = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $tpl = new Jaws_Template('gadgets/StaticPage/templates/');
        $tpl->Load('StaticPage.html');
        $tpl->SetBlock('index');
        $tpl->SetVariable('title', _t('STATICPAGE_TITLE_PAGE_INDEX'));
        foreach ($pages as $page) {
            if ($page['published'] === true) {
                $param = array('id' => !empty($page['fast_url']) ? $xss->filter($page['fast_url']) : $page['base_id'],
                               'language' => $page['language']);
                $link = $GLOBALS['app']->Map->GetURLFor('StaticPage', 'Page', $param);
                $tpl->SetBlock('index/item');
                $tpl->SetVariable('title', $page['title']);
                $tpl->SetVariable('link',  $link);
                $tpl->ParseBlock('index/item');
            }
        }
        $tpl->ParseBlock('index');

        return $tpl->Get();
    }
}