<?php
/**
 * StaticPage - Search gadget hook
 *
 * @category   GadgetHook
 * @package    StaticPage
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class StaticPageSearchHook
{
    /**
     * Gets the gadget's search fields
     */
    function GetSearchFields() {
        return array(
                    array('[content]', '[title]'),
                    );
    }

    /**
     * Returns an array with the results of a search
     *
     * @access  public
     * @param   string  $pSql  Prepared search (WHERE) SQL
     * @return  array   An array of entries that matches a certain pattern
     */
    function Hook($pSql = '')
    {
        $params = array('published' => true);

        $sql = '
            SELECT
               sp.[page_id], sp.[fast_url], spt.[title], spt.[content], spt.[language], spt.[updated]
            FROM [[static_pages]] sp
            LEFT JOIN [[static_pages_translation]] spt ON sp.[page_id] = spt.[base_id]
            WHERE spt.[published] = {published}
            ';

        $sql .= $pSql;
        $sql .= ' ORDER BY sp.[page_id] DESC';

        $types = array('integer', 'text', 'text', 'text', 'text', 'timestamp');

        $result = $GLOBALS['db']->queryAll($sql, $params, $types);
        if (Jaws_Error::IsError($result)) {
            return array();
        }

        $date  = $GLOBALS['app']->loadDate();
        $pages = array();
        foreach ($result as $p) {
            $page = array();
            $page['title'] = $p['title'];
            if (empty($p['fast_url'])) {
                $url = $GLOBALS['app']->Map->GetURLFor('StaticPage', 'Page', array('id' => $p['page_id'],
                                                                                   'language' => $p['language']));
            } else {
                $url = $GLOBALS['app']->Map->GetURLFor('StaticPage', 'Page', array('id' => $p['fast_url'],
                                                                                   'language' => $p['language']));
            }

            $page['url']     = $url;
            $page['image']   = 'gadgets/StaticPage/images/logo.png';
            $page['snippet'] = $p['content'];
            $page['date']    = $date->ToISO($p['updated']);

            $stamp           = str_replace(array('-', ':', ' '), '', $p['updated']);
            $pages[$stamp]   = $page;
        }

        return $pages;
    }
}
