<?php
/**
 * StaticPage - URL List gadget hook
 *
 * @category   GadgetHook
 * @package    StaticPage
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class StaticPageURLListHook
{
    /**
     * Returns an array with all available items the Menu gadget 
     * can use
     *
     * @access  public
     */
    function Hook()
    {
        $urls   = array();
        $urls[] = array('url'   => $GLOBALS['app']->Map->GetURLFor('StaticPage', 'DefaultAction'),
                        'title' => _t('STATICPAGE_NAME'));
        $urls[] = array('url'   => $GLOBALS['app']->Map->GetURLFor('StaticPage', 'Index'),
                        'title' => _t('STATICPAGE_TITLE_PAGE_INDEX'));

        //Load model
        $model = $GLOBALS['app']->loadGadget('StaticPage', 'Model');
        $pages = $model->GetPages();
        if (!Jaws_Error::IsError($pages)) {
            $max_size = 20;
            foreach($pages as $p) {
                if ($p['published'] === true) {
                    $url   = $GLOBALS['app']->Map->GetURLFor('StaticPage', 'Page', array('id' => $p['base_id']));
                    $urls[] = array('url'   => $url,
                                    'title' => ($GLOBALS['app']->UTF8->strlen($p['title']) > $max_size)?
                                                $GLOBALS['app']->UTF8->substr($p['title'], 0, $max_size).'...' :
                                                $p['title']);
                }
            }
        }
        return $urls;
    }
}
