/**
 * StaticPage Javascript actions
 *
 * @category   Ajax
 * @package    StaticPage
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
/**
 * Use async mode, create Callback
 */
var StaticPageCallback = { 
    deletepage: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getData();
        }
        showResponse(response);
    }, 
    
    massivedelete: function(response) {
        if (response[0]['css'] == 'notice-message') {
            var rows = $('pages_datagrid').getSelectedRows();
            if (rows.length > 0) {
                for(var i=0; i<rows.length; i++) {
                    $('pages_datagrid').deleteItem();
                }
            }
            PiwiGrid.multiSelect($('pages_datagrid'));
            getData();
        }
        showResponse(response);      
    },
    
    updatesettings: function(response) {
        showResponse(response);
    }, 

    autodraft: function(response) {
        showSimpleResponse(response);
    }
};
// {{{ Function AutoDraft
/**
 * This function is the main idea behind the auto drafting
 * it will get the values of the fields on the form and then
 * pass them to the function AutoDraft in StaticPageAjax.php
 * and also output a nice message at the end :-)
 */
function AutoDraft()
{
    // FIXME: temporary disable auto draft
    return;
    var title     = document.forms[0].elements['title'].value;
    var fasturl   = document.forms[0].elements['fast_url'].value;
    var language  = document.forms[0].elements['language'].value;
    var published = document.forms[0].elements['published'].value;
    var showtitle = document.forms[0].elements['show_title'].value;
    var actioni   = document.forms[0].elements['action'].value;
    var id        = '';

    switch (actioni) {
        case 'AddPage':
            id = 'NEW';
            break;
        case 'SaveEditPage':
            id = document.forms[0].elements['id'].value;
            break;
    }
    var content   = getEditorValue('content');

    staticpage.autodraft(id, fasturl, showtitle, title, content, language, published);
    setTimeout('startAutoDrafting();', 120000);
}
// }}}
// {{{ Function startAutoDrafting
/**
 * Just the mother function that will make sure that auto drafting is running
 * and is being run every ~ 120 seconds (2 minutes).
 *
 * @see AutoDraft();
 */
function startAutoDrafting() 
{
    AutoDraft();
}
// }}}
/**
 * Prepare the preview
 */
function parseText(form)
{
    var title   = form.elements['title'].value;
    var content = getEditorValue('content');

    content = staticpageSync.parsetext(content);
    
    var preview = document.getElementById('preview');
    preview.style.display = 'block';

    var titlePreview   = document.getElementById('previewTitle');
    var contentPreview = document.getElementById('previewContent');

    titlePreview.innerHTML   = title;
    contentPreview.innerHTML = content;    
}

/**
 * Delete a banner : function
 */
function deletePage(id)
{
    staticpage.deletepage(id);
}

/**
 * Can use massive delete?
 */
function massiveDelete(message) 
{
    var rows = $('pages_datagrid').getSelectedRows();
    if (rows.length > 0) {
        var confirmation = confirm(message);
        if (confirmation) {
            staticpage.massivedelete(rows);
        }
    }
}

/**
 * Save settings
 */
function updateSettings()
{
    var defaultPage = $('default_page').value;
    var multiLang   = $('multilanguage').value;
    staticpage.updatesettings(defaultPage, multiLang);
}

/**
 * Search for pages and translations
 */
function searchPage()
{
    updatePagesDatagrid($('status').value, $('search').value, 0, true);
}

/**
 * Get pages data
 */
function getData(limit)
{
    if (limit == undefined) {
        limit = $('pages_datagrid').getCurrentPage();
    }
    updatePagesDatagrid($('status').value,
                        $('search').value,
                        limit,
                        false);
}

/**
 * Get previous values of pages
 */
function previousValues()
{
    var previousValues = $('pages_datagrid').getPreviousPagerValues();
    getData(previousValues);
    $('pages_datagrid').previousPage();
}

/**
 * Get next values of pages
 */
function nextValues()
{
    var nextValues = $('pages_datagrid').getNextPagerValues();
    getData(nextValues);
    $('pages_datagrid').nextPage();
}

/**
 * Update pages datagrid
 */
function updatePagesDatagrid(status, search, limit, resetCounter)
{
    $('pages_datagrid').objectName = staticpageSync;
    JawsDataGrid.name = 'pages_datagrid';

    var result = staticpageSync.searchpages(status, search, limit);
    resetGrid('pages_datagrid', result);
    if (resetCounter) {
        var size = staticpageSync.sizeofsearch(status, search);
        $('pages_datagrid').rowsSize    = size;
        //$('pages_datagrid').setCurrentPage(0);
        $('pages_datagrid').updatePageCounter();
    }
}

/**
 * Show the response but only text, nothing with datagrid.
 * FIXME!
 */
function showSimpleResponse(message)
{
    if (!autoDraftDone) {
        var actioni   = document.forms[0].elements['action'].value;
        if (actioni == 'AddPage' && message[0]['css'] == 'notice-message') {
            document.forms[0].elements['action'].value = 'SaveEditPage';
            document.forms[0].elements['id'].value     = message[0]['message']['id'];
            message[0]['message'] = message[0]['message']['message'];
        }
        autoDraftDone = true;
    }
    showResponse(message);
}

var staticpage = new staticpageadminajax(StaticPageCallback);
staticpage.serverErrorFunc = Jaws_Ajax_ServerError;
staticpage.onInit = showWorkingNotification;
staticpage.onComplete = hideWorkingNotification;

var staticpageSync = new staticpageadminajax();
staticpageSync.serverErrorFunc = Jaws_Ajax_ServerError;
staticpageSync.onInit = showWorkingNotification;
staticpageSync.onComplete = hideWorkingNotification;

var autoDraftDone = false;
