<?php
/**
 * TMS (Theme Management System) Gadget Normal view
 *
 * @category   GadgetAdmin
 * @package    TMS
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class TmsHTML extends Jaws_GadgetHTML
{
    /**
     * Gadget constructor
     *
     * @access public
     */
    function TmsHTML()
    {
        $this->Init('Tms');
    }

    /**
     * Returns the shared themes RSS if its available or 404 if it
     * user doesn't want to share his themes
     *
     * @access  public
     * @return  string   RSS content or 404 string XHTML
     */
    function RSS()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/Tms/share_mode') == 'yes') {
            $model = $GLOBALS['app']->LoadGadget('Tms', 'Model');
            $rss = $model->MakeRSS(false);
            if (!Jaws_Error::isError($rss)) {
                header('Content-type: application/xml');
                return $rss;
            }
        } else {
            require_once JAWS_PATH . 'include/Jaws/HTTPError.php';
            return Jaws_HTTPError::Get(404);
        }
    }
}