/**
 * UrlMapper Javascript actions
 *
 * @category   Ajax
 * @package    UrlMapper
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
/**
 * UrlMapper CallBack
 */
var UrlMapperCallback = {
    /**
     * Adds a new map
     */
    addmap: function(response) {
        if (response[0]['css'] == 'notice-message') {
            enableMapEditingArea(false);
            showActionMaps();
        }
        showResponse(response);
    },

    /**
     * Updates a map
     */
    updatemap: function(response) {
        if (response[0]['css'] == 'notice-message') {
            enableMapEditingArea(false);
            showActionMaps();
        }
        showResponse(response);
    },

    /**
     * Deletes a map
     */
    deletemap: function(response) {
        if (response[0]['css'] == 'notice-message') {
            enableMapEditingArea(false);
            showActionMaps();
        }
        showResponse(response);
    },

    /**
     * Update settings
     */
    updatesettings: function(response) {
        showResponse(response);
    },

    /**
     * Adds a new alias
     */
    addalias: function(response) {
        if (response[0]['css'] == 'notice-message') {
            rebuildAliasCombo();
        }
        showResponse(response);
    },

    /**
     * Updates a new alias
     */
    updatealias: function(response) {
        if (response[0]['css'] == 'notice-message') {
            rebuildAliasCombo();
        }
        showResponse(response);
    },

    /**
     * Deletes a new alias
     */
    deletealias: function(response) {
        if (response[0]['css'] == 'notice-message') {
            rebuildAliasCombo();
        }
        showResponse(response);
    }    
}

/**
 * Build the 'big' alias combo 
 */
function rebuildAliasCombo()
{
    var combo = $('alias-combo');
    while(combo.options.length != 0) {
        combo.options[0] = null;
    }
    var aliases = urlmapperSync.getaliases();
    if (aliases != false) {
        var i =0;
        aliases.each(function(value, index) {  
            var op = new Option(' + ' + value['alias_url'], value['id']);
            if (i % 2 == 0) {
                op.style.backgroundColor = evenColor;
            } else {
                op.style.backgroundColor = oddColor;
            }
            combo.options[combo.options.length] = op;
            i++;
        });
        var urlField = ($('type').value) == 'internal' ? 'internal_url' : 'custom_url';
        $('alias_id').value = '-';     
        $('alias').value    = '';
        if ($('type').value == 'custom') {
            $('custom_url').value = '';
        }
    }
}

/**
 * Edits an alias
 */
function editAlias(id)
{
    var alias = urlmapperSync.getalias(id);
    if (alias != false) {
        $('type').selectedIndex = 0;
        updateLinkType('custom');
        $('alias_id').value   = id;
        $('custom_url').value = alias['real_url'];
        $('alias').value      = alias['alias_url'];
    }        
}

/**
 * Saves an alias
 */
function saveAlias()
{
    var urlField = ($('type').value) == 'internal' ? 'internal_url' : 'custom_url';
    if ($('alias_id').value == '-') {
        urlmapperAsync.addalias($('alias').value, $(urlField).value);
    } else {
        urlmapperAsync.updatealias($('alias_id').value, $('alias').value, $(urlField).value);
    }      
}

/**
 * Deletes an alias
 */
function deleteCurrentAlias()
{
    var aliasCombo = $('alias-combo');
    if (aliasCombo.selectedIndex != -1) {
        urlmapperAsync.deletealias(aliasCombo.value);
    } 
}


/**
 * Updates the internalurl combo
 */
function updateInternalURLCombo(combo)
{
    var internalCombo = $('internal_url');
    while(internalCombo.options.length != 0) {
        internalCombo.options[0] = null;
    }
    
    if (combo.value != '-NONE-') {
        var internalLinks = urlmapperSync.getinternallinks(combo.value);
        if (internalLinks != false) {
            internalLinks.each(function(value, index) {  
                var op = new Option(value['title'], value['url']);
                internalCombo.options[internalCombo.options.length] = op;
            });
            $('internal_url').style.display = 'block';
            $('internal_url_label').style.display = 'block';
        }
    } else {
        $('internal_url').style.display = 'none';
        $('internal_url_label').style.display = 'none'; 
    }
}

/**
 * Updates the internal/custom link fields hidding/showing the right one
 */
function updateLinkType(linkType)
{
    if (linkType == 'internal') {
        $('AliasFieldset').getElementsByTagName('div')[1].style.display = 'block'; //gadgets
        $('AliasFieldset').getElementsByTagName('div')[2].style.display = 'none';  //entry
        $('AliasFieldset').getElementsByTagName('div')[3].style.display = 'block';  //combo links
    } else {
        $('AliasFieldset').getElementsByTagName('div')[1].style.display = 'none'; //gadgets
        $('AliasFieldset').getElementsByTagName('div')[2].style.display = 'block';  //entry
        $('AliasFieldset').getElementsByTagName('div')[3].style.display = 'none';  //combo links
    }
}

/**
 * Update UrlMapper settings
 */
function updateSettings(form)
{
    urlmapperAsync.updatesettings(form.elements['enabled'].value,
                                  form.elements['use_aliases'].value,
                                  form.elements['to_use'].value,
                                  form.elements['extension'].value);
}

/**
 * Add/Edit a map
 */
function saveMap()
{
    if (selectedMap) {
        urlmapperAsync.updatemap(selectedMap,
                                 $('map_route').value,
                                 $('map_regexp').value);
    } else {
        urlmapperAsync.addmap($('gadgets_combo').value,
                              $('actions_combo').value,
                              $('map_route').value,
                              $('map_regexp').value);
    }
}

/**
 * Prepares the UI to add a map
 */
function addMap(element, mid)
{
    enableMapEditingArea(true);

    selectedMap = null;
    $('legend_title').innerHTML = addMap_title;

    unselectDataGridRow();

    var mapInfo = urlmapperSync.getmap(mid);
    $('map_route').value  = mapInfo['map'];
    $('map_regexp').value = mapInfo['regexp'];
}

/**
 * Prepares the UI to edit a map
 */
function editMap(element, mid)
{
    enableMapEditingArea(true);

    selectedMap = mid;
    $('legend_title').innerHTML = editMap_title;

    selectDataGridRow(element.parentNode.parentNode);

    var mapInfo = urlmapperSync.getmap(selectedMap);
    $('map_route').value  = mapInfo['map'];
    $('map_regexp').value = mapInfo['regexp'];
}

/**
 * Deletes a map
 */
function deleteMap(element, mid)
{
    selectDataGridRow(element.parentNode.parentNode);
    if (confirm(confirmMapDelete)) {
        urlmapperAsync.deletemap(mid);
    }
    unselectDataGridRow();
}

/**
 * Prepares a datagrid with maps of each action
 */
function showActionMaps()
{
    if (jawsTrim($('gadgets_combo').value) == '' ||
        jawsTrim($('actions_combo').value) == '') return;

    resetGrid('maps_datagrid', '');
    //Get maps of this action and gadget
    var result = urlmapperSync.getmapsofaction($('gadgets_combo').value, $('actions_combo').value);
    resetGrid('maps_datagrid', result);
    enableMapEditingArea(false);
}

/**
 * Cleans the action combo and fill its again
 */
function rebuildActionCombo()
{
    $('actions_combo').options.length = 0;
    fillActionCombo();
    enableMapEditingArea(false);
    resetGrid('maps_datagrid', '');
}

/**
 * Enable/Disable Map editing area
 */
function enableMapEditingArea(status)
{
    if (status) {
        $('map_route').disabled  = false;
        $('map_regexp').disabled = false;
        $('btn_save').disabled   = false;
        $('btn_cancel').disabled = false;
    } else {
        selectedMap = null;
        unselectDataGridRow();
        $('map_route').value  = '';
        $('map_regexp').value = '';
        $('map_route').disabled  = true;
        $('map_regexp').disabled = true;
        $('btn_save').disabled   = true;
        $('btn_cancel').disabled = true;
    }
}

/**
 * Check the selected gadget and fills the actions combo
 */
function fillActionCombo()
{
    var selectedGadget = $('gadgets_combo').value;
    var actions        = urlmapperSync.getgadgetactions(selectedGadget);

    var counter = 0;
    actions.each(function(value, index) {
        var op   = new Option();
        op.value = value;
        op.text  = value;
        if (counter % 2 == 0) {
            op.style.backgroundColor = evenColor;
        } else {
            op.style.backgroundColor = oddColor;
        }
        $('actions_combo').options[$('actions_combo').options.length] = op;    
        counter++;
    });
}

/**
 * Select DataGrid row
 *
 */
function selectDataGridRow(rowElement)
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRowColor = rowElement.style.backgroundColor;
    rowElement.style.backgroundColor = '#ffffcc';
    selectedRow = rowElement;
}

/**
 * Unselect DataGrid row
 *
 */
function unselectDataGridRow()
{
    if (selectedRow) {
        selectedRow.style.backgroundColor = selectedRowColor;
    }
    selectedRow = null;
    selectedRowColor = null;
}

var urlmapperAsync = new urlmapperadminajax(UrlMapperCallback);
urlmapperAsync.serverErrorFunc = Jaws_Ajax_ServerError;
urlmapperAsync.onInit = showWorkingNotification;
urlmapperAsync.onComplete = hideWorkingNotification;

var urlmapperSync  = new urlmapperadminajax();
urlmapperSync.serverErrorFunc = Jaws_Ajax_ServerError;
urlmapperSync.onInit = showWorkingNotification;
urlmapperSync.onComplete = hideWorkingNotification;

var evenColor = '#fff';
var oddColor  = '#edf3fe';

//Current map
var selectedMap = null;

var cacheMapTemplate = null;
var cacheEditorMapTemplate = null;

var aliasesComboDiv = null;

//Which row selected in DataGrid
var selectedRow = null;
var selectedRowColor = null;
