<?php
/**
 * Users Core Gadget
 *
 * @category   Gadget
 * @package    Users
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class UsersHTML extends Jaws_GadgetHTML
{
    /**
     * Gadget constructor
     *
     * @access       public
     */
    function UsersHTML()
    {
        $this->Init('Users');
    }

    /**
     * Default Action
     *
     * @access  public
     * @return  string  HTML content of DefaultAction
     */
    function DefaultAction()
    {
        $layoutGadget = $GLOBALS['app']->LoadGadget('Users', 'LayoutHTML');
        return $layoutGadget->LoginBox();
    }

    /**
     * Verifies if user/email/(captcha) are valid, if they are a mail
     * is sent to user with a secret (MD5) key
     *
     * @access  public
     */
    function SendRecoverKey()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/Users/password_recovery') === 'false') {
            return parent::_404();
        }

        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('username', 'email', 'captcha', 'captchaKey'),
                              'post');
        $error  = '';

        require_once JAWS_PATH . 'include/Jaws/Header.php';

        $GLOBALS['app']->Registry->LoadFile('Policy');
        $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
        if ($_captcha != 'DISABLED') {
            require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
            $captcha = new $_captcha();
            if (!$captcha->Check()) {
                $GLOBALS['app']->Session->PushSimpleResponse(_t('GLOBAL_CAPTCHA_ERROR_DOES_NOT_MATCH'), 'Users.ForgotPassword');
                Jaws_Header::Location($this->GetURLFor('ForgotPassword'));
            }
        }

        $model  = $GLOBALS['app']->LoadGadget('Users', 'Model');
        $result = $model->SendRecoveryKey($post['username'], $post['email']);
        if (Jaws_Error::IsError($result)) {
            $GLOBALS['app']->Session->PushSimpleResponse($result->GetMessage(), 'Users.ForgotPassword');
        } else {
            $GLOBALS['app']->Session->PushSimpleResponse(_t('USERS_FORGOT_MAIL_SENT'), 'Users.ForgotPassword');
        }
        Jaws_Header::Location($this->GetURLFor('ForgotPassword'));
    }

    /**
     * Check if given recovery key really exists, it it exists it generates
     * a new password (pronounceable) and sends it to user mailbox
     *
     * @access  public
     * @return  string  XHTML template
     */
    function ChangePassword()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/Users/password_recovery') === 'false') {
            return parent::_404();
        }

        $request =& Jaws_Request::getInstance();
        $key     = $request->get('key', 'get');

        $model  = $GLOBALS['app']->LoadGadget('Users', 'Model');
        $result = $model->ChangePassword($key);

        if (Jaws_Error::IsError($result)) {
            return $result->GetMessage();
        }
        return _t('USERS_FORGOT_PASSWORD_CHANGED');
    }

    /**
     * Password recovery
     *
     * @access  public
     * @return  string  XHTML template
     */
    function ForgotPassword()
    {
        if ($GLOBALS['app']->Registry->Get('/gadgets/Users/password_recovery') === 'false') {
            return parent::_404();
        }

        // Load the template
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('ForgotPassword.html');
        $tpl->SetBlock('forgot');
        $tpl->SetVariable('base_script', BASE_SCRIPT);
        $tpl->SetVariable('title', _t('USERS_FORGOT_REMEMBER'));
        $tpl->SetVariable('username', _t('USERS_USERS_USERNAME'));
        $tpl->SetVariable('email', _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('remember', _t('USERS_FORGOT_REMEMBER'));

         $GLOBALS['app']->Registry->LoadFile('Policy');
         $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
         if ($_captcha != 'DISABLED') {
            require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
            $captcha = new $_captcha();
            $captchaRes = $captcha->Get();
            $tpl->SetBlock('forgot/captcha');
            $tpl->SetVariable('lbl_captcha', _t('GLOBAL_CAPTCHA_CODE'));
            $tpl->SetVariable('captcha', $captchaRes['captcha']->Get());
            if (!empty($captchaRes['entry'])) {
                $tpl->SetVariable('captchavalue', $captchaRes['entry']->Get());
            }
            $tpl->SetVariable('captcha_msg', _t('GLOBAL_CAPTCHA_CODE_DESC'));
            $tpl->ParseBlock('forgot/captcha');
        }

        if ($response = $GLOBALS['app']->Session->PopSimpleResponse('Users.ForgotPassword')) {
            $tpl->SetBlock('forgot/response');
            $tpl->SetVariable('msg', $response);
            $tpl->ParseBlock('forgot/response');
        }
        $tpl->ParseBlock('forgot');
        return $tpl->Get();
    }

    /**
     * Prepares a simple form to update user's data (name, email, password)
     *
     * @access  public
     * @return  string  XHTML template of a form
     */
    function YourAccount()
    {
        $username = $GLOBALS['app']->Session->GetAttribute('username');
        if (empty($username) || $username == 'anonymous') {
            require_once JAWS_PATH . 'include/Jaws/Header.php';
            Jaws_Header::Location($GLOBALS['app']->Map->GetURLFor('Users', 'LoginBox'), true);
        }

        require_once JAWS_PATH . 'include/Jaws/User.php';
        $jUser = new Jaws_User;
        $info  = $jUser->GetInfoById($GLOBALS['app']->Session->GetAttribute('user_id'));

        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');

        // Load the template
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('YourProfile.html');
        $tpl->SetBlock('your_profile');
        $tpl->SetVariable('title', _t('USERS_USERS_ACCOUNT_INFO'));
        $tpl->SetVariable('base_script', BASE_SCRIPT);
        $tpl->SetVariable('update', _t('USERS_USERS_ACCOUNT_UPDATE'));
        $tpl->SetVariable('email', _t('GLOBAL_EMAIL'));
        $tpl->SetVariable('email_value', $xss->filter($info['email']));
        $tpl->SetVariable('url', _t('GLOBAL_URL'));
        $tpl->SetVariable('url_value', $xss->filter($info['url']));
        $tpl->SetVariable('realname', _t('USERS_USERS_REALNAME'));
        $tpl->SetVariable('realname_value', $xss->filter($info['name']));
        $tpl->SetVariable('password', _t('USERS_USERS_PASSWORD'));
        $tpl->SetVariable('emptypassword', _t('USERS_NOCHANGE_PASSWORD'));
        $tpl->SetVariable('password', _t('USERS_USERS_PASSWORD'));
        $tpl->SetVariable('checkpassword', _t('USERS_USERS_PASSWORD_VERIFY'));
        if ($response = $GLOBALS['app']->Session->PopSimpleResponse('Users.YourAccount')) {
            $tpl->SetBlock('your_profile/response');
            $tpl->SetVariable('msg', $response);
            $tpl->ParseBlock('your_profile/response');
        }
        $tpl->ParseBlock('your_profile');
        return $tpl->Get();
    }

    /**
     * Updates user information
     *
     * @access  public
     */
    function UpdateAccount()
    {
        $request =& Jaws_Request::getInstance();
        $post = $request->get(array('realname', 'email', 'url', 'change_password',
                                    'password', 'password_check', 'captcha', 'captchaKey'),
                              'post');

        $model = $GLOBALS['app']->LoadGadget('Users', 'Model');
        $result = $model->UpdateAccount($GLOBALS['app']->Session->GetAttribute('user_id'),
                                        $GLOBALS['app']->Session->GetAttribute('username'),
                                        $post['realname'],
                                        $post['email'],
                                        $post['url'],
                                        $post['password'],
                                        $post['password_check'],
                                        ($post['password'] != ''));

        if (!Jaws_Error::IsError($result)) {
            $GLOBALS['app']->Session->PushSimpleResponse(_t('USERS_MYACCOUNT_UPDATED'), 'Users.YourAccount');
        } else {
            $GLOBALS['app']->Session->PushSimpleResponse($result->GetMessage(), 'Users.YourAccount');
        }
        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Location($this->GetURLFor('YourAccount'));
    }

    /**
     * Calls Login box
     *
     * @access  public
     */
    function LoginBox()
    {
        $layoutGadget = $GLOBALS['app']->LoadGadget('Users', 'LayoutHTML');
        return $layoutGadget->LoginBox();
    }

    /**
     * Logins an user, if something goes wrong then redirect user to previous page
     * and notify the error
     *
     * @access  public
     */
    function Login()
    {
        $request =& Jaws_Request::getInstance();
        $post    = $request->get(array('username', 'password', 'remember'), 'post');

        $login = $GLOBALS['app']->Session->Login($post['username'], $post['password'], $post['remember']);
        if (Jaws_Error::isError($login)) {
            $GLOBALS['app']->Session->PushSimpleResponse($login->GetMessage(), 'Users');
        }

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Referrer();
    }

    /**
     * Logout an user
     *
     * @access  public
     */
    function Logout()
    {
        if ($GLOBALS['app']->Session->GetAttribute('username') != 'anonymous') {
            $GLOBALS['app']->Session->Logout();
        }

        require_once JAWS_PATH . 'include/Jaws/Header.php';
        Jaws_Header::Referrer();
    }

    /**
     * Prepares the NoPermission HTML template
     *
     * @access  public
     * @param   string  $user    Username
     * @param   string  $gadget  Gadget user is requesting
     * @param   string  $action  The 'denied' action
     * @return  string  HTML template
     */
    function ShowNoPermission($user, $gadget, $action)
    {
        $GLOBALS['app']->Translate->LoadTranslation('Users', JAWS_PATH . 'gadgets');

        // Load the template
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('NoPermission.html');
        $tpl->SetBlock('NoPermission');
        $tpl->SetVariable('nopermission', _t('USERS_NO_PERMISSION_TITLE'));
        $tpl->SetVariable('description', _t('USERS_NO_PERMISSION_DESC', $gadget, $action));
        $tpl->SetVariable('admin_script', BASE_SCRIPT);
        $tpl->SetVariable('site-name', $GLOBALS['app']->Registry->Get('/config/site_name'));
        $tpl->SetVariable('site-description', $GLOBALS['app']->Registry->Get('/config/site_description'));
        if ($user == 'anonymous') {
            $url = BASE_SCRIPT . '?gadget=ControlPanel&amp;action=ResetLogin';
            $tpl->SetBlock('NoPermission/anonymous');
            $tpl->SetVariable('anon_description', _t('USERS_NO_PERMISSION_ANON_DESC', $url));
            $tpl->ParseBlock('NoPermission/anonymous');
        }
        $tpl->ParseBlock('NoPermission');
        return $tpl->Get();
    }

    /**
     * Tells the user the registation process is done
     *
     * @access  public
     * @return  string  XHTML of template
     */
    function Registered()
    {
        // Load the template
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('Registered.html');
        $tpl->SetBlock('registered');
        $tpl->SetVariable('title', _t('USERS_REGISTER_REGISTERED'));
        $tpl->SetVariable('registered_msg', _t('USERS_REGISTER_REGISTERED_MSG', $this->GetURLFor('LoginBox')));
        $tpl->ParseBlock('registered');
        return $tpl->Get();
    }

    /**
     * Register the user
     *
     * @access  public
     */
    function RegisterUser()
    {
        $request =& Jaws_Request::getInstance();
        $step    = $request->get('step', 'post');
        $error   = '';

        $post = $request->get(array('username', 'realname', 'email', 'url', 'random_password',
                                    'password', 'password_check', 'captcha', 'captchaKey'),
                              'post');

        $GLOBALS['app']->Registry->LoadFile('Policy');
        $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
        if ($_captcha != 'DISABLED') {
            require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
            $captcha = new $_captcha();
            if (!$captcha->Check()) {
                $error = _t('GLOBAL_CAPTCHA_ERROR_DOES_NOT_MATCH');
            }
        }

        require_once JAWS_PATH . 'include/Jaws/Header.php';

        if (empty($error)) {
            $uModel = $GLOBALS['app']->LoadGadget('Users', 'Model');
            $anon_type = (int) $GLOBALS['app']->Registry->Get('/config/anon_type');
            $anon_type = empty($anon_type)? 2 : $anon_type; //anon_type can't be super-admin
            $result = $uModel->CreateUser($post['username'],
                                          $post['email'],
                                          $post['url'],
                                          $post['realname'],
                                          $post['password'],
                                          $post['password_check'],
                                          ($post['password'] == ''),
                                          $GLOBALS['app']->Registry->Get('/config/anon_type'),
                                          $GLOBALS['app']->Registry->Get('/config/anon_group'));
            if ($result === true) {
                Jaws_Header::Location($this->GetURLFor('Registered'));
            } else {
                $error = $result;
            }
        }

        if (!empty($error)) {
            $GLOBALS['app']->Session->PushSimpleResponse($error, 'Users.Register');
            Jaws_Header::Location($this->GetURLFor('Register'));
        }
    }

    /**
     * Prepares a single form to get registered
     *
     * @access  public
     * @return  string  XHTML of template
     */
    function Register()
    {
        if ($GLOBALS['app']->Registry->Get('/config/anon_register') == 'false') {
            return parent::_404();
        }

        // Load the template
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('Register.html');
        $username = $GLOBALS['app']->Session->GetAttribute('username');
        if (!empty($username) && $username != 'anonymous') {
            require_once JAWS_PATH . 'include/Jaws/Header.php';
            Jaws_Header::Referrer();
        } else {
            $tpl->SetBlock('register');
            $tpl->SetVariable('title', _t('USERS_REGISTER'));
            $tpl->SetVariable('base_script', BASE_SCRIPT);
            $tpl->SetVariable('username', _t('USERS_USERS_USERNAME'));
            $tpl->SetVariable('email', _t('GLOBAL_EMAIL'));
            $tpl->SetVariable('url', _t('GLOBAL_URL'));
            $tpl->SetVariable('realname', _t('USERS_USERS_REALNAME'));
            $tpl->SetVariable('sendpassword', _t('USERS_USERS_SEND_AUTO_PASSWORD'));
            $tpl->SetVariable('password', _t('USERS_USERS_PASSWORD'));
            $tpl->SetVariable('checkpassword', _t('USERS_USERS_PASSWORD_VERIFY'));
            $tpl->SetVariable('validusernames', _t('USERS_REGISTER_VALID_USERNAMES'));
            $tpl->SetVariable('register', _t('USERS_REGISTER'));
            $GLOBALS['app']->Registry->LoadFile('Policy');
            $_captcha = $GLOBALS['app']->Registry->Get('/gadgets/Policy/captcha');
            if ($_captcha != 'DISABLED') {
                require_once JAWS_PATH . 'gadgets/Policy/captchas/' . $_captcha . '.php';
                $captcha = new $_captcha();
                $captchaRes = $captcha->Get();
                $tpl->SetBlock('register/captcha');
                $tpl->SetVariable('lbl_captcha', _t('GLOBAL_CAPTCHA_CODE'));
                $tpl->SetVariable('captcha', $captchaRes['captcha']->Get());
                if (!empty($captchaRes['entry'])) {
                    $tpl->SetVariable('captchavalue', $captchaRes['entry']->Get());
                }
                $tpl->SetVariable('captcha_msg', _t('GLOBAL_CAPTCHA_CODE_DESC'));
                $tpl->ParseBlock('register/captcha');
            }
            if ($response = $GLOBALS['app']->Session->PopSimpleResponse('Users.Register')) {
                $tpl->SetBlock('register/response');
                $tpl->SetVariable('msg', $response);
                $tpl->ParseBlock('register/response');
            }
            $tpl->ParseBlock('register');
        }
        return $tpl->Get();
    }
}