<?php
/**
 * Users Core Gadget
 *
 * @category   GadgetInfo
 * @package    Users
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class UsersInfo extends Jaws_GadgetInfo
{
    /**
     * Sets info about Users gadget
     *
     * @access  public
     */
    function UsersInfo()
    {
        parent::Init('Users');
        $this->GadgetName(_t('USERS_NAME'));
        $this->GadgetDescription(_t('USERS_DESCRIPTION'));
        $this->GadgetVersion('0.8.2');
        $this->Doc('gadget/Users');
        $this->SetAttribute('core_gadget', true);

        $acls = array(
            'default',
            'ManageUsers',
            'ManageGroups',
            'ManageACL',
        );
        $this->PopulateACLs($acls);
    }
}