<?php
/**
 * Users Gadget (layout actions for client side)
 *
 * @category   Gadget
 * @package    Users
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2007-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class UsersLayoutHTML 
{
    /**
     * Calls Login box
     *
     * @access public
     * @return string template content
     */
    function LoginBox()
    {
        $tpl = new Jaws_Template('gadgets/Users/templates/');
        $tpl->Load('LoginBox.html');

        if (!$GLOBALS['app']->Session->Logged()) {
            $tpl->SetBlock('LoginBox');
            $tpl->SetVariable('title', _t('USERS_LOGIN_TITLE'));
            $tpl->SetVariable('base_script', BASE_SCRIPT);
            $tpl->SetVariable('login', _t('GLOBAL_LOGIN'));
            $tpl->SetVariable('username', _t('GLOBAL_USERNAME'));
            $tpl->SetVariable('password', _t('GLOBAL_PASSWORD'));
            $tpl->SetVariable('remember', _t('GLOBAL_REMEMBER_ME'));

            if ($GLOBALS['app']->Registry->Get('/config/anon_register') == 'true') {
                $link =& Piwi::CreateWidget('Link', _t('USERS_REGISTER'),
                                            $GLOBALS['app']->Map->GetURLFor('Users', 'Register'));
                $tpl->SetVariable('user-register', $link->Get());
            }

            if ($GLOBALS['app']->Registry->Get('/gadgets/Users/password_recovery') == 'true') {
                $link =& Piwi::CreateWidget('Link', _t('USERS_FORGOT_PASSWORD'),
                                            $GLOBALS['app']->Map->GetURLFor('Users', 'ForgotPassword'));
                $tpl->SetVariable('forgot-password', $link->Get());
            }

            if ($response = $GLOBALS['app']->Session->PopSimpleResponse('Users')) {
                $tpl->SetBlock('LoginBox/response');
                $tpl->SetVariable('msg', $response);
                $tpl->ParseBlock('LoginBox/response');
            }

            $tpl->ParseBlock('LoginBox');
        } else {
            $tpl->SetBlock('UserBox');
            $tpl->SetVariable('title', _t('GLOBAL_MY_ACCOUNT'));

            require_once JAWS_PATH . 'include/Jaws/User.php';
            $uModel = new Jaws_User;
            $uInfo = $uModel->GetInfoById($GLOBALS['app']->Session->GetAttribute('user_id'));
            if ($uInfo !== false) {
                $tpl->SetVariable('user_name',  $uInfo['username']);
                $tpl->SetVariable('user_title', $uInfo['name']);
                $tpl->SetVariable('user_email', $uInfo['email']);
                $tpl->SetVariable('user_profile', _t('USERS_EDIT_PROFILE'));
                $tpl->SetVariable('profile_url', $GLOBALS['app']->Map->GetURLFor('Users', 'YourAccount'));
                $tpl->SetVariable('user_panel', _t('USERS_CONTROLPANEL'));

                $admin_script = $GLOBALS['app']->Registry->Get('/config/admin_script');
                $tpl->SetVariable('control_url', empty($admin_script)? 'admin.php' : $admin_script);

                $tpl->SetVariable('logout', _t('GLOBAL_LOGOUT'));
                $tpl->SetVariable('logout_url', $GLOBALS['app']->Map->GetURLFor('Users', 'Logout'));
            }
            $tpl->ParseBlock('UserBox');
        }

        return $tpl->Get();
    }
}
