/**
 * Users Javascript actions
 *
 * @category   Ajax
 * @package    Users
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
/**
 * Use async mode, create Callback
 */
var UsersCallback = {
    adduser: function(response) {
        if (response[0]['css'] == 'notice-message') {
            //$('user_search_entry').value = '';
            getUsers();
            stopAction();
        }
        showResponse(response);
    },

    updateuser: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getUsers();
        }
        //stopAction();
        showResponse(response);
    },

    updatemyaccount: function(response) {
        showResponse(response);
    },

    deleteuser: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getUsers();
            stopAction();
        }
        showResponse(response);
    },

    addgroup: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getGroups();
            stopAction();
        }
        showResponse(response);
    },

    updategroup: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getGroups();
        }
        //stopAction();
        showResponse(response);
    },

    deletegroup: function(response) {
        if (response[0]['css'] == 'notice-message') {
            getGroups();
            stopAction();
        }
        showResponse(response);
    },

    saveuseracl: function(response) {
        showResponse(response);
    },

    savegroupacl: function(response) {
        showResponse(response);
    },

    resetuseracl: function(response) {
        if (response[0]['css'] == 'notice-message') {
            manageUserACL();
        }
        showResponse(response);
    },

    resetgroupacl: function(response) {
        if (response[0]['css'] == 'notice-message') {
            manageGroupACL();
        }
        showResponse(response);
    },

    adduserstogroup: function(response) {
        showResponse(response);
    },

    saveadvancedoptions: function(response) {
        showResponse(response);
    },

    savesettings: function(response) {
        showResponse(response);
    }
}

/**
 * Search user function
 */
function searchUser()
{
    getUsers();
}

/**
 * Get users list
 */
function getUsers()
{
    resetCombo($('users_combo'));
    //var userMatch = $('user_search_entry').value;
    var userList  = usersSync.getusers($('show_all').checked, null);
    if (userList != false) {
        var combo = $('users_combo');
        var i = 0;
        userList.each(function(value, index) {
            var op = new Option(value['username'], value['id']);
            if (i % 2 == 0) {
                op.style.backgroundColor = evenColor;
            } else {
                op.style.backgroundColor = oddColor;
            }
            combo.options[combo.options.length] = op;
            if (selectedUser == value['id']) {
                combo.selectedIndex = i;
            }
            i++;
        });
    }
}

/**
 * Get groups list
 */
function getGroups()
{
    resetCombo($('groups_combo'));
    var groupList = usersSync.getgroups();
    if (groupList) {
        var combo = $('groups_combo');
        var i = 0;
        groupList.each(function(value, index) {
            var op = new Option(value['title'], value['id']);
            if (i % 2 == 0) {
                op.style.backgroundColor = evenColor;
            } else {
                op.style.backgroundColor = oddColor;
            }
            combo.options[combo.options.length] = op;
            if (selectedGroup == value['id']) {
                combo.selectedIndex = i;
            }
            i++;
        });
    }
}

/**
 * Resets the users list
 */
function resetCombo(combo)
{
    while(combo.options.length != 0) {
        combo.options[0] = null;
    }
}

/**
 * Saves data / changes
 */
function saveUser()
{
    if (currentAction == 'AdvancedUserOptions') {
        usersAsync.saveadvancedoptions(selectedUser,
                                       $('user_language').value,
                                       $('user_theme').value,
                                       $('user_editor').value,
                                       $('user_timezone').value);
    } else {
        if ($('pass1').value != $('pass2').value) {
            alert(wrongPassword);
            return false;
        }

        if (jawsTrim($('username').value) == '' ||
            jawsTrim($('name').value)     == '' ||
            jawsTrim($('email').value)    == '') {
            alert(incompleteUserFields);
            return false;
        }

        if ($('exponent')) {
            setMaxDigits(128);
            var pub_key = new RSAPublicKey($('exponent').value, $('modulus').value, 128);
            var password = encryptedString(pub_key, $('pass1').value);
        } else {
            var password = $('pass1').value;
        }

        if(selectedUser == null) {
            if (jawsTrim($('pass1').value) == '') {
                alert(incompleteUserFields);
                return false;
            }

            usersAsync.adduser($('username').value,
                               password,
                               $('name').value,
                               $('email').value,
                               $('url').value,
                               $('user_group').value,
                               $('user_type').value,
                               $('enabled').value);
        } else {
            usersAsync.updateuser(selectedUser,
                                  $('username').value,
                                  password,
                                  $('name').value,
                                  $('email').value,
                                  $('url').value,
                                  $('user_type').value,
                                  $('enabled').value);
        }
    }
}

/**
 * Saves data / changes on the group's form
 */
function saveGroup()
{
    if (currentAction == 'ManageUserGroups') {
        addUserstoGroup();
    } else {
        if (jawsTrim($('name').value) == '') {
            alert(incompleteGroupFields);
            return false;
        }

        if (selectedGroup == null) {
            usersAsync.addgroup($('name').value,
                                $('title').value,
                                $('description').value);
        } else {
            usersAsync.updategroup(selectedGroup,
                                  $('name').value,
                                  $('title').value,
                                  $('description').value);
        }
    }
}

/**
 * Saves the users ACL
 */
function saveACL()
{
    var inputs = $('work_area').getElementsByTagName('input');
    var keys   = new Array();
    for(var i=0; i<inputs.length; i++) {
        if (inputs[i].changed) {
            keys[inputs[i].value] = inputs[i].checked;
        }
    }
    usersAsync.saveuseracl(selectedUser, keys);
}

/**
 * Add users to a group
 */
function addUserstoGroup()
{
    var inputs  = $('work_area').getElementsByTagName('input');
    var keys    = new Array();
    var counter = 0;
    for (var i=0; i<inputs.length; i++) {
        if (inputs[i].name.indexOf('group_users') == -1) {
            continue;
        }

        if (inputs[i].checked) {
            keys[counter] = inputs[i].value;
            counter++;
        }
    }
    usersAsync.adduserstogroup(selectedGroup, keys);
}

/**
 * Delete user
 */
function deleteUser()
{
    var answer = confirm(confirmUserDelete);
    if (answer) {
        usersAsync.deleteuser(selectedUser);
    }
}

/**
 * Delete group
 */
function deleteGroup()
{
    var answer = confirm(confirmGroupDelete);
    if (answer) {
        usersAsync.deletegroup(selectedGroup);
    }
}

/**
 * Save the group ACL keys
 */
function saveGroupACL()
{
    var inputs = $('work_area').getElementsByTagName('input');
    var keys   = new Array();
    for(var i=0; i<inputs.length; i++) {
        if (inputs[i].changed) {
            keys[inputs[i].value] = inputs[i].checked;
        }
    }
    usersAsync.savegroupacl(selectedGroup, keys);
}

/**
 * Reset the ACL keys of current user
 */
function resetUserACL()
{
    var answer = confirm(confirmResetACL);
    if (answer) {
        usersAsync.resetuseracl(selectedUser);
    }
}

/**
 * Reset the ACL keys of current group
 */
function resetGroupACL()
{
    var answer = confirm(confirmResetACL);
    if (answer) {
        usersAsync.resetgroupacl(selectedGroup);
    }
}

/**
 * Add user - FORM
 */
function addUser()
{
    if (cacheForm == null) {
        cacheForm = usersSync.getuserform();
    }

    $('cancel_action').style.display = 'block';
    $('save_user').style.display = 'block';
    $('add_user').style.display = 'none';
    //$('users_combo').disabled = true;
    $('work_area').innerHTML = cacheForm;
    $('user_group').parentNode.style.display = 'none';
    $('right_menu').style.visibility = 'hidden';
    selectedUser = null;

    var groups = usersSync.getgroups();
    if (groups != null) {
        while($('user_group').options.length != 0) {
            $('user_group').options[0] = null;
        }

        var op = new Option();
        op.id = '-';
        op.text = noGroup;
        $('user_group').options[$('user_group').options.length] = op;

        var i = 1;
        groups.each(function(value, index) {
            op = new Option();
            op.value = value['id'];
            op.text = value['title'];
            if (i % 2 == 0) {
                op.style.backgroundColor = evenColor;
            } else {
                op.style.backgroundColor = oddColor;
            }
            $('user_group').options[$('user_group').options.length] = op;
            i++;
        });
        $('user_group').parentNode.style.display = 'block';
    }
    currentAction = 'AddUser';
}

/**
 * Add group
 */
function addGroup()
{
    if (cacheForm == null) {
        cacheForm = usersSync.getgroupform();
    }

    $('cancel_action').style.display = 'block';
    $('save_group').style.display = 'block';
    $('add_group').style.display = 'none';
    //$('groups_combo').disabled = true;
    $('work_area').innerHTML = cacheForm;
    $('right_menu').style.visibility = 'hidden';

    selectedGroup = null;
    currentAction = 'AddGroup';
}

/**
 * Edit user
 */
function editUser(uid)
{
    if (uid == 0) return;
    if (cacheForm == null) {
        cacheForm = usersSync.getuserform();
    }

    currentAction = 'EditUser';
    $('cancel_action').style.display = 'block';
    $('save_user').style.display = 'block';
    $('manage_acl').style.display = 'block';
    $('delete_user').style.display = 'block';
    $('add_user').style.display = 'none';
    $('save_acl').style.display = 'none';
    $('reset_acl').style.display = 'none';
    $('work_area').innerHTML = cacheForm;
    $('user_group').parentNode.style.display = 'none';
    $('right_menu').style.visibility = 'visible';

    selectedUser = uid;
    var uInfo = usersSync.getuser(selectedUser);

    $('user_avatar').src = uInfo['image'];
    $('username').value  = uInfo['username'];
    $('name').value      = uInfo['name'];
    $('email').value     = uInfo['email'];
    $('url').value       = uInfo['url'];
    $('userInfo_action').value = 'EditUser';

    if (uInfo['user_type'] == 0) {
        $('user_type').selectedIndex = 0;
    } else if (uInfo['user_type'] == 1) {
        //First value is super-admin or just admin?
        if ($('user_type').options[0].value == 0) { //super-admin
            $('user_type').selectedIndex = 1; //Then we should check the next one (which is admin)
        } else {
            $('user_type').selectedIndex = 0; //First is only admin (no super-admin, check this)
        }
    } else {
        $('user_type').selectedIndex = ($('user_type').options.length-1);
    }
    $('enabled').value = uInfo['enabled'];
    currentAction = 'EditUser';
}

/**
 * Edit group
 */
function editGroup(guid)
{
    if (guid == 0) return;
    if (cacheForm == null) {
        cacheForm = usersSync.getgroupform();
    }

    $('cancel_action').style.display = 'block';
    $('save_group').style.display = 'block';
    $('manage_acl').style.display = 'block';
    $('add_usergroups').style.display = 'block';
    $('delete_group').style.display = 'block';
    $('add_group').style.display = 'none';
    $('save_acl').style.display = 'none';
    $('reset_acl').style.display = 'none';
    $('work_area').innerHTML = cacheForm;
    $('right_menu').style.visibility = 'visible';

    selectedGroup = guid;
    currentAction = 'EditGroup';

    var gInfo = usersSync.getgroup(selectedGroup);
    $('name').value        = gInfo['name'];
    $('title').value       = gInfo['title'];
    $('description').value = gInfo['description'];
}

/**
 * Stops doing a certain action
 */
function stopAction()
{
    switch(currentAction) {
    case 'EditUser':
    case 'AddUser':
        $('add_user').style.display = 'block';
        $('save_user').style.display = 'none';
        $('manage_acl').style.display = 'none';
        $('save_acl').style.display = 'none';
        $('reset_acl').style.display = 'none';
        $('delete_user').style.display = 'none';
        $('users_combo').selectedIndex = -1;
        $('work_area').innerHTML = '';
        $('cancel_action').style.display = 'none';
        $('right_menu').style.visibility = 'hidden';
        selectedUser = null;
        break;
    case 'ManageUserACL':
    case 'AdvancedUserOptions':
        $('save_acl').style.display = 'none';
        $('reset_acl').style.display = 'none';
        $('save_user').style.display = 'block';
        editUser(selectedUser);
        break;
    case 'EditGroup':
    case 'AddGroup':
        $('add_group').style.display = 'block';
        $('save_group').style.display = 'none';
        $('manage_acl').style.display = 'none';
        $('save_acl').style.display = 'none';
        $('reset_acl').style.display = 'none';
        $('delete_group').style.display = 'none';
        $('groups_combo').selectedIndex = -1;
        $('work_area').innerHTML = '';
        $('cancel_action').style.display = 'none';
        $('add_usergroups').style.display = 'none';
        $('right_menu').style.visibility = 'hidden';
        selectedGroup = null;
        break;
    case 'ManageGroupACL':
    case 'ManageUserGroups':
        $('save_acl').style.display = 'none';
        $('reset_acl').style.display = 'none';
        $('save_group').style.display = 'block';
        editGroup(selectedGroup);
        break;
    }
}

/**
 * Converts an ACL struct (array) to a xtree obj returning its XHTML content
 */
function convertToTree(keys)
{
    tree = new WebFXTree(permissionsMsg);
    tree.openIcon = 'gadgets/Users/images/openfoldericon.png';
    for(gadget in keys) {
        if (typeof(keys[gadget]) == 'function') {
            continue;
        }
        var gadgetItem = new WebFXTreeItem(gadget);

        for(aclKey in keys[gadget]) {
            if (keys[gadget][aclKey]['desc'] == undefined) {
                continue;
            }

            //Create checkbox with its label and all that sexy stuff
            var div = document.createElement('div');

            var chkbox = document.createElement('input');
            chkbox.setAttribute('type', 'checkbox');
            chkbox.setAttribute('name', 'acls[]');
            chkbox.setAttribute('value', keys[gadget][aclKey]['name']);
            if (keys[gadget][aclKey]['value'] == true) {
                chkbox.defaultChecked = true;
                chkbox.setAttribute('checked', true);
            }
            chkbox.setAttribute('id', keys[gadget][aclKey]['name']);
            //Little trick to know which values have changed their values
            chkbox.setAttribute('changed', false);
            chkbox.setAttribute('onclick', 'javascript: this.changed = true;');
            chkbox.onclick = function() {
                this.changed = true;
            }
            var label = document.createElement('label');
            label.htmlFor = keys[gadget][aclKey]['name'];
            label.appendChild(document.createTextNode(keys[gadget][aclKey]['desc']));

            div.appendChild(chkbox);
            div.appendChild(label);

            var aclItem = new WebFXTreeItem(div.innerHTML);
            gadgetItem.add(aclItem);
        }
        tree.add(gadgetItem);
    }
    return tree.toString();
}

/**
 * Show the advanced options for user
 */
function advancedUserOptions()
{
    var advancedOptions = usersSync.getadvuseroptionsui(selectedUser);
    $('work_area').innerHTML = advancedOptions;
    $('save_user').style.display = 'block';
    $('save_acl').style.display  = 'none';
    $('reset_acl').style.display = 'none';
    $('manage_acl').style.display = 'none';
    $('delete_user').style.display = 'none';
    $('right_menu').style.visibility = 'hidden';
    currentAction = 'AdvancedUserOptions';
}

/**
 * Show user-ACL keys
 */
function manageUserACL()
{
    var aclKeys = usersSync.getuseraclkeys(selectedUser);
    $('work_area').innerHTML = convertToTree(aclKeys);
    $('save_user').style.display = 'none';
    $('save_acl').style.display  = 'block';
    $('reset_acl').style.display = 'block';
    $('manage_acl').style.display = 'none';
    $('delete_user').style.display = 'none';
    $('right_menu').style.visibility = 'hidden';
    currentAction = 'ManageUserACL';
}

/**
 * Show group-ACL keys
 */
function manageGroupACL()
{
    var aclKeys = usersSync.getgroupaclkeys(selectedGroup);
    $('work_area').innerHTML = convertToTree(aclKeys);
    $('save_group').style.display = 'none';
    $('save_acl').style.display  = 'block';
    $('reset_acl').style.display = 'block';
    $('manage_acl').style.display = 'none';
    $('add_usergroups').style.display = 'none';
    $('delete_group').style.display = 'none';
    $('right_menu').style.visibility = 'hidden';
    currentAction = 'ManageGroupACL';
}

/**
 * Show a simple-form with checkboxes so users can check their groups
 */
function addUsersToGroup()
{
    $('work_area').innerHTML = usersSync.getusergroupsform(selectedGroup);
    $('save_group').style.display = 'block';
    $('save_acl').style.display  = 'none';
    $('reset_acl').style.display = 'none';
    $('manage_acl').style.display = 'none';
    $('add_usergroups').style.display = 'none';
    $('delete_group').style.display = 'none';
    $('right_menu').style.visibility = 'hidden';
    currentAction = 'ManageUserGroups';
}

/**
 * Save settings
 */
function saveSettings()
{
    var priority = $('priority').value;
    var method   = $('auth_method').value;
    var anon     = $('anon_register').value;
    var type     = $('anon_type').value;
    var group    = $('anon_group').value;
    var recover  = $('password_recovery').value;

    usersAsync.savesettings(priority, method, anon, type, group, recover);
}

/**
 * Update myAccount
 */
function updateMyAccount()
{
    if ($('pass1').value != $('pass2').value) {
        alert(wrongPassword);
        return false;
    }

    if (jawsTrim($('username').value) == '' ||
        jawsTrim($('name').value)     == '' ||
        jawsTrim($('email').value)    == '') {
        alert(incompleteUserFields);
        return false;
    }

    if ($('exponent')) {
        setMaxDigits(128);
        var pub_key = new RSAPublicKey($('exponent').value, $('modulus').value, 128);
        var password = encryptedString(pub_key, $('pass1').value);
    } else {
        var password = $('pass1').value;
    }

    usersAsync.updatemyaccount($('id').value,
                               $('username').value,
                               password,
                               $('name').value,
                               $('email').value,
                               $('url').value);
}

var usersAsync = new usersadminajax(UsersCallback);
usersAsync.serverErrorFunc = Jaws_Ajax_ServerError;
usersAsync.onInit = showWorkingNotification;
usersAsync.onComplete = hideWorkingNotification;

var usersSync  = new usersadminajax();
usersSync.serverErrorFunc = Jaws_Ajax_ServerError;
usersSync.onInit = showWorkingNotification;
usersSync.onComplete = hideWorkingNotification;

//Current user
var selectedUser = null;
//current group
var selectedGroup = null;
//show all users
var showAll = false;
//Combo colors
var evenColor = '#fff';
var oddColor  = '#edf3fe';

//Cache for saving the group|user-form template
var cacheForm = null;
//Cache for group-user management
var cacheUserGroupForm = null;

//Which action are we runing?
var currentAction = null;
//We already loaded the xtree lib?
var xtreeLoaded = false;
//xtree obj
var xtree = null;
