<?php
/**
 * Webcam Gadget Admin
 *
 * @category   GadgetAdmin
 * @package    Webcam
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2004-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
class WebcamAdminHTML extends Jaws_GadgetHTML
{
    /**
     * Constructor
     *
     * @access public
     */
    function WebcamAdminHTML()
    {
        $this->Init('Webcam');
    }

    /**
     * Callback to show short URL's
     *
     * @access  private
     * @param   string  $url   Long URL
     * @return  string  Short URL
     */
    function ShowShortURL($url)
    {
        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        $clean_url = $xss->filter($url);
        if (strlen($url) > 40) {
            return "<a title=\"{$clean_url}\" href=\"{$clean_url}\">" .
                $xss->filter(substr($url, 0, 40)) . "...</a>";
        }

        return "<a title=\"{$clean_url}\" href=\"{$clean_url}\">".$clean_url."</a>";
    }

    /**
     * Prepares data to add to datagrid
     *
     * @access  public
     * @param   int     $limit  Limit of data
     * @return  array   Data
     */
    function GetWebCams($limit = 0)
    {
        $model = $GLOBALS['app']->LoadGadget('Webcam', 'AdminModel');
        $webcams = $model->GetWebCams($limit);
        if (Jaws_Error::IsError($webcams)) {
            return array();
        }

        $newData = array();
        foreach ($webcams as $webcam) {
            $webcamData = array();
            $webcamData['title'] = $webcam['title'];
            $webcamData['url']   = $this->ShowShortURL($webcam['url']);
            $actions = '';
            if ($this->GetPermission('EditWebcam')) {
                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_EDIT'),
                                            "javascript: editWebcam('".$webcam['id']."');",
                                            STOCK_EDIT);
                $actions.= $link->Get().'&nbsp;';
            }
            if ($this->GetPermission('DeleteWebcam')) {
                $link =& Piwi::CreateWidget('Link', _t('GLOBAL_DELETE'),
                                            "javascript: if (confirm('"._t('WEBCAM_CONFIRM_DELETE_WEBCAM')."')) ".
                                            "deleteWebcam('".$webcam['id']."');",
                                            STOCK_DELETE);
                $actions.= $link->Get().'&nbsp;';
            }
            $webcamData['actions'] = $actions;
            $newData[] = $webcamData;
        }
        return $newData;
    }

    /**
     * Creates the datagrid
     *
     * @access  public
     * @return  string XHTML of datagrid
     */
    function DataGrid()
    {
        $model = $GLOBALS['app']->LoadGadget('Webcam', 'AdminModel');
        $total = $model->TotalOfData('webcam');

        $datagrid =& Piwi::CreateWidget('DataGrid', array());
        $datagrid->SetID('webcam_datagrid');
        $datagrid->SetStyle('width: 100%;');
        $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('GLOBAL_TITLE')));
        $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('GLOBAL_URL')));
        $datagrid->AddColumn(Piwi::CreateWidget('Column', _t('GLOBAL_ACTIONS')));

        return $datagrid->Get();
    }

    /**
     * Handles the admin actions
     *
     * @access  public
     * @return  string HTML content of Admin
     */
    function Admin()
    {
        $this->CheckPermission('default');
        $this->AjaxMe('script.js');

        $tpl = new Jaws_Template('gadgets/Webcam/templates/');
        $tpl->Load('AdminWebcam.html');
        $tpl->SetBlock('webcam');

        $tpl->SetVariable('grid', $this->DataGrid());

        if ($this->GetPermission('AddWebcam')) {
            $cam_form =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'post', '', 'webcam_form');
            $cam_form->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'Webcam'));
            $cam_form->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'AddWebcam'));
            $cam_form->Add(Piwi::CreateWidget('HiddenEntry', 'id', ''));

            require_once JAWS_PATH . 'include/Jaws/Widgets/FieldSet.php';
            $fieldset_webcam = new Jaws_Widgets_FieldSet(_t('WEBCAM_NAME'));

            $titleentry =& Piwi::CreateWidget('Entry', 'title', '');
            $titleentry->SetTitle(_t('GLOBAL_TITLE'));
            $fieldset_webcam->Add($titleentry);

            $urlentry =& Piwi::CreateWidget('Entry', 'url', '');
            $urlentry->SetTitle(_t('GLOBAL_URL'));
            $fieldset_webcam->Add($urlentry);

            $refresh =& Piwi::CreateWidget('SpinButton', 'refresh', 60, '', 5);
            $refresh->SetTitle(_t('WEBCAM_REFRESH_TIME'));
            $refresh->SetDefault(10);
            $fieldset_webcam->Add($refresh);

            $buttonbox =& Piwi::CreateWidget('HBox');
            $buttonbox->SetStyle('float: right;'); //hig style
            $submit =& Piwi::CreateWidget('Button', 'addnewwebcam',
                                          _t('GLOBAL_SAVE', _t('WEBCAM_NAME')), STOCK_SAVE);
            $submit->AddEvent(ON_CLICK, 'javascript: submitForm(this.form);');

            $cancel =& Piwi::CreateWidget('Button', 'cancelform', _t('GLOBAL_CANCEL'), STOCK_CANCEL);
            $cancel->AddEvent(ON_CLICK, 'javascript: cleanForm(this.form);');

            $buttonbox->Add($cancel);
            $buttonbox->Add($submit);

            $cam_form->Add($fieldset_webcam);
            $cam_form->Add($buttonbox);

            $tpl->SetVariable('webcam_form', $cam_form->Get());
        }

        if ($this->GetPermission('UpdateProperties')) {
            $config_form =& Piwi::CreateWidget('Form', BASE_SCRIPT, 'POST');
            $config_form->Add(Piwi::CreateWidget('HiddenEntry', 'gadget', 'Webcam'));
            $config_form->Add(Piwi::CreateWidget('HiddenEntry', 'action', 'UpdateProperties'));

            require_once JAWS_PATH . 'include/Jaws/Widgets/FieldSet.php';
            $fieldset_config = new Jaws_Widgets_FieldSet(_t('GLOBAL_PROPERTIES'));
            $fieldset_config->SetDirection('vertical');
            $fieldset_config->SetStyle('width: 200px;');


            $limitcombo =& Piwi::CreateWidget('Combo', 'limit_random');
            $limitcombo->SetTitle(_t('WEBCAM_RANDOM_LIMIT'));
            for ($i = 1; $i <= 10; $i++) {
                $limitcombo->AddOption($i, $i);
            }

            $limit = $GLOBALS['app']->Registry->Get('/gadgets/Webcam/limit_random');
            if (!$limit || Jaws_Error::IsError($limit)) {
                $limit = 10;
            }

            $limitcombo->SetDefault($limit);

            $fieldset_config->Add($limitcombo);

            $config_form->Add($fieldset_config);
            $submit_config =& Piwi::CreateWidget('Button', 'saveproperties',
                                                 _t('GLOBAL_UPDATE', _t('GLOBAL_PROPERTIES')), STOCK_SAVE);
            $submit_config->SetStyle('float: right;');
            $submit_config->AddEvent(ON_CLICK, 'javascript: updateProperties(this.form);');

            $config_form->Add($submit_config);
            $tpl->SetVariable('config_form', $config_form->Get());
        }

        $tpl->SetVariable('incompleteWebcamFields', _t('GLOBAL_ERROR_INCOMPLETE_FIELDS'));
        $tpl->ParseBlock('webcam');

        return $tpl->Get();
    }
}